/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.RepertoireHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class AddDuwV2RepertoiresAue
extends BoamSubAueBase {
    private static final String CPP_BASIC_DUW41_R6K = "CPP_Basic_DUW41_R6K";
    private static final String RBS_DUW_MAIN_ROLE = "Main_DUW";
    public static final int LOW_VERSION = 14010000;
    private static final int HIGH_VERSION = 20030500;
    private static final String DCI_REFERENCE = "13/109 26-CRH 109 0239-1";
    private static AddDuwV2RepertoiresAue instance = new AddDuwV2RepertoiresAue();
    private Coordinator context = null;
    private SwAllocationMo swAlloc = null;
    private ManagedObject duwV2Repertoire = null;

    public AddDuwV2RepertoiresAue() {
        super(AddDuwV2RepertoiresAue.class);
    }

    public static AddDuwV2RepertoiresAue instance() {
        return instance;
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        this.context = tw.getCoordinator();
        if (this.precondition(RBS_DUW_MAIN_ROLE, this.context)) {
            this.addRepertoire(this.context);
        } else {
            MessageLog.trace((int)9, this.getClass(), (String)"No need to add DUW V2 missing repertoires for this node.");
        }
        return true;
    }

    private boolean precondition(String swAllocationRole, Coordinator context) throws MoAccessException {
        boolean shouldAdd = false;
        this.swAlloc = (SwAllocationMo)RepertoireHelper.getSwAllocationMo("SwAllocation", swAllocationRole, context);
        if (null == this.swAlloc) {
            MessageLog.trace((int)9, this.getClass(), (String)("can not find SWAllocation " + swAllocationRole));
            return shouldAdd;
        }
        ManagedObject[] reps = this.swAlloc.getRepertoireList(context);
        for (int i = 0; i < reps.length; ++i) {
            if (!((RepertoireMo)reps[i]).getName(context).equalsIgnoreCase(CPP_BASIC_DUW41_R6K)) continue;
            return shouldAdd;
        }
        MoIterator itRep = BoamHelper.findMOs((String)"Repertoire");
        while (itRep.hasMoreElements()) {
            ManagedObject mo = itRep.nextMo();
            if (!((RepertoireMo)mo).getName(context).equalsIgnoreCase(CPP_BASIC_DUW41_R6K)) continue;
            this.duwV2Repertoire = mo;
            shouldAdd = true;
            break;
        }
        return shouldAdd;
    }

    private void addRepertoire(Coordinator context) throws MoAccessException {
        if (this.duwV2Repertoire != null) {
            this.swAlloc.actionAddRepertoire(this.duwV2Repertoire, context);
        }
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public int getHighVersion() {
        return 20030500;
    }

    public int getLowVersion() {
        return 14010000;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }
}

