/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.IdGenerator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.SwAllocationMoImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.aue.ConstantFlag;
import se.ericsson.wcdma.rbs.boam.aue.MoSavedInAir;
import se.ericsson.wcdma.rbs.boam.aue.impl.MultiValueMap;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TpaDeviceMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class Air2XAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "13/109 26-CRH 109 0239-1";
    public static final int LOW_VERSION = 13030800;
    private static final int HIGH_VERSION = 15020900;
    public static final String FRO_ID = "froId";
    private static final String[] branchName = new String[]{"A", "B", "C", "D"};
    private static Air2XAue instance = new Air2XAue();
    static final String[] secondaryPiuMo = new String[]{"AiDevice", "DpclDevice", "RetDevice", "TpaDevice", "TrDevice", "RetDeviceSet"};
    static final String[] cable = new String[]{"AntFeederCable", "DigitalCable", "RfCable"};
    private ArrayList deleteMo = new ArrayList();
    private ArrayList auxPluginList = new ArrayList();
    private MultiValueMap savedMo = new MultiValueMap();
    private ArrayList auxToLock = new ArrayList();
    private String savedUniqueHwId = null;
    private int maxTotalOutputPower_2 = -1;
    private Coordinator context = null;
    ManagedObject airPiuType = null;
    private boolean add2ndCable = false;
    private boolean hasSecondSA = false;
    private HashMap saveData = new HashMap();
    private HashMap retSaveData = new HashMap();
    private MultiValueMap retSavedMo = new MultiValueMap();
    private int orgAirState = 1;
    private int orgPassiveRetState = 1;

    protected Air2XAue(Class subClass) {
        super(subClass);
    }

    private Air2XAue() {
        super(Air2XAue.class);
        this.traceEnter("New Air AUE");
    }

    public static Air2XAue instance() {
        return instance;
    }

    public int getLowVersion() {
        return 13030800;
    }

    public int getHighVersion() {
        return 15020900;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerFinish(List commands) throws Exception {
        this.traceEnter("triggerFinish(), Air trigger");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute() for AIR aue");
        MoIterator moIter = BoamHelper.findMOs((String)"Sector");
        ManagedObject swa = null;
        while (moIter.hasMoreElements()) {
            StringBuffer digitalCableName = new StringBuffer("");
            SectorMo sector = (SectorMo)moIter.nextMo();
            TransactionWrapper newTw = this.createTransactionWrapper();
            this.context = newTw.getCoordinator();
            if (this.preConditon(sector, this.context)) {
                String produceName = (String)((ManagedObject)this.auxPluginList.get(0)).getAttribute("productName", this.context);
                String airType = -1 != produceName.indexOf(ConstantFlag.AIR_RRU_PRODUCT_NAME[0]) ? "PiuType=KRC11897/" : "PiuType=KRC118023/";
                ManagedObject parentMo = null;
                parentMo = this.saveMos(sector, digitalCableName);
                MessageLog.trace((int)9, this.getClass(), (String)("Finallly Need to create digitalcable" + digitalCableName.toString()));
                int band = sector.getBand(this.context);
                int numberOfTxBranches = sector.getNumberOfTxBranches(this.context);
                newTw.commit();
                this.deleteOldMo(sector);
                ManagedObject airMo = this.createAir(airType, parentMo);
                ManagedObject passiveRet = this.createPassiveRet(sector);
                this.createAbAndCable(parentMo, sector, airMo, digitalCableName);
                TransactionWrapper createXpTw = this.createTransactionWrapper();
                this.context = createXpTw.getCoordinator();
                ManagedObject airRepertoire = null;
                MoIterator itRep = BoamHelper.findMOs((String)"Repertoire");
                while (itRep.hasMoreElements()) {
                    ManagedObject mo = itRep.nextMo();
                    if (-1 == mo.getRelativeDistinguishedName().indexOf("RBS_AIR")) continue;
                    airRepertoire = mo;
                    break;
                }
                if (swa == null) {
                    MoFactory swAllocationFactory = MoFactoryMgr.instance().lookup("SwAllocation");
                    if (swAllocationFactory == null) {
                        throw new Exception("Can't find factory for MO SwAllocation");
                    }
                    ManagedObject swManagerRoot = airRepertoire.getParent();
                    AttrListImpl attrSw = new AttrListImpl();
                    attrSw.addElement("role", (Object)"RBS_AIR");
                    swa = swAllocationFactory.createMo(swManagerRoot, (AttrList)attrSw, "RBS_AIR", null, this.context);
                    ((SwAllocationMoImpl)swa).actionAddRepertoire(airRepertoire, this.context);
                }
                ((SwAllocationMoImpl)swa).actionAddSlot(airMo, this.context);
                MoFactory xpProgramFactory = MoFactoryMgr.instance().lookup("XpProgram");
                ManagedObject loadModule = AuxPlugInUnitUpgradeHelper.getNewLoadModule((ManagedObject)this.airPiuType, (ManagedObject)airRepertoire, (Coordinator)this.context);
                AttrListImpl attrXp = new AttrListImpl();
                attrXp.addElement("loadModule", (Object)loadModule);
                ManagedObject airGrp = airMo.getChildren().nextMo();
                xpProgramFactory.createMo(airGrp, (AttrList)attrXp, IdGenerator.getNext(), null, this.context);
                if (this.hasSecondSA) {
                    this.deleteSA(sector);
                }
                createXpTw.commit();
                TransactionWrapper initSectorTw = this.createTransactionWrapper();
                this.context = initSectorTw.getCoordinator();
                sector.actionInitSector(numberOfTxBranches, band, this.context);
                if (this.orgAirState == 1) {
                    airMo.setAttribute("administrativeState", (Object)new Integer(1), this.context);
                }
                if (this.orgPassiveRetState == 1 && null != passiveRet) {
                    passiveRet.setAttribute("administrativeState", (Object)new Integer(1), this.context);
                }
                initSectorTw.commit();
                MessageLog.trace((int)9, this.getClass(), (String)"Finish one sector upgrade!");
            } else {
                MessageLog.trace((int)9, this.getClass(), (String)"this sector no need to trigger AIR AUE");
                newTw.commit();
            }
            this.reset();
        }
        return true;
    }

    private void deleteSA(SectorMo sector) throws MoAccessException {
        ManagedObject object;
        this.traceEnter("deleteSA");
        boolean update = false;
        MoIterator it = sector.getChildren();
        while (it.hasMoreElements()) {
            object = it.nextMo();
            if (!object.getType().equals("Carrier") || (Integer)object.getAttribute("numberOfRxBranches", this.context) != 4) continue;
            update = true;
            object.setAttribute("numberOfRxBranches", (Object)new Integer(2), this.context);
        }
        sector.setAttribute("numberOfSectorAntennas", (Object)new Integer(1), this.context);
        if (update) {
            it = sector.getChildren();
            while (it.hasMoreElements()) {
                object = it.nextMo();
                if (!object.getType().equals("Carrier")) continue;
                object.setAttribute("numberOfRxBranches", (Object)new Integer(4), this.context);
            }
        }
    }

    private void reset() {
        this.deleteMo.clear();
        this.auxPluginList.clear();
        this.saveData.clear();
        this.savedMo.clear();
        this.auxToLock.clear();
        this.retSaveData.clear();
        this.retSavedMo.clear();
        this.airPiuType = null;
        this.add2ndCable = false;
        this.hasSecondSA = false;
        this.orgAirState = 1;
        this.orgPassiveRetState = 1;
        this.savedUniqueHwId = null;
        this.maxTotalOutputPower_2 = -1;
    }

    private void createAbAndCable(ManagedObject parentMo, SectorMo sector, ManagedObject airMo, StringBuffer digitalCableName) throws TransactionRolledBackException, MoAccessException, InactiveTransactionException {
        this.traceEnter("createAbAndCable");
        TransactionWrapper createAbTw = this.createTransactionWrapper();
        this.context = createAbTw.getCoordinator();
        Vector<ManagedObject> branchsMO = new Vector<ManagedObject>();
        MultiValueMap branch = (MultiValueMap)this.saveData.get("AntennaBranch");
        int number = branch.getCollection(MoSavedInAir.ATTR_LIST_ANTENNABRANCH[0]).size();
        MoFactory abFactory = MoFactoryMgr.instance().lookup("AntennaBranch");
        for (int k = 0; k < number; ++k) {
            AttrListImpl lst = new AttrListImpl();
            for (int index = 0; index < MoSavedInAir.ATTR_LIST_ANTENNABRANCH.length; ++index) {
                ArrayList attrs = branch.getCollection(MoSavedInAir.ATTR_LIST_ANTENNABRANCH[index]);
                Object value = attrs.get(0);
                lst.addElement(MoSavedInAir.ATTR_LIST_ANTENNABRANCH[index], value);
                attrs.remove(0);
            }
            ManagedObject ptr = abFactory.createMo(parentMo, (AttrList)lst, branchName[k], null, this.context);
            branchsMO.add(ptr);
        }
        parentMo.setAttribute("antennaType", (Object)new Integer(-1), this.context);
        createAbTw.commit();
        TransactionWrapper createCableTw = this.createTransactionWrapper();
        this.context = createCableTw.getCoordinator();
        MoFactory antFeedCableFactory = MoFactoryMgr.instance().lookup("AntFeederCable");
        ManagedObject root = parentMo.getParent();
        MultiValueMap antFeedCables = (MultiValueMap)this.saveData.get("AntFeederCable");
        number = antFeedCables.getCollection(MoSavedInAir.ATTR_LIST_ANT_FEEDER_CABLE[0]).size();
        int branchIndex = 0;
        while (number-- > 0) {
            String name = this.getFeedCableName(sector, airMo, this.context);
            AttrListImpl lst = new AttrListImpl();
            for (int j = 0; j < MoSavedInAir.ATTR_LIST_ANT_FEEDER_CABLE.length; ++j) {
                ArrayList attrs = antFeedCables.getCollection(MoSavedInAir.ATTR_LIST_ANT_FEEDER_CABLE[j]);
                Object value = attrs.get(0);
                lst.addElement(MoSavedInAir.ATTR_LIST_ANT_FEEDER_CABLE[j], value);
                attrs.remove(0);
            }
            int[] attenuation_delay = new int[15];
            for (int k = 0; k < 15; ++k) {
                attenuation_delay[k] = 0;
            }
            lst.addElement("dlAttenuation", (Object)attenuation_delay);
            lst.addElement("ulAttenuation", (Object)attenuation_delay);
            lst.addElement("electricalDlDelay", (Object)attenuation_delay);
            lst.addElement("electricalUlDelay", (Object)attenuation_delay);
            lst.addElement("objectAConnector", (Object)new Integer(22));
            lst.addElement("connectedToObjectARef", (Object)airMo);
            lst.addElement("antennaBranchRef", branchsMO.elementAt(branchIndex));
            antFeedCableFactory.createMo(root, (AttrList)lst, name, null, this.context);
            ++branchIndex;
        }
        MoFactory digitalFeedCableFactory = MoFactoryMgr.instance().lookup("DigitalCable");
        MultiValueMap digitalCables = (MultiValueMap)this.saveData.get("DigitalCable");
        AttrListImpl lst = new AttrListImpl();
        for (int j = 0; j < MoSavedInAir.ATTR_LIST_DIGITALCALBE.length; ++j) {
            ArrayList attrs = digitalCables.getCollection(MoSavedInAir.ATTR_LIST_DIGITALCALBE[j]);
            Object value = attrs.get(0);
            lst.addElement(MoSavedInAir.ATTR_LIST_DIGITALCALBE[j], value);
            attrs.remove(0);
        }
        lst.addElement("connectedToObjectBRef", (Object)airMo);
        digitalFeedCableFactory.createMo(root, (AttrList)lst, digitalCableName.toString(), null, this.context);
        createCableTw.commit();
    }

    private void deleteOldMo(SectorMo sector) throws MoAccessException, InactiveTransactionException, Exception {
        this.traceEnter("deleteOldMo");
        TransactionWrapper lockTw = this.createTransactionWrapper();
        for (int j = 0; j < this.auxToLock.size(); ++j) {
            ManagedObject mo = (ManagedObject)this.auxToLock.get(j);
            if (0 == (Integer)mo.getAttribute("administrativeState", lockTw.getCoordinator())) continue;
            mo.setAttribute("administrativeState", (Object)new Integer(0), lockTw.getCoordinator());
        }
        lockTw.commit();
        TransactionWrapper deleteTw = this.createTransactionWrapper();
        this.context = deleteTw.getCoordinator();
        this.uninitSector(sector);
        for (int i = 0; i < this.deleteMo.size(); ++i) {
            ManagedObject moDel = (ManagedObject)this.deleteMo.get(i);
            moDel.delete(this.context);
        }
        deleteTw.commit();
    }

    private void uninitSector(SectorMo sector) {
        this.traceEnter("uninitSector");
        try {
            sector.actionUnInitSector(this.context);
        }
        catch (MoAccessException e) {
            this.sleep(1000L);
            this.uninitSector(sector);
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.trace("unexpectedly interrupted sleep");
        }
    }

    private ManagedObject createPassiveRet(SectorMo sector) throws TransactionRolledBackException, InactiveTransactionException, MoAccessException {
        this.traceEnter("createPassiveRet");
        ManagedObject retAux = null;
        MultiValueMap attributesMap = (MultiValueMap)this.retSaveData.get("AuxPlugInUnit");
        if (null != attributesMap) {
            TransactionWrapper createAuxTw = this.createTransactionWrapper();
            this.context = createAuxTw.getCoordinator();
            AttrListImpl auxPiuAttrList = new AttrListImpl();
            auxPiuAttrList.addElement("auType", (Object)new Integer(18));
            Set auxAttrNames = attributesMap.getKeys();
            Iterator itAux = auxAttrNames.iterator();
            while (itAux.hasNext()) {
                String name = (String)itAux.next();
                ArrayList attrs = attributesMap.getCollection(name);
                Object value = attrs.get(0);
                if (name.equals("plugInUnitRef2") && value == null || name.equals("positionRef") && value == null) continue;
                auxPiuAttrList.addElement(name, value);
            }
            MoFactory auxFactory = MoFactoryMgr.instance().lookup("AuxPlugInUnit");
            ManagedObject[] reservedBySector = sector.getReservedBy(this.context);
            ManagedObject parentMo = null;
            for (int j = 0; j < reservedBySector.length; ++j) {
                ManagedObject mo = reservedBySector[j];
                if (-1 == mo.getRelativeDistinguishedName().indexOf("ExternalAntenna")) continue;
                parentMo = mo;
                break;
            }
            retAux = auxFactory.createMo(parentMo, (AttrList)auxPiuAttrList, "2", null, this.context);
            createAuxTw.commit();
            TransactionWrapper updateAuxTw = this.createTransactionWrapper();
            this.context = updateAuxTw.getCoordinator();
            this.setChildrenAttributes(retAux, this.retSaveData, this.context);
            updateAuxTw.commit();
        }
        return retAux;
    }

    private ManagedObject createAir(String airType, ManagedObject parentMo) throws TransactionRolledBackException, MoAccessException, InactiveTransactionException {
        boolean bAutoConfigAllowed;
        this.traceEnter("createAir");
        TransactionWrapper createAuxTw = this.createTransactionWrapper();
        this.context = createAuxTw.getCoordinator();
        ManagedObject managedElementData = AuxPlugInUnitUpgradeHelper.findManagedElementDataMO();
        if (managedElementData != null && !(bAutoConfigAllowed = ((ManagedElementDataMo)managedElementData).getAutoConfigurationAllowed(this.context))) {
            ((ManagedElementDataMo)managedElementData).setAutoConfigurationAllowed(true, this.context);
        }
        AttrListImpl auxPiuAttrList = new AttrListImpl();
        auxPiuAttrList.addElement("auType", (Object)new Integer(26));
        MultiValueMap attributesMap = (MultiValueMap)this.saveData.get("AuxPlugInUnit");
        Set auxAttrNames = attributesMap.getKeys();
        Iterator itAux = auxAttrNames.iterator();
        while (itAux.hasNext()) {
            String name = (String)itAux.next();
            ArrayList attrs = attributesMap.getCollection(name);
            Object value = attrs.get(0);
            if (name.equals("plugInUnitRef2") && value == null || name.equals("positionRef") && value == null || name.equals("piuType") || name.equals("uniqueHwId")) continue;
            auxPiuAttrList.addElement(name, value);
        }
        MoIterator piuTypeIter = BoamHelper.findMOs((String)"PiuType");
        while (piuTypeIter.hasMoreElements()) {
            ManagedObject type = piuTypeIter.nextMo();
            if (-1 == type.getLocalDistinguishedName().indexOf(airType)) continue;
            auxPiuAttrList.addElement("piuType", (Object)type);
            this.airPiuType = type;
            MessageLog.trace((int)9, this.getClass(), (String)"Find Air piu type");
            break;
        }
        auxPiuAttrList.addElement("uniqueHwId", (Object)this.savedUniqueHwId);
        ManagedObject airMo = null;
        MoFactory auxFactory = MoFactoryMgr.instance().lookup("AuxPlugInUnit");
        airMo = auxFactory.createMo(parentMo, (AttrList)auxPiuAttrList, "AIR-1", null, this.context);
        createAuxTw.commit();
        TransactionWrapper updateAuxTw = this.createTransactionWrapper();
        this.context = updateAuxTw.getCoordinator();
        this.setChildrenAttributes(airMo, this.saveData, this.context);
        updateAuxTw.commit();
        return airMo;
    }

    private ManagedObject saveExternalRet(SectorMo sector) throws MoAccessException {
        ManagedObject[] reservedBySector = sector.getReservedBy(this.context);
        for (int j = 0; j < reservedBySector.length; ++j) {
            ManagedObject mo = reservedBySector[j];
            if (-1 == mo.getRelativeDistinguishedName().indexOf("ExternalAntenna")) continue;
            MoIterator it = mo.getChildren();
            while (it.hasMoreElements()) {
                ManagedObject mochild = it.nextMo();
                if (-1 == mochild.getRelativeDistinguishedName().indexOf("AuxPlugInUnit")) continue;
                this.auxToLock.add(mochild);
                this.deleteMo.add(mochild);
                return mochild;
            }
        }
        return null;
    }

    private ManagedObject saveMos(SectorMo sector, StringBuffer digitalCableName) throws MoAccessException {
        Object value;
        int j;
        ManagedObject mo;
        int i;
        String print;
        String[] attr;
        MultiValueMap attribute;
        ArrayList moPtrLst;
        Set moSet;
        ManagedObject[] sectorAntenna;
        String name;
        this.traceEnter("saveMos");
        ManagedObject parentMo = null;
        for (int i2 = 0; i2 < this.auxPluginList.size(); ++i2) {
            ManagedObject mo2 = (ManagedObject)this.auxPluginList.get(i2);
            if (-1 != mo2.getNamingAttributeValue().indexOf("RRUW-1")) {
                this.getAllMo(mo2, this.savedMo, MoSavedInAir.MO_LIST);
            } else {
                this.getAllMo(mo2, this.savedMo, secondaryPiuMo);
            }
            if ((Integer)mo2.getAttribute("auType", this.context) == 18) {
                this.savedUniqueHwId = (String)mo2.getAttribute("uniqueHwId", this.context);
            }
            ManagedObject[] ReservedBy = ((AuxPlugInUnitMo)mo2).getReservedBy(this.context);
            for (int j2 = 0; j2 < ReservedBy.length; ++j2) {
                if (-1 != ReservedBy[j2].getRelativeDistinguishedName().indexOf("SwAllocation") || null == (name = this.match(ReservedBy[j2].getRelativeDistinguishedName(), cable))) continue;
                if (name.equals("DigitalCable")) {
                    ManagedObject objectA = (ManagedObject)ReservedBy[j2].getAttribute("connectedToObjectARef", this.context);
                    if (-1 != objectA.getRelativeDistinguishedName().indexOf("AuxPlugInUnit")) {
                        if (this.add2ndCable) continue;
                        this.savedMo.put(name, ReservedBy[j2]);
                        this.deleteMo.add(ReservedBy[j2]);
                        this.add2ndCable = true;
                        continue;
                    }
                    digitalCableName.append(ReservedBy[j2].getNamingAttributeValue());
                    this.savedMo.put(name, ReservedBy[j2]);
                    this.deleteMo.add(ReservedBy[j2]);
                    continue;
                }
                if (name.equals("AntFeederCable")) {
                    this.savedMo.put(name, ReservedBy[j2]);
                    this.deleteMo.add(ReservedBy[j2]);
                    continue;
                }
                if (!name.equals("RfCable") || this.deleteMo.contains(ReservedBy[j2])) continue;
                this.deleteMo.add(ReservedBy[j2]);
            }
            this.auxToLock.add(mo2);
        }
        if (null == this.savedUniqueHwId) {
            this.savedUniqueHwId = "-";
        }
        this.hasSecondSA = (sectorAntenna = (ManagedObject[])sector.getAttribute("sectorAntennasRef", this.context)).length > 1;
        for (int i3 = 0; i3 < sectorAntenna.length; ++i3) {
            if (-1 != sectorAntenna[i3].getNamingAttributeValue().indexOf("-1") || sectorAntenna[i3].getNamingAttributeValue().equals("1")) {
                parentMo = sectorAntenna[i3];
            }
            MoIterator it = sectorAntenna[i3].getChildren();
            while (it.hasMoreElements()) {
                ManagedObject object = it.nextMo();
                this.deleteMo.add(object);
                if (-1 == object.getRelativeDistinguishedName().indexOf("AntennaBranch")) continue;
                this.savedMo.put("AntennaBranch", object);
            }
        }
        ManagedObject passiveRetAux = this.saveExternalRet(sector);
        if (null != passiveRetAux) {
            this.getAllMo(passiveRetAux, this.retSavedMo, MoSavedInAir.PASSIVE_RET_MO_LIST);
            moSet = this.retSavedMo.getKeys();
            Iterator itAttr = moSet.iterator();
            while (itAttr.hasNext()) {
                name = (String)itAttr.next();
                moPtrLst = this.retSavedMo.getCollection(name);
                attribute = new MultiValueMap();
                attr = MoSavedInAir.getAttrs(name);
                print = new String("MO:" + name + " with attribute numbers" + attr.length);
                MessageLog.trace((int)9, this.getClass(), (String)print);
                for (i = 0; i < moPtrLst.size(); ++i) {
                    mo = (ManagedObject)moPtrLst.get(i);
                    for (j = 0; j < attr.length; ++j) {
                        value = mo.getAttribute(attr[j], this.context);
                        attribute.put(attr[j], value);
                        if (attr[j].equals("administrativeState")) {
                            this.orgPassiveRetState = (Integer)value;
                        }
                        MessageLog.trace((int)9, this.getClass(), (String)new String("MO:" + name + " with attribute:" + attr[j] + ",value=" + value));
                    }
                }
                this.retSaveData.put(name, attribute);
            }
        }
        moSet = this.savedMo.getKeys();
        Iterator itAttr = moSet.iterator();
        while (itAttr.hasNext()) {
            name = (String)itAttr.next();
            moPtrLst = this.savedMo.getCollection(name);
            attribute = new MultiValueMap();
            attr = MoSavedInAir.getAttrs(name);
            print = new String("MO:" + name + " with attribute numbers" + attr.length);
            MessageLog.trace((int)9, this.getClass(), (String)print);
            for (i = 0; i < moPtrLst.size(); ++i) {
                mo = (ManagedObject)moPtrLst.get(i);
                for (j = 0; j < attr.length; ++j) {
                    value = mo.getAttribute(attr[j], this.context);
                    attribute.put(attr[j], value);
                    if (attr[j].equals("administrativeState")) {
                        this.orgAirState = (Integer)value;
                    }
                    if (attr[j].equals("maxTotalOutputPower") && -1 != mo.getLocalDistinguishedName().indexOf("RRUW-2") && mo.getNamingAttributeValue().equals("1")) {
                        this.maxTotalOutputPower_2 = (Integer)value;
                        MessageLog.trace((int)9, this.getClass(), (String)("MO: " + mo.getLocalDistinguishedName() + " with attribute:" + attr[j] + ",value= " + value + " catched <----"));
                    }
                    MessageLog.trace((int)9, this.getClass(), (String)new String("MO:" + name + " with attribute:" + attr[j] + ",value=" + value));
                }
            }
            this.saveData.put(name, attribute);
        }
        return parentMo;
    }

    private String getFeedCableName(SectorMo sector, ManagedObject piu, Coordinator context) throws MoAccessException {
        this.traceEnter("getFeedCableName");
        StringBuffer name = new StringBuffer("");
        name.append(sector.getNamingAttributeValue().charAt(0));
        ManagedObject[] ReservedBy = ((AuxPlugInUnitMo)piu).getReservedBy(context);
        int number = 0;
        for (int i = 0; i < ReservedBy.length; ++i) {
            if (-1 == ReservedBy[i].getRelativeDistinguishedName().indexOf("AntFeederCable")) continue;
            ++number;
        }
        short last = (short)(65 + number);
        name.append((char)last);
        return name.toString();
    }

    private boolean preConditon(SectorMo sector, Coordinator context) throws NoSuchAttributeException, MoAccessException {
        this.traceEnter("preConditon");
        SectorAntennaMo sectorAntennaMo = null;
        boolean isAirAue = false;
        ManagedObject[] mos = (ManagedObject[])sector.getAttribute("sectorAntennasRef", context);
        for (int i = 0; i < mos.length; ++i) {
            sectorAntennaMo = (SectorAntennaMo)mos[i];
            MoIterator it = sectorAntennaMo.getChildren();
            while (it.hasMoreElements()) {
                ManagedObject mo = it.nextMo();
                if (0 != mo.getType().compareTo("AuxPlugInUnit")) continue;
                if ((Integer)mo.getAttribute("auType", context) == 26) {
                    return false;
                }
                this.auxPluginList.add(mo);
                String productName = (String)mo.getAttribute("productName", context);
                String ul = (String)sector.getAttribute("userLabel", context);
                boolean trigger = false;
                for (int j = 0; j < ConstantFlag.AIR_RRU_PRODUCT_NAME.length; ++j) {
                    if (-1 == productName.indexOf(ConstantFlag.AIR_RRU_PRODUCT_NAME[j])) continue;
                    trigger = true;
                    break;
                }
                if (!trigger || -1 == ul.indexOf("*A_I_R#")) continue;
                isAirAue = true;
            }
        }
        return isAirAue;
    }

    private void getAllMo(ManagedObject mo, MultiValueMap data, String[] scope) {
        this.traceEnter("getAllMo");
        String result = this.match(mo.getRelativeDistinguishedName(), scope);
        if (null != result) {
            data.put(result, mo);
        }
        MoIterator it = mo.getChildren();
        while (it.hasMoreElements()) {
            ManagedObject object = it.nextMo();
            this.getAllMo(object, data, scope);
        }
    }

    private String match(String str, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            String temp = array[i] + "=";
            if (-1 == str.indexOf(temp)) continue;
            return array[i];
        }
        return null;
    }

    private void setChildrenAttributes(ManagedObject mo, HashMap savedData, Coordinator context) throws MoAccessException {
        this.traceEnter("setchildrenAttributes");
        MoIterator it = mo.getChildren();
        while (it.hasMoreElements()) {
            ManagedObject object = it.nextMo();
            String name = this.match(object.getRelativeDistinguishedName(), MoSavedInAir.AUX_CHILDREN);
            if (null == name && object instanceof DeviceGroupMo) {
                name = "RruDeviceGroup";
            }
            if (null == name) {
                this.info(" \nCan't find  MO: " + object.getRelativeDistinguishedName());
                continue;
            }
            String[] attr = MoSavedInAir.getAttrs(name);
            MultiValueMap attributesMap = (MultiValueMap)savedData.get(name);
            Vector values = new Vector();
            if (null == attributesMap || null == attr) {
                this.info(" \nCan't find save information of MO: " + object.getRelativeDistinguishedName());
                continue;
            }
            MessageLog.trace((int)9, this.getClass(), (String)("setAttribute with MO name:" + name));
            for (int i = 0; i < attr.length; ++i) {
                ArrayList lst = attributesMap.getCollection(attr[i]);
                if (lst.isEmpty()) {
                    this.info(" \nCan't find attributes of MO: " + name);
                    break;
                }
                values.add(lst.get(0));
                lst.remove(0);
            }
            if (values.isEmpty()) {
                this.info(" \nCan't find none attributes of MO: " + name);
                continue;
            }
            object.setAttributes(attr, values.toArray(), context);
            if (-1 != this.maxTotalOutputPower_2 && -1 != object.getLocalDistinguishedName().indexOf("TpaDevice=2")) {
                ((TpaDeviceMo)object).setMaxTotalOutputPower(this.maxTotalOutputPower_2, context);
                this.info(object.getLocalDistinguishedName() + " set MaxtotalOutputPower " + this.maxTotalOutputPower_2 + "again <-----");
            }
            this.setChildrenAttributes(object, savedData, context);
        }
    }

    private TransactionWrapper createTransactionWrapper() throws TransactionRolledBackException {
        try {
            return new TransactionWrapper();
        }
        catch (TransactionRolledBackException e) {
            this.traceError("Interrupting the system upgrade!! Failed to create transaction", e);
            throw e;
        }
    }
}

