/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.AbstractConfigureSectorAue;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;

public final class FixAsymSectorConfigAue
extends AbstractConfigureSectorAue {
    private static final String DCI_REFERENCE = "16/109 26-CRH 109 042/1-1";
    private static final int LOW_VERSION = 8000000;
    private static final int HIGH_VERSION = 11060899;
    private static final int MAX_ATTEMPTS = 1;
    private static final String PRODUCT_NAME = "productName";
    private static final String RBS_TYPE_3402 = "RBS3402";
    private static final FixAsymSectorConfigAue INSTANCE = new FixAsymSectorConfigAue();

    private FixAsymSectorConfigAue() {
        super(FixAsymSectorConfigAue.class);
    }

    public static FixAsymSectorConfigAue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 8000000;
    }

    public int getHighVersion() {
        return 11060899;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public boolean couldExecute(Coordinator context) {
        boolean isOBIF = FindMo.findMOs("ObifDeviceGroup").hasMoreElements();
        if (!isOBIF) {
            this.trace("This isn't a OBIF RBS, the AUE will not be executed");
            return false;
        }
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        try {
            String productName = (String)rootMo.getAttribute(PRODUCT_NAME, context);
            if (RBS_TYPE_3402.equals(productName)) {
                this.trace("The RBS type is 3402, the AUE will not be executed");
                return false;
            }
        }
        catch (MoAccessException e) {
            this.traceError("Try to obtain the RBS type", e);
            return false;
        }
        MoIterator sectorIte = FindMo.findMOs("Sector");
        while (sectorIte != null && sectorIte.hasMoreElements()) {
            MoIterator carrierIte = BoamHelper.findMOs((String)"Carrier", (ManagedObject)sectorIte.nextMo(), (int)1);
            if (carrierIte == null || carrierIte.size() != 1) continue;
            this.trace("At least one sector has only one carrier, the AUE will be executed");
            return true;
        }
        return false;
    }

    public int getMaximumAttempts() {
        return 1;
    }
}

