/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessHostGpbMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.CreateMoHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class WionaWP639Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "11/109 26-CRH 109 042/1-5";
    public static final int LOW_VERSION = 7091000;
    private static final int HIGH_VERSION = 8999999;
    private static final String SCTP_TYPE_NAME = "Sctp";
    private static final String IP_ACCESS_HOST_GPB_ID_ATTR_NAME = "ipAccessHostGpbId";
    private static final String IP_ACCESS_SCTP_REF_ATTR_NAME = "ipAccessSctpRef";
    private static final WionaWP639Aue instance = new WionaWP639Aue();
    private int nextMoId = 1;

    private WionaWP639Aue() {
        super(WionaWP639Aue.class);
    }

    public static WionaWP639Aue instance() {
        return instance;
    }

    public int getLowVersion() {
        return 7091000;
    }

    public int getHighVersion() {
        return 8999999;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerFinish(List commands) throws Exception {
        this.traceEnter("triggerFinish(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        if (!this.isWP639AueNeeded(context)) {
            this.trace("No need to run");
        } else {
            this.createIpAccessSctpMo(context);
            this.reconfigureSctp(context);
            this.reconfigureIpAccessHostEt(context);
        }
        return true;
    }

    private boolean isWP639AueNeeded(Coordinator c) throws Exception {
        this.traceEnter("isWP639AueNeeded()");
        try {
            this.getMo("IpAccessSctp");
            return false;
        }
        catch (Exception e) {
            try {
                this.getMo("IpAccessHostGpb");
            }
            catch (Exception e2) {
                return false;
            }
            return this.isIpInterfaceCommon(c);
        }
    }

    private boolean isIpInterfaceCommon(Coordinator c) throws Exception {
        this.traceEnter("isIpInterfaceCommon()");
        IpAccessHostEtMo ipAccessHostEt = (IpAccessHostEtMo)this.getMo("IpAccessHostEt");
        IpAccessHostGpbMo ipAccessHostGpb = (IpAccessHostGpbMo)this.getMo("IpAccessHostGpb");
        ManagedObject mo1 = ipAccessHostEt.getIpInterfaceMoRef(c);
        ManagedObject mo2 = ipAccessHostGpb.getInterface1(c);
        return mo1 != null && mo2 != null && mo1.getFullDistinguishedName().equalsIgnoreCase(mo2.getFullDistinguishedName());
    }

    private void createIpAccessSctpMo(Coordinator c) throws Exception {
        this.traceEnter("createIpAccessSctpMo()");
        ManagedObject parent = this.getMo("IpSystem");
        ManagedObject etRef = this.getMo("IpAccessHostEt");
        AttrListImpl attrs = new AttrListImpl();
        attrs.insert("ipAccessHostEtRef1", (Object)etRef);
        CreateMoHelper.createMo("IpAccessSctp", parent, Integer.toString(this.nextMoId++), attrs, c);
    }

    private void reconfigureSctp(Coordinator c) throws Exception {
        this.traceEnter("reconfigureSctp()");
        ManagedObject ipAccessSctp = this.getMo("IpAccessSctp");
        ManagedObject sctpMo = this.getMo(SCTP_TYPE_NAME);
        sctpMo.setAttribute(IP_ACCESS_HOST_GPB_ID_ATTR_NAME, null, c);
        sctpMo.setAttribute(IP_ACCESS_SCTP_REF_ATTR_NAME, (Object)ipAccessSctp, c);
    }

    private void reconfigureIpAccessHostEt(Coordinator c) throws Exception {
        this.traceEnter("reconfigureIpAccessHostEt()");
        IpAccessHostEtMo ipAccessHostEt = (IpAccessHostEtMo)this.getMo("IpAccessHostEt");
        IpAccessHostGpbMo ipAccessHostGpb = (IpAccessHostGpbMo)this.getMo("IpAccessHostGpb");
        String ipAddress = ipAccessHostGpb.getIpAddress1(c);
        int etAdminState = ipAccessHostEt.getAdministrativeState(c);
        int gpbAdminState = ipAccessHostGpb.getAdministrativeState(c);
        if (etAdminState != 0) {
            ipAccessHostEt.setAdministrativeState(0, c);
        }
        if (gpbAdminState != 0) {
            ipAccessHostGpb.setAdministrativeState(0, c);
        }
        this.deleteIpAccessHostGpb(c);
        ipAccessHostEt.setIpAddress(ipAddress, c);
        ipAccessHostEt.setAdministrativeState(1, c);
    }

    private void deleteIpAccessHostGpb(Coordinator c) throws Exception {
        this.traceEnter("deleteIpAccessHostGpb()");
        IpAccessHostGpbMo ipAccessHostGpb = (IpAccessHostGpbMo)this.getMo("IpAccessHostGpb");
        ipAccessHostGpb.delete(c);
    }

    private ManagedObject getMo(String typeName) throws Exception {
        MoIterator moIter = BoamHelper.findMOs((String)typeName);
        if (moIter.hasMoreElements()) {
            return moIter.nextMo();
        }
        this.trace("Could not find MO: " + typeName);
        throw new Exception("Could not find MO: " + typeName);
    }
}

