/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC14010398To14010399
extends DataConverterBase {
    private static final String A_CONNECTOR = "A";
    private static final String B_CONNECTOR = "B";
    private static final String CABLE_SEPARATOR = "_";
    private static final String RADIO_SEPARATOR = "-";
    private static final String DATA_PORT = "DATA_2";
    private static final String ATTR_NAME_RESERVED_BY = "persistentReservers";
    private static final String ATTR_NAME_AU_TYPE = "auType";
    protected static final int fromConverterRev = 14010398;
    protected static final int toConverterRev = 14010399;
    private static final DC14010398To14010399 INSTANCE = new DC14010398To14010399();

    private DC14010398To14010399() {
        super(14010398, 14010399);
    }

    public static DC14010398To14010399 instance() {
        return INSTANCE;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateCandidates = this.getUpdateCandidates();
        if (updateCandidates.isEmpty()) {
            this.trace("No update is needed, no candidates found");
        } else {
            this.updateNamingAttributeValue(updateCandidates);
        }
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
    }

    private List getUpdateCandidates() throws Exception {
        this.traceEnter("getUpdateCandidates()");
        ArrayList<MoData> result = new ArrayList<MoData>();
        Collection digitalCables = this.workingMoData.getMoData("DigitalCable");
        Iterator iter = digitalCables.iterator();
        while (iter.hasNext()) {
            MoData digitalCable = (MoData)iter.next();
            if (digitalCable != null) {
                MoData connARef = this.getConnectedObject(digitalCable, A_CONNECTOR);
                MoData connBRef = this.getConnectedObject(digitalCable, B_CONNECTOR);
                if (!this.isRemoteRadio(connARef) || !this.isRemoteRadio(connBRef)) continue;
                this.trace("Adding MO " + digitalCable.getLocalDistinguishedName() + " as an update candidate");
                result.add(digitalCable);
                continue;
            }
            this.traceError("DigitalCable to investigate is null which indicates problem in the configuration, aborting upgrade");
            throw new Exception("DigitalCable to investigate is null");
        }
        return result;
    }

    private void updateNamingAttributeValue(List candidates) throws Exception {
        this.traceEnter("updateNamingAttributeValue()");
        TopologyMgr mgr = new TopologyMgr(this.workingMoData);
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            MoData digitalCable = (MoData)iter.next();
            this.trace("Investing candidate: " + digitalCable.getLocalDistinguishedName());
            String actualId = LDNHelper.getNamingAttributeValue(digitalCable.getLocalDistinguishedName());
            String expectedId = this.getExpectedId(digitalCable);
            this.trace("Actual Id: " + actualId + "\nExpected Id: " + expectedId);
            if (!actualId.equals(expectedId)) {
                this.trace("Found DigitalCable that needs to be updated: " + digitalCable.getLocalDistinguishedName());
                String newLDN = LDNHelper.replaceFirst(digitalCable.getLocalDistinguishedName(), actualId, expectedId);
                mgr.changeLdnTopology(digitalCable, newLDN);
                continue;
            }
            this.trace("DigitalCable " + digitalCable.getLocalDistinguishedName() + " has already correct RDN, no update needed");
        }
    }

    private MoData getConnectedObject(MoData digitalCable, String connector) throws Exception {
        this.traceEnter("getConnectedObject()");
        String attributeName = "connectedToObject" + connector.toUpperCase() + "Ref";
        this.trace("Checking attribute " + attributeName + " on MO " + digitalCable.getLocalDistinguishedName());
        ReferenceAttribute connRef = (ReferenceAttribute)digitalCable.getAttribute(attributeName);
        if (connRef != null) {
            return MoConverterUtility.getMoDataByLDN(this.workingMoData, null, connRef.getReferenceAsLDN());
        }
        this.traceError("Attribute " + attributeName + " of " + digitalCable.getLocalDistinguishedName() + " is null");
        throw new Exception("Attribute " + attributeName + " of " + digitalCable.getLocalDistinguishedName() + " is null");
    }

    private boolean isRemoteRadio(MoData mo) throws Exception {
        this.traceEnter("isRemoteRadio()");
        this.trace("Checking MO: " + mo.getLocalDistinguishedName());
        if (mo.getMoTypeName().equals("AuxPlugInUnit")) {
            IntegerAttribute auType = (IntegerAttribute)mo.getAttribute(ATTR_NAME_AU_TYPE);
            if (auType == null) {
                this.traceError("Attribute auType is null!");
                throw new Exception("Attribute auType is null!");
            }
            this.trace("Value of auType is " + auType.getValue(null));
            if (auType.getValue(null) == 10 || auType.getValue(null) == 20) {
                return true;
            }
        }
        return false;
    }

    private String getExpectedId(MoData digitalCable) throws Exception {
        this.traceEnter("getExpectedId()");
        MoData objectA = this.getConnectedObject(digitalCable, A_CONNECTOR);
        if (objectA == null) {
            this.traceError("Could not find A connector for " + digitalCable.getLocalDistinguishedName());
            throw new Exception("Could not find A connector for " + digitalCable.getLocalDistinguishedName());
        }
        MoData sector = this.getCorrespondingSector(objectA);
        if (sector != null) {
            String sectorId = LDNHelper.getNamingAttributeValue(sector.getLocalDistinguishedName());
            Integer internalRadioNumber = this.getInternalRadioNumber(objectA);
            if (internalRadioNumber != null) {
                return sectorId + CABLE_SEPARATOR + internalRadioNumber + CABLE_SEPARATOR + DATA_PORT;
            }
            this.traceError("Failed to get internal radio number for connected radio " + objectA.getLocalDistinguishedName());
            throw new Exception("Failed to get internal radio number for connected radio " + objectA.getLocalDistinguishedName());
        }
        this.traceError("Could not find Sector for " + digitalCable.getLocalDistinguishedName());
        throw new Exception("Could not find Sector for " + digitalCable.getLocalDistinguishedName());
    }

    private MoData getCorrespondingSector(MoData mo) {
        this.traceEnter("getCorrespondingSector()");
        this.trace("checking: " + mo.getLocalDistinguishedName());
        String sectorAntennaLDN = LDNHelper.getParentLdn(mo.getLocalDistinguishedName(), "AuxPlugInUnit");
        if (sectorAntennaLDN != null && !sectorAntennaLDN.equals("")) {
            MoData sectorAntenna = MoConverterUtility.getMoDataByLDN(this.workingMoData, null, sectorAntennaLDN);
            if (sectorAntenna.getMoTypeName().equals("SectorAntenna")) {
                this.trace("Found SectorAntenna: " + sectorAntennaLDN);
                SequenceAttribute attribute = (SequenceAttribute)sectorAntenna.getAttribute(ATTR_NAME_RESERVED_BY);
                if (attribute == null) {
                    this.traceError("Could not get attribute persistentReservers for MO " + sectorAntenna.getLocalDistinguishedName());
                    return null;
                }
                Enumeration attributes = attribute.elements();
                while (attributes != null && attributes.hasMoreElements()) {
                    ReferenceAttribute aTmpAttr = (ReferenceAttribute)attributes.nextElement();
                    String LDN = aTmpAttr.getReferenceAsLDN();
                    if (!LDNHelper.getMoTypeName(LDN).equals("Sector")) continue;
                    this.trace("Found sector: " + LDN);
                    return MoConverterUtility.getMoDataByLDN(this.workingMoData, null, LDN);
                }
            } else {
                this.traceError("Could not fetch SectorAntenna MoData from LDN: " + sectorAntennaLDN);
            }
        } else {
            this.traceError("Could not fetch SectorAntenna from MO: " + mo.getLocalDistinguishedName());
        }
        return null;
    }

    private Integer getInternalRadioNumber(MoData mo) throws Exception {
        this.traceEnter("getInternalRadioNumber()");
        this.trace("Getting internal radio ID from MO: " + mo.getLocalDistinguishedName());
        String id = LDNHelper.getNamingAttributeValue(mo.getLocalDistinguishedName());
        int seperatorIndex = id.lastIndexOf(RADIO_SEPARATOR);
        if (seperatorIndex > 0 && seperatorIndex < id.length() - 1) {
            String internalRadioNumber = id.substring(seperatorIndex + 1);
            try {
                Integer result = Integer.valueOf(internalRadioNumber);
                return result;
            }
            catch (NumberFormatException e) {
                this.traceError("Could not get InternalRadio Number from MO " + mo.getLocalDistinguishedName(), e);
                throw e;
            }
        }
        this.traceError("Could not get Internal Radio number from MO " + mo.getLocalDistinguishedName());
        throw new Exception("Could not get Internal Radio number from MO " + mo.getLocalDistinguishedName());
    }
}

