/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC8011998To8011999
extends DataConverterBase {
    private static final Class SELF = DC8011998To8011999.class;
    protected static final int fromConverterRev = 8011998;
    protected static final int toConverterRev = 8011999;
    private static final String RF_CABLE_TYPE_NAME = "RfCable";
    private static final String ANT_FEEDER_CABLE_TYPE_NAME = "AntFeederCable";
    private static final String CONNECTED_TO_OBJECT_A_REF_ATTR_NAME = "connectedToObjectARef";
    private static final String AUX_PIU_TYPE_NAME = "AuxPlugInUnit";
    private static final String AU_TYPE_ATTR_NAME = "auType";
    private static final int AU_TYPE_RUW = 19;
    private static final int AU_TYPE_RRUW = 20;
    private static final String ASSIGN_OP_AS_STRING = "=";
    private static final String BRANCH_A_VALUE = "A";
    private static final DC8011998To8011999 INSTANCE = new DC8011998To8011999();
    private Coordinator context;

    private DC8011998To8011999() {
        super(8011998, 8011999);
    }

    public static DC8011998To8011999 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateCandidates = this.findUpdateCandidates();
        if (updateCandidates.isEmpty()) {
            this.trace("No upgrade is necessary.");
        } else {
            this.updateIds(updateCandidates);
        }
    }

    private List findUpdateCandidates() {
        this.traceEnter("findUpdateCandidates()");
        ArrayList<UpdateCandidate> result = new ArrayList<UpdateCandidate>();
        Iterator rfCableIter = this.workingMoData.getMoData(RF_CABLE_TYPE_NAME).iterator();
        while (rfCableIter.hasNext()) {
            MoData antFeederCable;
            IntegerAttribute auType;
            int auTypeValue;
            MoData rfCable = (MoData)rfCableIter.next();
            ReferenceAttribute refA = (ReferenceAttribute)rfCable.getAttribute(CONNECTED_TO_OBJECT_A_REF_ATTR_NAME);
            MoData auxPiu = this.getMoDataFromLDN(refA.getReferenceAsLDN(), AUX_PIU_TYPE_NAME);
            if (auxPiu == null || (auTypeValue = (auType = (IntegerAttribute)auxPiu.getAttribute(AU_TYPE_ATTR_NAME)).getValue(this.context)) != 20 && auTypeValue != 19 || (antFeederCable = this.getAntFeederCable(auxPiu)) == null) continue;
            String newLdn = this.newLdn(rfCable, antFeederCable, auTypeValue);
            if (newLdn == null) {
                this.trace("no need to update this instance: " + rfCable.getLocalDistinguishedName());
                continue;
            }
            result.add(new UpdateCandidate(rfCable, newLdn));
        }
        return result;
    }

    private String newLdn(MoData rfCable, MoData antFeederCable, int auTypeValue) {
        this.traceEnter("newLdn()");
        String source = rfCable.getLocalDistinguishedName();
        if (source.endsWith("A_RXA_IO") || source.endsWith("B_RXA_IO")) {
            return null;
        }
        this.trace("about to change LDN: " + source);
        String moTypeName = rfCable.getMoTypeName();
        this.trace("moTypeName: " + moTypeName);
        String oldSubstr = moTypeName + ASSIGN_OP_AS_STRING + LDNHelper.getNamingAttributeValue(source);
        this.trace("oldSubstr: " + oldSubstr);
        int firstUnderscore = oldSubstr.indexOf(95);
        if (firstUnderscore == -1) {
            throw new IllegalStateException("Missing required underscore in last part of LDN: " + source);
        }
        this.trace("firstUnderscore: " + firstUnderscore);
        String tailOfOldSubstr = oldSubstr.substring(firstUnderscore + 1);
        this.trace("tailOfOldSubstr: " + tailOfOldSubstr);
        int secondUnderscore = tailOfOldSubstr.indexOf(95);
        if (secondUnderscore < 1) {
            throw new IllegalStateException("Missing expected embedded SectorId in LDN: " + source);
        }
        this.trace("secondUnderscore: " + secondUnderscore);
        String sectorId = tailOfOldSubstr.substring(0, secondUnderscore);
        this.trace("sectorId: " + sectorId);
        if (!DC8011998To8011999.isDigitString(sectorId)) {
            throw new IllegalStateException("Assumed sector id is not all digits: " + sectorId + "; LDN: " + source);
        }
        String replacement = moTypeName + ASSIGN_OP_AS_STRING + (auTypeValue == 20 ? "RRUW" : "RUW") + sectorId + this.getBranchId(antFeederCable) + "_RXA_IO";
        String newLDN = LDNHelper.replaceFirst(source, oldSubstr, replacement);
        return newLDN;
    }

    private void updateIds(List updateCandidates) throws Exception {
        this.traceEnter("updateIds()");
        TopologyMgr mgr = new TopologyMgr(this.workingMoData);
        Iterator iter = updateCandidates.iterator();
        while (iter.hasNext()) {
            UpdateCandidate updateCandidate = (UpdateCandidate)iter.next();
            mgr.changeLdnTopology(updateCandidate.moData, updateCandidate.newLdn);
            MessageLog.trace((int)9, (Class)SELF, (String)("Info: " + updateCandidate.moData.getLocalDistinguishedName() + " now has the following LDN : " + updateCandidate.newLdn));
        }
        MessageLog.trace((int)9, (Class)SELF, (String)mgr.getModificationInfo());
    }

    private MoData getMoDataFromLDN(String LDN, String typeName) {
        this.traceEnter("getMoDataFromLDN()");
        Collection moDatas = this.workingMoData.getMoData(typeName);
        Iterator it = moDatas.iterator();
        while (it.hasNext()) {
            MoData moData = (MoData)it.next();
            if (!moData.getLocalDistinguishedName().equals(LDN)) continue;
            return moData;
        }
        return null;
    }

    private MoData getAntFeederCable(MoData auxPiuToFind) {
        this.traceEnter("getAntFeederCable()");
        Iterator it = this.workingMoData.getMoData(ANT_FEEDER_CABLE_TYPE_NAME).iterator();
        while (it.hasNext()) {
            MoData afCable = (MoData)it.next();
            ReferenceAttribute refA = (ReferenceAttribute)afCable.getAttribute(CONNECTED_TO_OBJECT_A_REF_ATTR_NAME);
            MoData auxPiu = this.getMoDataFromLDN(refA.getReferenceAsLDN(), AUX_PIU_TYPE_NAME);
            if (auxPiu == null || !auxPiu.getLocalDistinguishedName().equals(auxPiuToFind.getLocalDistinguishedName())) continue;
            return afCable;
        }
        return null;
    }

    private static boolean isDigitString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if ("0123456789".indexOf(s.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private String getBranchId(MoData antFeederCable) {
        this.traceEnter("getBranchId()");
        String id = LDNHelper.getNamingAttributeValue(antFeederCable.getLocalDistinguishedName());
        return id.indexOf(BRANCH_A_VALUE) != -1 ? BRANCH_A_VALUE : "B";
    }

    private class UpdateCandidate {
        private final MoData moData;
        private final String newLdn;

        public UpdateCandidate(MoData moData, String newLdn) {
            this.moData = moData;
            this.newLdn = newLdn;
        }
    }
}

