/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class HwUnitFroDataConverter
extends CommonSupportSystemFroDataConverter {
    public static final String AUE_NAME = "HwUnitFroDataConverter";
    private static HwUnitFroDataConverter instance = null;
    private static final List ldnStore = new ArrayList();
    private final Map hwUnitIndices = new HashMap();
    private final ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("administrativeState", "INTEGER"), new ColumnData("unitType", DatabaseMgr.getSql().varcharType(512))};

    private HwUnitFroDataConverter() {
        super(AUE_NAME);
        this.hwUnitIndices.put("PSU", new Integer(0));
        this.hwUnitIndices.put("BFU", new Integer(0));
    }

    public static synchronized HwUnitFroDataConverter instance() {
        if (instance == null) {
            instance = new HwUnitFroDataConverter();
        }
        return instance;
    }

    public static synchronized void newInstance_onlyForTest() {
        instance = new HwUnitFroDataConverter();
    }

    public List getLdnStore() {
        return ldnStore;
    }

    public static void setLdnStore_onlyForTest(String[] ldns) {
        ldnStore.clear();
        for (int i = 0; i < ldns.length; ++i) {
            ldnStore.add(ldns[i]);
        }
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "AuxPlugInUnit";
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator c) throws MoAccessException {
        this.traceEnter("getTableData()");
        String ldnPrefix = "ManagedElement=1,Equipment=1,HwUnit=";
        if (nextMo != null) {
            this.trace("non-null MO: " + nextMo);
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)nextMo;
            int auType = auxPiu.getAuType(c);
            this.trace("auType: " + auType);
            PiuTypeMo newPiuType = this.getNewPiuType(auType, false, c);
            if (newPiuType == null) {
                this.trace("unknown auType: " + auType + ", no tableData created");
                return null;
            }
            this.trace("found PiuType: " + newPiuType + ", will create tableData");
            String unitType1 = HwUnitFroDataConverter.getAuType(nextMo, c);
            String hwUnitId = unitType1.equalsIgnoreCase("SUP") ? this.getSupHwUnitId(auxPiu.getNamingAttributeValue()) : this.nextNamingAttributeValue(unitType1);
            return new Object[]{new Integer(this.nextFroId()), "ManagedElement=1,Equipment=1,HwUnit=" + hwUnitId, new Integer(auxPiu.getAdministrativeState(c)), unitType1};
        }
        this.trace("null MO, will create tableData");
        String unitType = "PDU";
        String ldn = "ManagedElement=1,Equipment=1,HwUnit=PDU-1";
        return new Object[]{new Integer(this.nextFroId()), "ManagedElement=1,Equipment=1,HwUnit=PDU-1", new Integer(1), "PDU"};
    }

    protected void createNewMoData(MoData modata, String ldn, int froId, Coordinator c) throws MoAccessException {
        StringAttribute userLabel;
        PiuTypeMo newPiuType;
        this.traceEnter("createNewModata(), ldn: " + ldn);
        if (modata != null) {
            int auType = ((IntegerAttribute)modata.getAttribute("auType")).getValue(c);
            newPiuType = this.getNewPiuType(auType, false, c);
            userLabel = (StringAttribute)modata.getAttribute("userLabel");
        } else {
            newPiuType = this.getNewPiuType(-1, true, c);
            userLabel = new StringAttribute("userLabel", true, "");
        }
        MoData newModata = new MoData(ldn, this.getNewTypeName(), true, c);
        ldnStore.add(ldn);
        newModata.handleTransaction(c, MoData.WRITE_ACCESS);
        newModata.registerPersistentAttr((Attribute)new ReferenceAttribute("piuType", true, (ManagedObject)newPiuType));
        newModata.registerPersistentAttr((Attribute)userLabel);
        newModata.registerPersistentAttr((Attribute)new ReferenceAttribute("positionRef", true, null));
        newModata.registerPersistentAttr((Attribute)new IntegerAttribute("position", true, 0));
        newModata.registerPersistentAttr((Attribute)new StringAttribute("positionInformation", true, ""));
        newModata.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, froId));
        newModata.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "administrativeState", "S32"), new ApcFroAttributes(froType, "unitType", "STRING")};
    }

    protected String getNewTypeName() {
        return "HwUnit";
    }

    private PiuTypeMo getNewPiuType(int auType, boolean isPdu, Coordinator c) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, MoAccessException {
        String piuTypePrefix;
        this.traceEnter("getNewPiuType()");
        if (isPdu) {
            piuTypePrefix = "PDU";
        } else {
            switch (auType) {
                case 15: {
                    piuTypePrefix = "BFU";
                    break;
                }
                case 14: {
                    piuTypePrefix = "PSU";
                    break;
                }
                case 21: {
                    piuTypePrefix = "SAU";
                    break;
                }
                case 22: {
                    piuTypePrefix = "SCU";
                    break;
                }
                case 23: {
                    piuTypePrefix = "SUP";
                    break;
                }
                default: {
                    this.info("ignoring auType: " + auType + ", no new PiuType looked up");
                    return null;
                }
            }
        }
        String newPiuTypeProdNum = piuTypePrefix + "SS000";
        this.trace("looking up: " + newPiuTypeProdNum);
        MoIterator it = FindMo.findMOs("PiuType");
        while (it.hasMoreElements()) {
            PiuTypeMo piu = (PiuTypeMo)it.nextMo();
            this.trace("trying: " + piu.getProductData(c).getValue("productNumber"));
            if (!piu.getProductData(c).getValue("productNumber").equals(newPiuTypeProdNum)) continue;
            this.trace("found matching PiuType: " + piu);
            return piu;
        }
        this.traceError("no PiuType found with product number: " + newPiuTypeProdNum);
        throw new SoftwareErrorException();
    }

    private String nextNamingAttributeValue(String unitType) {
        Integer index = (Integer)this.hwUnitIndices.get(unitType);
        if (index == null) {
            return unitType;
        }
        int newIndex = index + 1;
        this.hwUnitIndices.put(unitType, new Integer(newIndex));
        return unitType + "-" + newIndex;
    }
}

