/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.aue;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.AueRepository;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamAueMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamUpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.CurrentUpgrade;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.FroDataConverter;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MessageLogAue;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.RecoveryHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.frodata.PersistentDictionary;
import se.ericsson.wcdma.rbs.boam.upfwk.frodata.TablePrinter;

public class BoamAue
implements UpgradeParticipator {
    private static final Class SELF = BoamAue.class;
    private static final String[] BOAM_MAIN_CLASSNAMES = new String[]{"se.ericsson.wcdma.rbs.boam.main.BoamMain", "se.ericsson.wcdma.rbs.boam.mao.bcm.BoamMain"};
    private static final String PARTICIPATOR_NAME = "BoamAue";
    public static final String UPGRADE_FROM_VERSION = "boam_upgrade_from_version";
    private final BoamAueMgr boamAueMgr;
    private final List upgradeParticipators = new LinkedList();

    public BoamAue(BoamAueMgr boamAueMgr) {
        MessageLog.traceEnter((Class)SELF, (String)"BoamAue()");
        this.boamAueMgr = boamAueMgr;
    }

    public void triggerIndicated(UpgradeMaster master, String triggerName) {
        MessageLog.info((Class)SELF, (String)(" triggerIndicated(), Trigger " + triggerName + " received"));
        try {
            if (triggerName.equals("START")) {
                this.enforceCorrectUpgradePath();
                this.checkIfFroDumpDataNeeded("fro_data_dump_pre.xml");
                this.initiateAueListPreRestart();
                this.cleanCMoData();
            } else if (triggerName.equals("FINISH")) {
                this.initiateAueListPostRestart();
                this.checkIfFroDumpDataNeeded("fro_data_dump_post.xml");
            }
            ArrayList commands = new ArrayList();
            Iterator auIter = this.upgradeParticipators.iterator();
            while (auIter.hasNext()) {
                BoamUpgradeParticipator participator = (BoamUpgradeParticipator)auIter.next();
                if (triggerName.equals("START")) {
                    participator.triggerStart(commands);
                    continue;
                }
                if (triggerName.equals("RBSINITIATE")) {
                    participator.triggerRbsInitiate(commands);
                    continue;
                }
                if (triggerName.equals("INITIATE")) {
                    participator.triggerInitiate(commands);
                    continue;
                }
                if (triggerName.equals("SOFT_LOCK")) {
                    participator.triggerSoftLock(commands);
                    continue;
                }
                if (triggerName.equals("PRELOAD")) {
                    participator.triggerPreload(commands);
                    continue;
                }
                if (triggerName.equals("BOAM_SOAM_CONVERT")) {
                    participator.triggerBoamSoamConvert(commands);
                    continue;
                }
                if (triggerName.equals("CONVERT") || triggerName.equals("RBS_CONVERT")) {
                    participator.triggerConvert(commands);
                    continue;
                }
                if (triggerName.equals("SUBRACK_TYPE")) {
                    participator.triggerSubrackType(commands);
                    continue;
                }
                if (triggerName.equals("EXECUTE")) {
                    participator.triggerExecute(commands);
                    continue;
                }
                if (triggerName.equals("FINISH")) {
                    participator.triggerFinish(commands);
                    continue;
                }
                if (triggerName.equals("RBS_FINISH") || triggerName.equals("RBS_FINNISH")) {
                    participator.triggerRbsFinish(commands);
                    continue;
                }
                if (triggerName.equals("CONFIRMED")) {
                    participator.triggerConfirmed(commands);
                    continue;
                }
                participator.handleOtherTrigger(triggerName, commands);
            }
            CommandHandler.executeTheTasks(this, triggerName, master, commands);
        }
        catch (Exception e) {
            String info = "triggerIndicated(), Error!! Operation failed due to Exception: ";
            MessageLog.traceError((Class)SELF, (String)info, (Throwable)e);
            MessageLogAue.writeTraceToSystemLog(master, this, triggerName, false, e);
        }
    }

    private void checkIfFroDumpDataNeeded(String fName) {
        try {
            File dumpNeeded = new File("/c/fro_data_dump_needed");
            if (dumpNeeded.exists()) {
                TablePrinter froTablePrinter = new TablePrinter();
                froTablePrinter.setPrintToFile("/c/" + fName);
                froTablePrinter.printAllFroTables();
                froTablePrinter.close();
                dumpNeeded.delete();
            }
        }
        catch (Throwable t) {
            MessageLog.info((Class)SELF, (String)(" checkIfFroDumpDataNeeded(), Couldn't do check/dump!!: " + t));
        }
    }

    private void initiateAueListPreRestart() throws DbAccessException {
        int targetBoamDataRev = CurrentUpgrade.getTargetBoamDataRev();
        int fromBoamDataRev = this.getBoamDataRev();
        this.upgradeParticipators.clear();
        this.initiateFroDCList(fromBoamDataRev, targetBoamDataRev);
        this.initiateAueList(fromBoamDataRev);
        PersistentDictionary.instance().put(UPGRADE_FROM_VERSION, fromBoamDataRev);
        if (this.upgradeParticipators.isEmpty()) {
            this.printListOfAvailableAues();
            MessageLog.info((Class)SELF, (String)"initiateAueListPreRestart(), nothing to do, the sub-AUE list is empty");
        }
    }

    private void initiateAueListPostRestart() throws DbAccessException {
        int targetBoamDataRev = CurrentUpgrade.getTargetBoamDataRev();
        int toBoamDataRev = this.getBoamDataRev();
        MessageLog.trace((int)9, (Class)SELF, (String)("After restart; to-version is <" + toBoamDataRev + ">"));
        if (toBoamDataRev != targetBoamDataRev) {
            MessageLog.trace((int)9, (Class)SELF, (String)("target version <" + targetBoamDataRev + "> differs from to-version!!"));
        }
        this.upgradeParticipators.clear();
        try {
            int fromVersion = PersistentDictionary.instance().getInt(UPGRADE_FROM_VERSION, 0);
            MessageLog.info((Class)SELF, (String)("After restart; upgrading from version <" + fromVersion + "> to <" + targetBoamDataRev + ">"));
            this.initiateAueList(fromVersion);
            this.initiateFroDCList(fromVersion, targetBoamDataRev);
        }
        catch (Throwable e) {
            MessageLog.info((Class)SELF, (String)"Could not read From-revision from database. Apparently the BOAM AUE was not executed in the pre-restart phase. Check the UCF file!!");
        }
        if (this.upgradeParticipators.isEmpty()) {
            this.printListOfAvailableAues();
            MessageLog.info((Class)SELF, (String)"initiateAueListPostRestart(), nothing to do, the sub-AUE list is empty.");
        }
    }

    private void initiateAueList(int rev) {
        List allAues = AueRepository.instance().getAllAues();
        Iterator it = allAues.iterator();
        while (it.hasNext()) {
            BoamUpgradeParticipator aue = (BoamUpgradeParticipator)it.next();
            if (aue.getLowVersion() > rev || rev >= aue.getHighVersion()) continue;
            this.upgradeParticipators.add(aue);
        }
    }

    private void initiateFroDCList(int fromRev, int toRev) {
        List allFroDataConverters = AueRepository.instance().getAllFroDataConverters();
        Iterator it = allFroDataConverters.iterator();
        while (it.hasNext()) {
            FroDataConverter element = (FroDataConverter)it.next();
            if (element.getLowVersion() > fromRev || fromRev >= element.getHighVersion() || element.getHighVersion() > toRev) continue;
            this.upgradeParticipators.add(element);
        }
    }

    private int getBoamDataRev() {
        MessageLog.traceEnter((Class)BoamAue.class, (String)"getBoamRev()");
        if (this.boamAueMgr.getBoamDataRevForTest() != null) {
            int result = this.boamAueMgr.getBoamDataRevForTest();
            MessageLog.trace((int)9, (Class)SELF, (String)("using previously set BOAM_DATA_REV: " + result));
            return result;
        }
        MessageLog.trace((int)9, (Class)SELF, (String)"retrieving BOAM_DATA_REV from BoamMain");
        for (int i = 0; i < BOAM_MAIN_CLASSNAMES.length; ++i) {
            try {
                Class<?> clazz = Class.forName(BOAM_MAIN_CLASSNAMES[i]);
                Object instance = clazz.newInstance();
                Method method = clazz.getMethod("getBoamDataRev", new Class[0]);
                int result = (Integer)method.invoke(instance, new Object[0]);
                MessageLog.trace((int)9, (Class)SELF, (String)(BOAM_MAIN_CLASSNAMES[i] + ".getBoamDataRev() = " + result));
                return result;
            }
            catch (ClassNotFoundException e) {
                MessageLog.trace((int)9, (Class)SELF, (String)("class not found: " + BOAM_MAIN_CLASSNAMES[i]));
                continue;
            }
            catch (Exception e) {
                MessageLog.traceError((Class)SELF, (String)"Exception when retrieving BOAM_DATA_REV", (Throwable)e);
            }
        }
        MessageLog.info((Class)SELF, (String)"Could not retrieve BOAM_DATA_REV!! Returning 0");
        return 0;
    }

    private void printListOfAvailableAues() {
        MessageLog.info((Class)SELF, (String)"Available sub-AUEs and FroDataConverters:");
        List allAues = AueRepository.instance().getAllAues();
        Iterator it = allAues.iterator();
        while (it.hasNext()) {
            BoamUpgradeParticipator element = (BoamUpgradeParticipator)it.next();
            MessageLog.info((Class)SELF, (String)("AUE " + element.getClass().getName() + ", revision low: " + element.getLowVersion() + ", revision high: " + element.getHighVersion()));
        }
        List allFroDataConverters = AueRepository.instance().getAllFroDataConverters();
        Iterator it2 = allFroDataConverters.iterator();
        while (it2.hasNext()) {
            FroDataConverter element = (FroDataConverter)it2.next();
            MessageLog.info((Class)SELF, (String)("FroDataConverter " + element.getClass().getName() + ", revision low: " + element.getLowVersion() + ", revision high: " + element.getHighVersion()));
        }
    }

    private void cleanCMoData() {
        MessageLog.traceEnter((Class)SELF, (String)"cleanCMoData()");
        TransactionWrapper tw = null;
        try {
            tw = new TransactionWrapper();
            RecoveryHandler.cleanCMoData(tw.getCoordinator());
            tw.commit();
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError((Class)SELF, (String)"Failed to create transaction!!, CMoData cannot be cleaned.", (Throwable)e);
        }
        catch (InactiveTransactionException e1) {
            try {
                if (tw != null) {
                    tw.rollback();
                    MessageLog.trace((int)9, (Class)SELF, (String)("Transaction rolled back: " + tw.getID()));
                }
            }
            catch (InactiveTransactionException e2) {
                MessageLog.traceError((Class)SELF, (String)("Failed to rollback transaction: " + tw.getID()), (Throwable)e2);
            }
        }
        catch (TransactionRequiredException e) {
            MessageLog.traceError((Class)SELF, (String)"Failed to clean CMoData!!", (Throwable)e);
        }
    }

    public String participatorName() {
        return PARTICIPATOR_NAME;
    }

    private void enforceCorrectUpgradePath() throws Exception {
        int targetBoamDataRev = CurrentUpgrade.getTargetBoamDataRev();
        int fromBoamDataRev = this.getBoamDataRev();
        MessageLog.info((Class)SELF, (String)("Before restart; upgrading from version <" + fromBoamDataRev + "> to <" + targetBoamDataRev + ">"));
        if (fromBoamDataRev > targetBoamDataRev) {
            MessageLog.traceError((Class)SELF, (String)"Not possible to upgrade, invalid from state");
            throw new Exception("Invalid upgrade path, from state higher than to state!");
        }
    }
}

