/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.aue;

import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.AueRepository;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamUpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public abstract class BoamSubAueBase
extends BoamUpgradeParticipator
implements Command {
    protected BoamSubAueBase(Class subClass) {
        super(BoamSubAueBase.shortName(subClass));
        AueRepository.instance().registerAue(this);
    }

    private static String shortName(Class clazz) {
        int p = clazz.getName().lastIndexOf(46);
        return clazz.getName().substring(p + 1);
    }

    public abstract String getDciReference();

    public final void execute() throws Exception {
        block5: {
            this.info("\nStart to execute");
            TransactionWrapper tw = this.createTransactionWrapper();
            try {
                boolean success = this.execute(tw);
                if (!tw.isActive() && success) {
                    this.info("\nAue finished successfully; transaction is no longer active");
                    break block5;
                }
                if (!tw.isActive() && !success) {
                    this.info("\nAue failed; transaction is no longer active");
                    break block5;
                }
                if (success) {
                    tw.commit();
                    this.info("\nAue finished successfully!!");
                    break block5;
                }
                this.info("\nAue failed, transaction will be rolled back!!");
                throw new Exception("Aue failed, the upgrade will be rolled back");
            }
            catch (Exception e) {
                this.rollback(tw);
                this.traceError("Interrupting the system upgrade!! Exception thrown during sub-AUE execution", e);
                throw e;
            }
        }
    }

    protected abstract boolean execute(TransactionWrapper var1) throws Exception;

    private TransactionWrapper createTransactionWrapper() throws TransactionRolledBackException {
        try {
            return new TransactionWrapper();
        }
        catch (TransactionRolledBackException e) {
            this.traceError("Interrupting the system upgrade!! Failed to create transaction", e);
            throw e;
        }
    }

    private void rollback(TransactionWrapper tw) {
        try {
            tw.rollback();
            this.info("transaction rolled back: " + tw);
        }
        catch (InactiveTransactionException e) {
            this.traceError("failed to roll back transaction '" + tw + "'", e);
        }
    }

    protected void traceEnter(String message) {
        MessageLog.traceEnter(this.getClass(), (String)message);
    }

    protected void traceReturn(String message) {
        MessageLog.traceReturn(this.getClass(), (String)message);
    }

    protected void traceError(String message) {
        MessageLog.traceError(this.getClass(), (String)message);
    }

    protected void traceError(String message, Throwable t) {
        MessageLog.traceError(this.getClass(), (String)message, (Throwable)t);
    }

    protected void info(String message) {
        MessageLog.info(this.getClass(), (String)message);
    }

    protected void trace(String message) {
        MessageLog.trace((int)9, this.getClass(), (String)message);
    }
}

