/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv;

import java.lang.reflect.Method;
import java.util.Collection;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class DCRevHandler {
    private static final String NODE_B_FUNCTION = "NodeBFunction";
    private static final String BOAM_DATA_REVISION = "boamDataRevision";
    private WorkingMoData workingMoData = null;
    private int toBoamDataRev = 0;
    private int fromBoamDataRev = 0;

    public DCRevHandler(WorkingMoData data) throws MoDataConversionException {
        this.workingMoData = data;
        this.init();
    }

    public int getBoamFromRevision() {
        return this.fromBoamDataRev;
    }

    public int getBoamToRevision() {
        return this.toBoamDataRev;
    }

    private void init() throws MoDataConversionException {
        MessageLog.traceEnter(this.getClass(), (String)"init()");
        try {
            this.toBoamDataRev = this.getBoamDataRev();
        }
        catch (Throwable t) {
            MessageLog.trace((int)9, this.getClass(), (String)"The courrent Boam Rev is older than wilma3.18");
            this.toBoamDataRev = 0;
        }
        Collection nbf = this.workingMoData.getMoData(NODE_B_FUNCTION);
        if (nbf.isEmpty()) {
            throw new MoDataConversionException("NodeBFunction MO not found in Working Data.");
        }
        MoData modata = (MoData)nbf.iterator().next();
        IntegerAttribute boamRev = (IntegerAttribute)modata.getAttribute(BOAM_DATA_REVISION);
        if (boamRev == null) {
            MessageLog.trace((int)9, this.getClass(), (String)"Boam From Rev is older than wilma3.18");
            this.fromBoamDataRev = 0;
        } else {
            this.fromBoamDataRev = boamRev.getValue(null);
        }
        MessageLog.info(this.getClass(), (String)("\n\n  ****  Boam data conversion from rev.: " + this.fromBoamDataRev + "  TO rev.: " + this.toBoamDataRev + "  ****\n\n"));
    }

    private int getBoamDataRev() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"getBoamDataRev()");
        Class<?> boamMainClass = null;
        try {
            boamMainClass = Class.forName("se.ericsson.wcdma.rbs.boam.main.BoamMain");
            MessageLog.traceEnter(this.getClass(), (String)"getBoamDataRev(), BoamMain: se.ericsson.wcdma.rbs.boam.main.BoamMain");
        }
        catch (ClassNotFoundException e) {
            boamMainClass = Class.forName("se.ericsson.wcdma.rbs.boam.mao.bcm.BoamMain");
            MessageLog.traceEnter(this.getClass(), (String)"getBoamDataRev(), BoamMain: se.ericsson.wcdma.rbs.boam.mao.bcm.BoamMain");
        }
        Object boamMainObject = boamMainClass.newInstance();
        Method m = boamMainClass.getMethod("getBoamDataRev", new Class[0]);
        Integer result = (Integer)m.invoke(boamMainObject, new Object[0]);
        return result;
    }

    public static void setBoamDataRev4Test(boolean b, int toBoamDataRev2) throws FunctionNotSupportedException {
        throw new FunctionNotSupportedException();
    }
}

