/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.helper;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CommonMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.RecoveryHandler;

public class TopologyMgr {
    private WorkingMoData workingMoData;
    private Vector originMoData;
    private Vector cMoData;
    private int noOfDeletedMoData = 0;
    private int noOfCreatedMoData = 0;
    private int noOfModifiedMoData = 0;
    private int noOfDeletedCMoData = 0;
    private int noOfCreatedCMoData = 0;

    public TopologyMgr(WorkingMoData workingMoData) throws Exception {
        if (workingMoData == null) {
            throw new Exception("TopologyMgr(), workingMoData  is null!!");
        }
        this.workingMoData = workingMoData;
        this.originMoData = (Vector)workingMoData.getOriginalData().clone();
        this.cMoData = RecoveryHandler.getCollectedMoData();
    }

    public TopologyMgr(WorkingMoData workingMoData, Coordinator context) throws Exception {
        if (workingMoData == null) {
            throw new Exception("TopologyMgr(), workingMoData  is null!!");
        }
        this.workingMoData = workingMoData;
        this.originMoData = (Vector)workingMoData.getOriginalData().clone();
        this.cMoData = RecoveryHandler.getCollectedMoData();
    }

    public String getModificationInfo() {
        return "TopologyMgr() modification information. Total no of, DeleteMoData: " + this.noOfDeletedMoData + ", Created new MoData: " + this.noOfCreatedMoData + ", updated MoData: " + this.noOfModifiedMoData + ", Created new CMoData: " + this.noOfCreatedCMoData + ", Deleted CMoData: " + this.noOfDeletedCMoData;
    }

    public void changeLdnTopology(MoData oldBaseMo, String newLdn) throws Exception {
        if (oldBaseMo == null || newLdn == null || newLdn.equals("")) {
            MessageLog.trace((int)9, this.getClass(), (String)"changeLdnTopology(), oldMo or new LDN is null");
            return;
        }
        if (newLdn.equals(oldBaseMo.getLocalDistinguishedName())) {
            MessageLog.trace((int)9, this.getClass(), (String)"changeLdnTopology(),nothing to do, the oldMo LDN = new LDN!! Probably wrong condition/implementation in the Data Converter!!");
            return;
        }
        MessageLog.traceEnter(this.getClass(), (String)("\n changeLdnTopology(), changing LDN recursively: the Base LDN : " + oldBaseMo.getLocalDistinguishedName() + ", \nwill be changed to new LDN:" + newLdn));
        this.replacingOldMoWithNewCorrectedLdn(new CommonMoData(oldBaseMo), newLdn);
        this.changeChildrenLdnRecursive(oldBaseMo.getLocalDistinguishedName(), newLdn);
        RecoveryHandler.forceRecovery();
    }

    private void updateAllMibsRefs(String oldLdn, String newLdn) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)("\n updateAllMibsRefs(), substitutes all references to old LDN:" + oldLdn + "\n with new LDN:" + newLdn));
        Iterator iter = this.originMoData.iterator();
        while (iter.hasNext()) {
            MoData moData = (MoData)iter.next();
            Enumeration attrList = moData.getAllPersistentAttributes();
            while (attrList != null && attrList.hasMoreElements()) {
                Attribute attr = (Attribute)attrList.nextElement();
                if (attr != null && attr instanceof ReferenceAttribute) {
                    ReferenceAttribute refAttr = (ReferenceAttribute)attr;
                    if (refAttr.getReferenceAsLDN() == null || !refAttr.getReferenceAsLDN().equals(oldLdn)) continue;
                    TransactionWrapper tx = null;
                    tx = new TransactionWrapper();
                    Coordinator myContext = tx.getCoordinator();
                    moData.handleTransaction(myContext, MoData.WRITE_ACCESS);
                    moData.deregisterAttribute((Attribute)refAttr);
                    ReferenceAttribute newRef = new ReferenceAttribute(refAttr.getName(), newLdn, refAttr.isAVCNotifier());
                    moData.registerPersistentAttr((Attribute)newRef);
                    tx.commit();
                    ++this.noOfModifiedMoData;
                    continue;
                }
                if (attr == null || !(attr instanceof SequenceAttribute)) continue;
                SequenceAttribute seqAttr = (SequenceAttribute)attr;
                Attribute[] seqAttrList = seqAttr.getValue(null);
                for (int i = 0; i < seqAttrList.length; ++i) {
                    Attribute refAttr = seqAttrList[i];
                    if (refAttr == null || !(refAttr instanceof ReferenceAttribute) || ((ReferenceAttribute)refAttr).getReferenceAsLDN() == null || !((ReferenceAttribute)refAttr).getReferenceAsLDN().equals(oldLdn)) continue;
                    TransactionWrapper tx = null;
                    tx = new TransactionWrapper();
                    Coordinator myContext = tx.getCoordinator();
                    moData.handleTransaction(myContext, MoData.WRITE_ACCESS);
                    seqAttr.removeElement(refAttr);
                    String tempName = refAttr.getName();
                    if (LDNHelper.isLdnFormat(tempName)) {
                        tempName = newLdn;
                    }
                    ReferenceAttribute newRef = new ReferenceAttribute(tempName, newLdn, refAttr.isAVCNotifier());
                    seqAttr.addElement((Attribute)newRef);
                    tx.commit();
                    ++this.noOfModifiedMoData;
                }
            }
        }
    }

    private void changeChildrenLdnRecursive(String oldBaseMoLdn, String newBaseMoLdn) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)("\n changeChildrenLdnRecursive(), oldBaseMo: " + oldBaseMoLdn + "  ,\n  newBaseMo: " + newBaseMoLdn));
        this.changeXMoData(this.originMoData, oldBaseMoLdn, newBaseMoLdn);
        this.changeXMoData(this.cMoData, oldBaseMoLdn, newBaseMoLdn);
    }

    private void changeXMoData(Vector xMoDataList, String oldBaseMoLdn, String newBaseMoLdn) throws Exception {
        Iterator cMoDataIter = xMoDataList.iterator();
        Vector<CommonMoData> children = new Vector<CommonMoData>(1);
        while (cMoDataIter.hasNext()) {
            CommonMoData cMoData = new CommonMoData(cMoDataIter.next());
            if (!LDNHelper.getParentLdn(cMoData.getLocalDistinguishedName(), cMoData.getMoTypeName()).equals(oldBaseMoLdn)) continue;
            children.add(cMoData);
        }
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            CommonMoData child = (CommonMoData)childIter.next();
            this.changeChildrenLdnRecursive(child.getLocalDistinguishedName(), this.changeChildLdn(child, newBaseMoLdn).getLocalDistinguishedName());
        }
    }

    private CommonMoData changeChildLdn(CommonMoData mo, String parentLdn) throws Exception {
        String newLdn = parentLdn + "," + LDNHelper.getRelativeDistinguishedName(mo.getLocalDistinguishedName());
        return this.replacingOldMoWithNewCorrectedLdn(mo, newLdn);
    }

    private CommonMoData replacingOldMoWithNewCorrectedLdn(CommonMoData oldMo, String newLdn) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)("\n replacingOldMoWithNewCorrectedLdn(), old Mo LDN: " + oldMo.getLocalDistinguishedName() + "  ,\n  new LDN: " + newLdn));
        TransactionWrapper tx = null;
        tx = new TransactionWrapper();
        Coordinator myContext = tx.getCoordinator();
        CommonMoData newMo = oldMo.isMoData() ? new CommonMoData(new MoData(newLdn, oldMo.getMoTypeName(), true, myContext)) : new CommonMoData(new CMoData(newLdn, oldMo.getMoTypeName(), true, myContext));
        Enumeration attrList = oldMo.getAllPersistentAttributes();
        while (attrList.hasMoreElements()) {
            Object element = attrList.nextElement();
            newMo.registerPersistentAttr(element);
        }
        newMo.setRevision(oldMo.getRevision());
        this.updateAllMibsRefs(oldMo.getLocalDistinguishedName(), newMo.getLocalDistinguishedName());
        newMo.handleTransaction(myContext, MoData.WRITE_ACCESS);
        oldMo.handleTransaction(myContext, MoData.WRITE_ACCESS);
        oldMo.delete(myContext);
        if (oldMo.isMoData()) {
            this.workingMoData.deleteMoData((MoData)oldMo.getCommonMoData());
            this.workingMoData.addMoData((MoData)newMo.getCommonMoData());
            ++this.noOfDeletedMoData;
            ++this.noOfCreatedMoData;
        } else {
            ++this.noOfDeletedCMoData;
            ++this.noOfCreatedCMoData;
        }
        tx.commit();
        return newMo;
    }
}

