/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.ConverterOpBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.ConverterOpContext;

public class AddReservedByOp
extends ConverterOpBase {
    public Class SELF = AddReservedByOp.class;
    private String toBeReserved = null;
    private String reserverLDN = null;

    public AddReservedByOp(WorkingMoData workingMoData, Coordinator context, String ldnToBeReserved, String ldnReserver) {
        super(workingMoData, context);
        this.toBeReserved = ldnToBeReserved;
        this.reserverLDN = ldnReserver;
    }

    public void execute(ConverterOpContext context) throws Exception {
        if (this.reserverLDN == null || this.reserverLDN.trim().equals("")) {
            MessageLog.trace((int)9, (Class)this.SELF, (String)"AddReservedByOp: the reserver LDN is emtpy, ignore execution.");
            return;
        }
        MoData reservedMO = context.getMoDataByLDN(this.toBeReserved);
        if (reservedMO == null) {
            MessageLog.trace((int)9, (Class)this.SELF, (String)("AddReservedByOp: the MO does not exist for LDN=" + this.toBeReserved + ", ignore execution."));
            return;
        }
        ReserveMoHelper.reserve(reservedMO, this.reserverLDN, context.getTransaction());
    }

    public void registerAttributeInMoData(MoData moData) throws Exception {
    }
}

