/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;

public class LongAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 0L;
    private transient long myBackup;
    private long myValue;
    private transient boolean myIsTransactionActive = false;

    public LongAttribute(String name, boolean isAttrValueChangeNotifier) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = 0L;
    }

    public LongAttribute(String name, boolean isAttrValueChangeNotifier, long initialValue) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = initialValue;
    }

    public LongAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        this.myValue = Long.parseLong(attrData.substring(2));
    }

    public synchronized long getValue(Coordinator c) {
        if (c == null && this.myIsTransactionActive) {
            return this.myBackup;
        }
        return this.myValue;
    }

    public synchronized void setValue(long aValue) {
        this.myValue = aValue;
    }

    public synchronized void setValue(Long aValue) {
        this.myValue = aValue;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator c) {
        return new Long(this.getValue(c));
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        String avc = "";
        avc = this.isAVCNotifier() ? "T" : "F";
        return this.getName() + "^l" + avc + Long.toString(this.myValue);
    }
}

