/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.frodata;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Database;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.ResultSet;
import se.ericsson.wcdma.rbs.boam.upfwk.database.ResultSetMetaData;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;

public class TablePrinter {
    Sql _sql;
    Database _db;
    PrintStream _out = System.out;
    private StringBuffer _buf = new StringBuffer();
    private int _indent = 0;

    public TablePrinter() throws DbAccessException {
        this._sql = DatabaseMgr.getSql();
        this._db = DatabaseMgr.getDatabase();
    }

    public void setPrintToMessageLog() {
        PrintStream ps = new PrintStream(new TracerStream(this.getClass()));
        this.setOutput(ps);
    }

    public void setPrintToFile(String fileName) throws FileNotFoundException {
        PrintStream ps = new PrintStream(new FileOutputStream(fileName));
        this.setOutput(ps);
    }

    public void close() {
        this.flush();
        if (this._out != System.out) {
            this._out.close();
        }
    }

    private void indent() {
        for (int i = 0; i < this._indent; ++i) {
            this._buf.append("   ");
        }
    }

    private void println(String str) {
        this.indent();
        this._buf.append(str);
        this._buf.append("\n");
    }

    private void print(String str) {
        this._buf.append(str);
    }

    public void printTable(String tableName) throws DbAccessException {
        this.printOneTable(tableName);
        this.flush();
    }

    private void flush() {
        this._out.print(this._buf);
        this._out.flush();
        this._buf = new StringBuffer();
    }

    private void printOneTable(String tableName) throws DbAccessException {
        int i;
        ResultSet rs = this._db.executeQuery(this._sql.selectAll(tableName));
        ResultSetMetaData md = rs.getMetaData();
        int cols = md.getColumnCount();
        this.println("");
        this.println("<table name=\"" + tableName + "\">");
        ++this._indent;
        this.println("<metadata>");
        ++this._indent;
        String primaryKeyName = this._db.getPrimaryKey(tableName);
        for (i = 1; i <= cols; ++i) {
            String columnTypeName = md.getColumnSqlTypeName(i);
            String columnName = md.getColumnName(i);
            this.indent();
            this.print("<column name=\"" + columnName + "\" type=\"" + columnTypeName + "\"");
            if (!md.isColumnNullable(i)) {
                this.print(" nullable=\"false\"");
            }
            if (columnName.equalsIgnoreCase(primaryKeyName)) {
                this.print(" primaryKey=\"true\"");
            }
            this.print("/>");
            this.println("");
        }
        --this._indent;
        this.println("</metadata>");
        while (rs.next()) {
            this.indent();
            this.print("<row ");
            for (i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                this.print(" " + md.getColumnName(i) + "=");
                if (o instanceof String) {
                    this.print("\"'" + o + "'\"");
                    continue;
                }
                this.print("\"" + o + "\"");
            }
            this.print("/>");
            this.println("");
        }
        --this._indent;
        this.println("</table>");
    }

    public void setOutput(PrintStream out) {
        this._out = out;
    }

    public void printAllFroTables() throws DbAccessException {
        ResultSet rs = this._db.getTables();
        this.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.println("");
        this.println("<tables>");
        ++this._indent;
        while (rs.next()) {
            String tableName = (String)rs.getObject(3);
            if (tableName.toLowerCase().indexOf("modata") != -1) continue;
            this.printTable(tableName);
        }
        rs.close();
        --this._indent;
        this.println("</tables>");
        this.flush();
    }

    private static class TracerStream
    extends OutputStream {
        private Vector _buf = new Vector();
        private Class _class;

        public TracerStream(Class c) {
            this._class = c;
        }

        public void write(int b) {
            this._buf.add(new Byte((byte)b));
        }

        public void flush() {
            byte[] bytes = new byte[this._buf.size()];
            for (int i = 0; i < this._buf.size(); ++i) {
                bytes[i] = (Byte)this._buf.elementAt(i);
            }
            String str = new String(bytes);
            this._buf.clear();
            MessageLog.info((Class)this._class, (String)str);
        }
    }
}

