/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import se.ericsson.security.empatcher.CommandLineParameters;
import se.ericsson.security.launcher.cache.CacheException;

public class LaxFile
implements Comparable {
    private static final String LAX_MAIN_METHOD_CLASS_KEY = "lax.main.class";
    private static final String LAX_MAIN_CLASS_PROPERTY = "lax.main.class=se.ericsson.security.starter.Starter";
    private static final String LAX_CLASS_PATH_KEY = "lax.class.path";
    private static final String LAX_ROOT_INSTALL_DIR = "lax.root.install.dir";
    private static final String FILE_CANNOT_BE_PARSED = "File cannot be parsed.";
    private final File originalLaxFile;
    private File newLaxFile;
    private final String cxcAndRevDirForLauncher;
    private Properties properties = new Properties();
    private String laxRootInstallDir = null;

    LaxFile(CommandLineParameters clp, File laxFile, String launcherCxcAndRevDir) {
        this.originalLaxFile = laxFile;
        this.cxcAndRevDirForLauncher = launcherCxcAndRevDir;
    }

    public int compareTo(Object o) {
        return this.originalLaxFile.compareTo(((LaxFile)o).originalLaxFile);
    }

    public void parse() throws Exception {
        try {
            FileInputStream fis = new FileInputStream(this.originalLaxFile);
            this.properties.load(fis);
        }
        catch (FileNotFoundException e) {
            throw new Exception(FILE_CANNOT_BE_PARSED, e);
        }
        catch (IOException e) {
            throw new Exception(FILE_CANNOT_BE_PARSED, e);
        }
        this.laxRootInstallDir = this.properties.getProperty(LAX_ROOT_INSTALL_DIR, "..");
    }

    public String getLaxRootInstallDir() {
        return this.laxRootInstallDir;
    }

    public String getNewLauncherLaxClassPath() throws CacheException {
        StringBuffer sb = new StringBuffer();
        sb.append(LAX_CLASS_PATH_KEY);
        sb.append("=");
        sb.append(this.getLaxRootInstallDir());
        sb.append(File.separator);
        sb.append(this.cxcAndRevDirForLauncher);
        sb.append(File.separator);
        sb.append("launcher.jar");
        sb.append(System.getProperty("path.separator"));
        sb.append("lax.jar");
        return sb.toString();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyFile() {
        File newFile = null;
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            newFile = this.getNewFileFor(this.originalLaxFile);
            out = new BufferedWriter(new FileWriter(newFile));
            out.write(this.getModificationInfo());
            out.newLine();
            out.newLine();
            in = new BufferedReader(new FileReader(this.originalLaxFile));
            String line = "";
            while ((line = in.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.startsWith(LAX_CLASS_PATH_KEY)) {
                    String path = this.convertToPathToWrite(this.getNewLauncherLaxClassPath());
                    out.write(path);
                } else if (trimmed.startsWith(LAX_MAIN_METHOD_CLASS_KEY)) {
                    out.write(LAX_MAIN_CLASS_PROPERTY);
                } else {
                    out.write(line);
                }
                out.newLine();
            }
            in.close();
            in = null;
            out.close();
            out = null;
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.newLaxFile = newFile;
        return null;
    }

    public File getOriginalFile() {
        return this.originalLaxFile;
    }

    public File getNewFile() {
        return this.newLaxFile;
    }

    private String getModificationInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("# This file has been modified by EmPatcher, ");
        Calendar now = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        sb.append(formatter.format(now.getTime()));
        return sb.toString();
    }

    private File getNewFileFor(File oldFile) {
        File newFile = new File(oldFile.toString() + ".EmPatch.tmp");
        return newFile;
    }

    static File getBakFileFor(File oldFile) {
        File bakFile = new File(oldFile.toString() + ".EmPatch.bak");
        return bakFile;
    }

    private String convertToPathToWrite(String path) {
        String convertedPath = path;
        if (File.separatorChar == '\\') {
            StringTokenizer tok = new StringTokenizer(path, "\\", true);
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                String aToken = tok.nextToken();
                buf.append(aToken);
                if (!aToken.equalsIgnoreCase("\\")) continue;
                buf.append("\\");
            }
            convertedPath = buf.toString();
        }
        return convertedPath;
    }
}

