/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.security.empatcher.CommandLineParameters;
import se.ericsson.security.empatcher.LaxFile;
import se.ericsson.security.empatcher.MsgBuffer;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.CachedFile;
import se.ericsson.security.launcher.cache.CachedJarFile;

public class LaxFileParser {
    static final String INDENT_SINGLE = "   ";
    static final String INDENT_DOUBLE = "      ";
    static final String INDENT_TRIPPLE = "         ";
    private static final String LAX_CLASS_PATH_KEY = "lax.class.path";
    private final CommandLineParameters clp;
    private final SortedSet foundLaxFiles;
    private SortedSet laxFiles = new TreeSet();
    private final SortedSet dirsToWriteLauncerTo = new TreeSet();

    public LaxFileParser(CommandLineParameters clp, SortedSet foundLaxFiles) throws CacheException {
        this.clp = clp;
        this.foundLaxFiles = foundLaxFiles;
    }

    public String parseLaxFiles() {
        MsgBuffer report = new MsgBuffer();
        report.setIndent(INDENT_SINGLE);
        MsgBuffer errorReport = new MsgBuffer();
        errorReport.setIndent(INDENT_DOUBLE);
        TreeSet<String> laxRootInstallDirs = new TreeSet<String>();
        for (File file : this.foundLaxFiles) {
            report.nl().print("File " + file.getName() + " :");
            report.nl("");
            LaxFile laxFile = null;
            try {
                laxFile = new LaxFile(this.clp, file, this.getLauncherPath());
                laxFile.parse();
                report.append(this.getModificationInfo(laxFile));
            }
            catch (Exception e) {
                errorReport.nl().print(e.getMessage());
                continue;
            }
            this.laxFiles.add(laxFile);
            laxRootInstallDirs.add(laxFile.getLaxRootInstallDir());
        }
        this.buildLauncherPaths(laxRootInstallDirs);
        StringBuffer sb = new StringBuffer();
        sb.append("New launcher directorie(s): ");
        sb.append(this.dirsToWriteLauncerTo.toString());
        report.nl().print(sb.toString());
        return report.toString();
    }

    public SortedSet getLaxFiles() {
        return this.laxFiles;
    }

    public SortedSet getDirsToWriteLauncherTo() {
        return this.dirsToWriteLauncerTo;
    }

    private MsgBuffer getModificationInfo(LaxFile laxFile) throws Exception {
        MsgBuffer detailsReport = new MsgBuffer();
        detailsReport.setIndent(INDENT_DOUBLE);
        StringBuffer oldLauncherLaxClassPath = new StringBuffer();
        oldLauncherLaxClassPath.append(LAX_CLASS_PATH_KEY);
        oldLauncherLaxClassPath.append("=");
        oldLauncherLaxClassPath.append(laxFile.getProperty(LAX_CLASS_PATH_KEY));
        String newLauncherPath = laxFile.getNewLauncherLaxClassPath();
        detailsReport.nl().print("Old : " + oldLauncherLaxClassPath.toString());
        detailsReport.nl().print("New : " + newLauncherPath);
        detailsReport.nl("");
        return detailsReport;
    }

    private void buildLauncherPaths(SortedSet tmpLaxRootInstallDirs) {
        Iterator launcherDirs = tmpLaxRootInstallDirs.iterator();
        while (launcherDirs.hasNext()) {
            StringBuffer sb = new StringBuffer();
            sb.append((String)launcherDirs.next());
            sb.append(File.separator);
            try {
                sb.append(this.getLauncherPath());
            }
            catch (CacheException e) {
                continue;
            }
            this.dirsToWriteLauncerTo.add(sb.toString());
        }
    }

    private String getLauncherPath() throws CacheException {
        String revision;
        String productNumber;
        StringBuffer sb = new StringBuffer();
        try {
            CachedFile cachedFile = this.getCachedFileForExecutingLauncher();
            productNumber = cachedFile.getAttributes().getProductNumber();
            revision = cachedFile.getAttributes().getRevision();
        }
        catch (CacheException e) {
            if (this.clp.isDesignSet()) {
                productNumber = "CXC0000000";
                revision = "R0A";
            }
            throw e;
        }
        sb.append(productNumber);
        sb.append(File.separator);
        sb.append(revision);
        return sb.toString();
    }

    private CachedFile getCachedFileForExecutingLauncher() throws CacheException {
        URL installedLauncherUrl = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        String launcherFileNameWithPath = installedLauncherUrl.getPath();
        launcherFileNameWithPath = launcherFileNameWithPath.replaceAll("%20", " ");
        CachedJarFile thisLauncherFile = new CachedJarFile(launcherFileNameWithPath, true);
        return thisLauncherFile;
    }
}

