/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.Revision;

public class ApplicationFile
implements ApplicationFileInterface {
    private String name;
    private String filePath;
    private Revision revision;
    private Revision productNumber;
    private int checkSum;

    public ApplicationFile(String name, String filePath, String productNumber, String revision) {
        this.name = name;
        this.filePath = filePath;
        this.productNumber = new Revision(productNumber);
        this.revision = new Revision(revision);
    }

    public String getName() {
        return this.name;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getProductNumber() {
        return this.productNumber.getRevisionString();
    }

    public String getRevision() {
        return this.revision.getRevisionString();
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public String toString() {
        return this.getFilePath() + " " + this.getName() + " " + this.getProductNumber() + " " + this.getRevision();
    }

    public boolean equals(Object object) {
        if (object instanceof ApplicationFile) {
            ApplicationFileInterface o = (ApplicationFileInterface)object;
            return this.getProductNumber().equals(o.getProductNumber()) && this.getRevision().equals(o.getRevision());
        }
        return false;
    }

    public int hashCode() {
        return this.getProductNumber().hashCode() + this.getRevision().hashCode();
    }
}

