/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import se.ericsson.security.launcher.cache.VerifyException;
import se.ericsson.security.launcher.cache.VerifyListener;
import se.ericsson.security.utils.EmLogger;

public class JarFileVerifier {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private X509Certificate[] trustedCerts = null;
    private X509Certificate lastValidatedLeafCert = null;
    private VerifyListener listener;

    JarFileVerifier(X509Certificate[] trustedCerts, VerifyListener verifyListener) {
        this.trustedCerts = trustedCerts;
        this.listener = verifyListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void verifyJarFile(File tempfile, URL url) throws VerifyException {
        IOException ioe22;
        ZipInputStream jarIs;
        FileInputStream fis;
        block23: {
            LOG.fine("Validating file " + tempfile, new Object[0]);
            fis = null;
            jarIs = null;
            int progress = 0;
            int read = 0;
            byte[] buffer = new byte[8192];
            if (this.hasMissingEntries(new JarFile(tempfile))) {
                this.listener.verificationFailed(url.getFile());
                throw new VerifyException("Failed to verify " + url + ". Jarfile has been tampered with");
            }
            fis = new FileInputStream(tempfile);
            jarIs = new JarInputStream((InputStream)fis, true);
            this.listener.verifying(url, tempfile, progress, fis.available());
            JarEntry je = ((JarInputStream)jarIs).getNextJarEntry();
            while (je != null && !this.listener.isCancelled()) {
                while ((read = ((JarInputStream)jarIs).read(buffer, 0, buffer.length)) != -1) {
                    progress += read;
                }
                if (!je.isDirectory()) {
                    this.verifyJarEntry(je);
                    this.listener.verifying(url, tempfile, progress, progress + fis.available());
                }
                je = ((JarInputStream)jarIs).getNextJarEntry();
            }
            buffer = null;
            Object var10_12 = null;
            if (fis == null) break block23;
            try {
                try {
                    fis.close();
                }
                catch (IOException ioe22) {
                    LOG.severe("Failed to close fileinputstream " + tempfile + ioe22.toString(), new Object[0]);
                    Object var13_15 = null;
                    fis = null;
                    break block23;
                }
                Object var13_14 = null;
                fis = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                fis = null;
                throw throwable;
            }
        }
        if (jarIs == null) return;
        try {
            try {
                jarIs.close();
            }
            catch (IOException ioe22) {
                LOG.fine("Failed to close jarinputstream " + tempfile + ioe22.toString(), new Object[0]);
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var15_26 = null;
            jarIs = null;
            throw throwable;
        }
        {
            catch (VerifyException ve) {
                LOG.warning("Could not verify file: " + url, new Object[0]);
                throw ve;
            }
            catch (SecurityException se) {
                this.listener.verificationFailed("SecurityException " + url.getFile());
                throw new VerifyException("Failed to verify " + url, (Throwable)se);
            }
            catch (IOException ie) {
                this.listener.verificationFailed("IOException " + url.getFile());
                throw new VerifyException("Failed to verify " + url, (Throwable)ie);
            }
        }
        catch (Throwable throwable) {
            IOException ioe22;
            Object var10_13 = null;
            if (fis != null) {
                try {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe22) {
                        LOG.severe("Failed to close fileinputstream " + tempfile + ioe22.toString(), new Object[0]);
                        Object var13_18 = null;
                        fis = null;
                    }
                    Object var13_17 = null;
                    fis = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    fis = null;
                    throw throwable2;
                }
            }
            if (jarIs == null) throw throwable;
            try {
                try {
                    jarIs.close();
                }
                catch (IOException ioe22) {
                    LOG.fine("Failed to close jarinputstream " + tempfile + ioe22.toString(), new Object[0]);
                    Object var15_28 = null;
                    jarIs = null;
                    throw throwable;
                }
                Object var15_27 = null;
                jarIs = null;
                throw throwable;
            }
            catch (Throwable throwable3) {
                Object var15_29 = null;
                jarIs = null;
                throw throwable3;
            }
        }
    }

    private void verifyJarEntry(JarEntry je) throws VerifyException {
        Certificate[] codeCerts = null;
        if (this.trustedCerts.length == 0) {
            LOG.warning("Verification of jar file skipped because no trusted certificate was found. Is launcher.jar signed?", new Object[0]);
            return;
        }
        try {
            codeCerts = this.getCodeSigners(je);
            if (codeCerts == null || codeCerts.length == 0) {
                if (!je.getName().startsWith("META-INF/")) {
                    this.listener.verificationFailed("Unsigned jar file");
                    throw new VerifyException("Unsigned jar entry :" + je.getName());
                }
            } else {
                this.checkCodeCerts(codeCerts);
            }
        }
        catch (VerifyException ve) {
            this.listener.verificationFailed("failed to verify");
            VerifyException e = new VerifyException("Failed to verify entry " + je.getName(), (Throwable)ve);
            throw e;
        }
    }

    private Certificate[] getCodeSigners(JarEntry je) throws VerifyException {
        if (this.isRunningJava5()) {
            LOG.finer("Java 5 detected.", new Object[0]);
            try {
                Method getCodeSigners = je.getClass().getMethod("getCodeSigners", new Class[0]);
                Object[] signers = (Object[])getCodeSigners.invoke((Object)je, new Object[0]);
                if (signers == null || signers.length == 0) {
                    return null;
                }
                if (signers.length != 1) {
                    throw new VerifyException("Ambigously signed entry: " + je.getName());
                }
                Method getSignerCertPath = signers[0].getClass().getMethod("getSignerCertPath", new Class[0]);
                CertPath certPath = (CertPath)getSignerCertPath.invoke(signers[0], new Object[0]);
                List<? extends Certificate> certs = certPath.getCertificates();
                Certificate[] codeCerts = new Certificate[certs.size()];
                certs.toArray(codeCerts);
                return codeCerts;
            }
            catch (SecurityException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new VerifyException("Unable to perform verification, InvocationTargetException:", e.getCause());
            }
        }
        return je.getCertificates();
    }

    private boolean isRunningJava5() {
        try {
            JarEntry.class.getMethod("getCodeSigners", new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            LOG.fine("Cannot determine if running Java 5.", new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void checkCodeCerts(Certificate[] codeCerts) throws VerifyException {
        if (this.lastValidatedLeafCert != null && codeCerts[0].equals(this.lastValidatedLeafCert)) {
            return;
        }
        int[] rootCertsIndex = this.getCodeCertsRoots(codeCerts);
        for (int i = 0; i < rootCertsIndex.length; ++i) {
            int leaf = i == 0 ? 0 : (rootCertsIndex[i] == rootCertsIndex[i - 1] + 1 ? rootCertsIndex[i] : rootCertsIndex[i - 1] + 1);
            if (this.lastValidatedLeafCert != null && codeCerts[leaf].equals(this.lastValidatedLeafCert)) {
                return;
            }
            if (!this.validateChain(codeCerts, leaf, rootCertsIndex[i]) || !this.isTrusted((X509Certificate)codeCerts[rootCertsIndex[i]])) continue;
            this.lastValidatedLeafCert = (X509Certificate)codeCerts[leaf];
            LOG.fine("Last Validated Leaf Cert set to " + this.lastValidatedLeafCert.getSubjectDN(), new Object[0]);
            return;
        }
        throw new VerifyException("Could not verify code signing certs");
    }

    private boolean validateChain(Certificate[] codeCerts, int leafindex, int rootindex) {
        for (int i = leafindex; i <= rootindex; ++i) {
            X509Certificate cert = (X509Certificate)codeCerts[i];
            try {
                cert.checkValidity();
            }
            catch (CertificateExpiredException e) {
                LOG.warning("Certificate has expired " + cert + e.toString(), new Object[0]);
                return false;
            }
            catch (CertificateException e) {
                LOG.severe("Certificate not valid " + cert + e.toString(), new Object[0]);
                return false;
            }
            try {
                if (i + 1 <= rootindex) {
                    cert.verify(codeCerts[i + 1].getPublicKey());
                    continue;
                }
                cert.verify(codeCerts[i].getPublicKey());
                continue;
            }
            catch (CertificateException e) {
                LOG.severe("Certificate not valid " + cert + e.toString(), new Object[0]);
                return false;
            }
            catch (GeneralSecurityException e) {
                StringBuffer sb = new StringBuffer();
                sb.append("Could not verify signature of certificate ");
                sb.append(((X509Certificate)codeCerts[i]).getSubjectDN()).append("\n");
                sb.append("Certificate chain consists of: \n");
                for (int j = leafindex; j < rootindex; ++j) {
                    sb.append(((X509Certificate)codeCerts[j]).getSubjectDN());
                    sb.append("\n");
                }
                LOG.severe(sb.toString() + e.toString(), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private int[] getCodeCertsRoots(Certificate[] certs) throws VerifyException {
        LOG.fine("Certificate chain has length " + certs.length, new Object[0]);
        Vector<Integer> result = new Vector<Integer>(1);
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = (X509Certificate)certs[i];
            if (!((Object)cert.getSubjectDN()).equals(cert.getIssuerDN())) continue;
            LOG.fine("Added Root Code Signing CA " + cert.getSubjectDN(), new Object[0]);
            result.addElement(new Integer(i));
        }
        if (result.size() == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("No root certificates found among: \n");
            for (int i = 0; i < certs.length; ++i) {
                sb.append(((X509Certificate)certs[i]).getSubjectDN()).append("\n");
            }
            LOG.severe(sb.toString(), new Object[0]);
            throw new VerifyException("Incomplete certificate chain. No root certificate found");
        }
        int[] indexarray = new int[result.size()];
        for (int i = 0; i < indexarray.length; ++i) {
            indexarray[i] = (Integer)result.elementAt(i);
        }
        return indexarray;
    }

    private boolean isTrusted(X509Certificate cert) {
        for (int i = 0; i < this.trustedCerts.length; ++i) {
            if (!((Object)cert.getIssuerDN()).equals(this.trustedCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(this.trustedCerts[i].getPublicKey());
                return true;
            }
            catch (GeneralSecurityException e) {
                LOG.severe("Failed to verify signature of " + cert.getSubjectDN(), new Object[0]);
            }
        }
        return false;
    }

    private boolean hasMissingEntries(JarFile jarFile) throws IOException {
        Manifest mf = jarFile.getManifest();
        if (mf == null) {
            throw new IOException("No manifest found for: " + jarFile.getName());
        }
        Set<Map.Entry<String, Attributes>> entries = mf.getEntries().entrySet();
        for (Map.Entry<String, Attributes> me : entries) {
            String name = me.getKey();
            if (jarFile.getEntry(name) != null) continue;
            LOG.severe(jarFile.getName() + " has been tampered with." + " File " + name + " is missing.", new Object[0]);
            return true;
        }
        return false;
    }
}

