/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public class SWServerList {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private PropertyManager pm;
    private Map<String, ArrayList<String>> NEToServerList = new HashMap<String, ArrayList<String>>();
    private List<String> quarantinedServers = new ArrayList<String>();

    public SWServerList(PropertyManager pm) {
        this.pm = pm;
    }

    void readSWServerList(URL ne) throws CacheException {
        if (this.NEToServerList.containsKey(ne.getHost())) {
            LOG.fine("SW_server.cfg already fetched for " + ne.getHost(), new Object[0]);
            return;
        }
        URL swServerListUrl = null;
        try {
            String SW_SERVERLIST_PATH = this.pm.getString("se.ericsson.security.launcher.swserver_address_url", true);
            swServerListUrl = new URL(ne.getProtocol(), ne.getHost(), ne.getPort(), SW_SERVERLIST_PATH);
        }
        catch (MalformedURLException e) {
            throw new CacheException("Could not construct URL for swserver_address.cfg");
        }
        String serverStringDelimiter = ",";
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = EmasUtilities.getInstance().getInputStreamByUrl(swServerListUrl);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(serverStringDelimiter);
                line = br.readLine();
            }
            br.close();
            is.close();
        }
        catch (FileNotFoundException e) {
            LOG.fine("Did not find software server configuration on node: " + ne.getHost(), new Object[0]);
            throw new CacheException("No SW server configuration found.");
        }
        catch (IOException e) {
            LOG.fine("Did not find software server configuration on node: " + ne.getHost(), new Object[0]);
            throw new CacheException("No SW server configuration found.");
        }
        String servers = sb.toString();
        String[] serverlist = servers.split(serverStringDelimiter);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < serverlist.length; ++i) {
            if (serverlist[i].length() <= 0) continue;
            list.add(serverlist[i]);
        }
        this.NEToServerList.put(ne.getHost(), list);
        if (serverlist.length == 0) {
            LOG.fine("No software servers were specified in configuration on node: " + ne.getHost(), new Object[0]);
        }
        this.cleanQuarantinedSWServers();
    }

    String[] getSWServerList(URL ne) {
        List list = this.NEToServerList.get(ne.getHost());
        if (list != null) {
            return list.toArray(new String[0]);
        }
        return new String[0];
    }

    void quarantineSWServer(String server) {
        LOG.fine("Put " + server + " into quarantine.", new Object[0]);
        this.quarantinedServers.add(server);
        this.cleanQuarantinedSWServers();
    }

    private void cleanQuarantinedSWServers() {
        for (ArrayList<String> list : this.NEToServerList.values()) {
            if (!list.removeAll(this.quarantinedServers)) continue;
            LOG.fine("Removed server from NEToServerList", new Object[0]);
        }
    }
}

