/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.StringTable;
import se.ericsson.cello.cmaaue.from.Constants;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class GenerateM3uAssociationAueTable
implements DataCollectorAction,
Constants {
    private static final String M3UASSOCIATION_TEMP_TABLE_NAME = "m3uassociation_temp_table";
    private static final String FROID = "FroId";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        collectorContext.getLogger().trace(4, this.getClass(), "Running action");
        ManagedObject[] managedObjectArray = this.getM3uAssociations(collectorContext);
        if (managedObjectArray == null) {
            return;
        }
        StringTable stringTable = collectorContext.getStringDatabase().getTable(M3UASSOCIATION_TEMP_TABLE_NAME);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            stringTable.writeRow(((Integer)this.getAttribute(managedObjectArray[i], FROID, coordinator)).intValue(), managedObjectArray[i].getRelativeDistinguishedName(), coordinator);
        }
    }

    private ManagedObject[] getM3uAssociations(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("M3uAssociation");
        int n = 0;
        if (moIterator != null) {
            ManagedObject[] managedObjectArray = new ManagedObject[moIterator.size()];
            while (moIterator.hasMoreElements()) {
                managedObjectArray[n] = moIterator.nextMo();
                ++n;
            }
            return managedObjectArray;
        }
        return null;
    }

    private Object getAttribute(ManagedObject managedObject, String string, Coordinator coordinator) throws AueException {
        Object object = null;
        try {
            Class<?> clazz = managedObject.getClass();
            Class[] classArray = new Class[]{Coordinator.class};
            Method method = clazz.getMethod("get" + string, classArray);
            if (method == null) {
                throw new AueException("method get" + string + "is not found");
            }
            Object[] objectArray = new Object[]{coordinator};
            object = method.invoke((Object)managedObject, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return object;
    }
}

