/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.precheck;

import se.ericsson.cello.cmaaue.precheck.OamConfigValidationUtil;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;

public class IpValidateAction {
    private MoIterator ipHostLinkMoIt = MoRepository.instance().lookupType("IpHostLink");
    private MoIterator ethernetLinkMoIt = null;

    protected void validateIpHostLink() throws MoAccessException {
        if (this.ipHostLinkMoIt.hasMoreElements()) {
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.ipHostLinkMoIt.nextMo();
            OamConfigValidationUtil.checkIpAdressUniqueness(ipHostLinkMo.getParent(), ipHostLinkMo.getIpAddress(null), ipHostLinkMo.getIpInterfaceMoRef(null), null, (ManagedObject)ipHostLinkMo, "IpHostLink");
        }
    }

    protected void validateEthernetLink() throws MoAccessException {
        if (this.ethernetLinkMoIt.hasMoreElements()) {
            EthernetLinkMo ethernetLinkMo = (EthernetLinkMo)this.ethernetLinkMoIt.nextMo();
            Struct[] structArray = ethernetLinkMo.getIpv4Addresses(null);
            for (int i = 0; i < structArray.length; ++i) {
                Struct struct = structArray[i];
                String string = (String)struct.getValue("ipAddress");
                Integer n = (Integer)struct.getValue("prefixLength");
                int n2 = n;
                OamConfigValidationUtil.checkIpAdressUniqueness(ethernetLinkMo.getParent(), string, n2, (ManagedObject)ethernetLinkMo, "EthernetLink", null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateOAMConfigOnNode() throws MoAccessException {
        if (this.ipHostLinkMoIt == null) {
            this.ethernetLinkMoIt = MoRepository.instance().lookupType("EthernetLink");
            if (this.ethernetLinkMoIt == null) return;
            this.validateEthernetLink();
            return;
        } else {
            this.validateIpHostLink();
        }
    }
}

