/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;

public class MulticastClient {
    private final int port;
    private final DatagramSocket socket;
    private final List returnPackets = new ArrayList();
    private final Logger logger;

    public MulticastClient(Configuration configuration, int port) throws SocketException {
        this.port = port;
        this.logger = configuration.getNamedLogger("jacorb.multicast");
        this.socket = new DatagramSocket();
    }

    public void multicastSend(byte[] data, int timeout) throws UnknownHostException, IOException {
        InetAddress group = InetAddress.getByName("230.0.0.1");
        DatagramPacket request = new DatagramPacket(data, data.length, group, this.port);
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException e2) {
            this.logger.warn("ERROR :: got exception setting socket timeout", e2);
        }
        this.socket.send(request);
        long waitTime = System.currentTimeMillis() + (long)timeout;
        while (System.currentTimeMillis() < waitTime) {
            try {
                DatagramPacket response = new DatagramPacket(new byte[1024], 1024);
                this.socket.receive(response);
                this.returnPackets.add(response);
            }
            catch (Exception e3) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("MulticastClient timedout after " + timeout);
            }
        }
    }

    public byte[][] getReturnedData() {
        byte[][] returnedData = new byte[this.returnPackets.size()][];
        for (int i2 = 0; i2 < this.returnPackets.size(); ++i2) {
            returnedData[i2] = ((DatagramPacket)this.returnPackets.get(i2)).getData();
        }
        return returnedData;
    }

    public void close() {
        this.socket.close();
    }
}

