/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.Contained;
import org.jacorb.ir.ContainerType;
import org.jacorb.ir.IRFilenameFilter;
import org.jacorb.ir.IRObject;
import org.jacorb.ir.ModuleDef;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.ContainerHelper;
import org.omg.CORBA.ContainerOperations;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.ModuleDefPOATie;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;
import org.omg.PortableServer.POA;

public class Container
extends IRObject
implements ContainerOperations {
    protected final IRObject delegator;
    protected final Hashtable contained = new Hashtable();
    protected final Hashtable containedLocals = new Hashtable();
    protected final File my_dir;
    protected final String path;
    protected final String full_name;
    protected org.omg.CORBA.Container this_container;
    protected org.omg.CORBA.Container defined_in;
    protected Repository containing_repository;
    protected boolean defined = false;
    private final ClassLoader loader;
    private final POA poa;
    private final Logger logger;

    public Container(IRObject delegator, String path, String full_name, ClassLoader loader, POA poa, Logger logger) {
        this.loader = loader;
        this.poa = poa;
        this.logger = logger;
        this.delegator = delegator;
        this.path = path;
        this.full_name = full_name;
        this.my_dir = new File(path + fileSeparator + (full_name != null ? full_name : "").replace('.', fileSeparator));
        if (!this.my_dir.isDirectory()) {
            throw new INTF_REPOS("no directory : " + path + fileSeparator + full_name);
        }
        this.name = delegator.getName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New Container full_name " + full_name + " name : " + this.name + " path: " + path);
        }
    }

    void loadContents() {
        this.this_container = ContainerHelper.narrow(this.delegator.getReference());
        if (this.this_container == null) {
            throw new INTF_REPOS("no container !");
        }
        if (this.delegator instanceof Contained) {
            this.containing_repository = ((Contained)this.delegator).containing_repository();
            this.defined_in = ((Contained)this.delegator).defined_in();
        } else {
            this.containing_repository = RepositoryHelper.narrow(this.delegator.getReference());
            this.defined_in = this.containing_repository;
        }
        if (this.containing_repository == null) {
            throw new INTF_REPOS("no containing repository");
        }
        String[] classes = this.my_dir.list(new IRFilenameFilter(".class"));
        String[] dirs = this.my_dir.list(new IRFilenameFilter(null));
        if (classes != null) {
            String prefix = this.full_name != null ? this.full_name + '.' : "";
            for (int j2 = 0; j2 < classes.length; ++j2) {
                try {
                    Class<?> cl;
                    Contained containedObject;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Container " + this.name + " tries " + prefix + classes[j2].substring(0, classes[j2].indexOf(".class")));
                    }
                    if ((containedObject = Contained.createContained(cl = this.loader.loadClass(prefix + classes[j2].substring(0, classes[j2].indexOf(".class"))), this.path, this.this_container, this.containing_repository, this.logger, this.loader, this.poa)) == null) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Container: nothing created for " + cl.getClass().getName());
                        continue;
                    }
                    org.omg.CORBA.Contained containedRef = Contained.createContainedReference(containedObject, this.logger, this.poa);
                    containedRef.move(this.this_container, containedRef.name(), containedRef.version());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Container " + prefix + " loads " + containedRef.name());
                    }
                    this.contained.put(containedRef.name(), containedRef);
                    this.containedLocals.put(containedRef.name(), containedObject);
                    if (!(containedObject instanceof ContainerType)) continue;
                    ((ContainerType)((Object)containedObject)).loadContents();
                    continue;
                }
                catch (Throwable e2) {
                    this.logger.error("Caught exception", e2);
                }
            }
        }
        if (dirs != null) {
            for (int k2 = 0; k2 < dirs.length; ++k2) {
                if (dirs[k2].endsWith("Package")) continue;
                File f2 = new File(this.my_dir.getAbsolutePath() + fileSeparator + dirs[k2]);
                try {
                    String[] classList = f2.list();
                    if (classList == null || classList.length <= 0) continue;
                    ModuleDef m2 = new ModuleDef(this.path, ((this.full_name != null ? this.full_name + fileSeparator : "") + dirs[k2]).replace('/', '.').replace('\\', '.'), this.this_container, this.containing_repository, this.loader, this.poa, this.logger);
                    org.omg.CORBA.ModuleDef moduleRef = ModuleDefHelper.narrow(this.poa.servant_to_reference(new ModuleDefPOATie(m2)));
                    m2.setReference(moduleRef);
                    m2.loadContents();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Container " + this.full_name + " puts module " + dirs[k2]);
                    }
                    m2.move(this.this_container, m2.name(), m2.version());
                    this.contained.put(m2.name(), moduleRef);
                    this.containedLocals.put(m2.name(), m2);
                    continue;
                }
                catch (Exception e3) {
                    this.logger.error("Caught Exception", e3);
                }
            }
        }
    }

    void define() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Container " + this.full_name + " defining...");
        }
        Enumeration e2 = this.containedLocals.elements();
        while (e2.hasMoreElements()) {
            ((IRObject)e2.nextElement()).define();
        }
        this.defined = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Container " + this.full_name + " defined");
        }
    }

    public org.omg.CORBA.Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited) {
        if (!this.defined) {
            throw new INTF_REPOS("contents undefined");
        }
        Hashtable filtered = new Hashtable();
        if (limit_type.value() == 1) {
            filtered = this.contained;
        } else {
            Enumeration f2 = this.contained.keys();
            while (f2.hasMoreElements()) {
                Object k2 = f2.nextElement();
                org.omg.CORBA.Contained c2 = (org.omg.CORBA.Contained)this.contained.get(k2);
                if (c2.def_kind().value() != limit_type.value()) continue;
                filtered.put(k2, c2);
            }
        }
        Enumeration e2 = filtered.elements();
        org.omg.CORBA.Contained[] result = new org.omg.CORBA.Contained[filtered.size()];
        for (int i2 = 0; i2 < filtered.size(); ++i2) {
            result[i2] = (org.omg.CORBA.Contained)e2.nextElement();
        }
        return result;
    }

    public org.omg.CORBA.Contained lookup(String scopedname) {
        String rest_of_name;
        String top_level_name;
        String name = scopedname.startsWith("::") ? scopedname.substring(2) : scopedname;
        if (name.indexOf("::") > 0) {
            top_level_name = name.substring(0, name.indexOf("::"));
            rest_of_name = name.substring(name.indexOf("::") + 2);
        } else {
            top_level_name = name;
            rest_of_name = null;
        }
        org.omg.CORBA.Contained top = (org.omg.CORBA.Contained)this.contained.get(top_level_name);
        if (top == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Container " + this.name + " top " + top_level_name + " not found ");
            }
            return null;
        }
        if (rest_of_name == null) {
            return top;
        }
        org.omg.CORBA.Container topContainer = ContainerHelper.narrow(top);
        if (topContainer != null) {
            return topContainer.lookup(rest_of_name);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Container " + this.name + " " + scopedname + " not found, top " + top.getClass().getName());
        }
        return null;
    }

    public org.omg.CORBA.Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited) {
        int i2;
        if (levels_to_search == 0) {
            return null;
        }
        org.omg.CORBA.Contained[] c2 = this.contents(limit_type, exclude_inherited);
        Hashtable<org.omg.CORBA.Contained, String> found = new Hashtable<org.omg.CORBA.Contained, String>();
        for (i2 = 0; i2 < c2.length; ++i2) {
            if (!c2[i2].name().equals(search_name)) continue;
            found.put(c2[i2], "");
        }
        if (levels_to_search > 1 || levels_to_search == -1) {
            for (i2 = 0; i2 < c2.length; ++i2) {
                org.omg.CORBA.Contained[] tmp_seq;
                if (!(c2[i2] instanceof org.omg.CORBA.Container) || (tmp_seq = ((org.omg.CORBA.Container)((Object)c2[i2])).lookup_name(search_name, levels_to_search - 1, limit_type, exclude_inherited)) == null) continue;
                for (int j2 = 0; j2 < tmp_seq.length; ++j2) {
                    found.put(tmp_seq[j2], "");
                }
            }
        }
        org.omg.CORBA.Contained[] result = new org.omg.CORBA.Contained[found.size()];
        int idx = 0;
        Enumeration e2 = found.keys();
        while (e2.hasMoreElements()) {
            result[idx++] = (org.omg.CORBA.Contained)e2.nextElement();
        }
        return result;
    }

    public Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs) {
        return null;
    }

    public org.omg.CORBA.ModuleDef create_module(String id, String name, String version) {
        return null;
    }

    public ConstantDef create_constant(String id, String name, String version, IDLType type, Any value) {
        return null;
    }

    public StructDef create_struct(String id, String name, String version, StructMember[] members) {
        return null;
    }

    public UnionDef create_union(String id, String name, String version, IDLType discriminator_type, UnionMember[] members) {
        return null;
    }

    public EnumDef create_enum(String id, String name, String version, String[] members) {
        return null;
    }

    public AliasDef create_alias(String id, String name, String version, IDLType original_type) {
        return null;
    }

    public ExceptionDef create_exception(String id, String name, String version, StructMember[] member) {
        return null;
    }

    public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces) {
        return null;
    }

    public ValueBoxDef create_value_box(String id, String name, String version, IDLType type) {
        return null;
    }

    public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers) {
        return null;
    }

    public NativeDef create_native(String id, String name, String version) {
        return null;
    }

    public void destroy() {
    }
}

