/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.OriginalRememberingRebindRetryStrategy;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.RebindRetryStrategy;
import org.jacorb.util.Stack;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class StackRebindRetryStrategy
extends OriginalRememberingRebindRetryStrategy {
    private final Stack stack = new Stack();
    private boolean didFallbacktoOriginalBefore;

    public StackRebindRetryStrategy(Logger logger) {
        super(logger);
    }

    public StackRebindRetryStrategy(Configuration config) {
        super(config);
    }

    protected boolean checkExceptionStatus(SystemException e2) {
        return e2.completed == CompletionStatus.COMPLETED_NO;
    }

    public void pushIOR(ParsedIOROperations piorOriginal) {
        if (this.getOriginalIOR() == piorOriginal) {
            return;
        }
        this.stack.push(piorOriginal);
    }

    protected boolean doTryRebind(RebindRetryStrategy.RebindCallback callback, ParsedIOROperations failingIOR, SystemException cause, List serviceContexts) {
        if (this.stack.empty()) {
            if (this.didFallbacktoOriginalBefore) {
                return false;
            }
            this.didFallbacktoOriginalBefore = true;
            boolean success = callback.rebind(this.getOriginalIOR());
            if (success) {
                this.didFallbacktoOriginalBefore = false;
            }
            return success;
        }
        ParsedIOROperations oldIOR = (ParsedIOROperations)this.stack.pop();
        boolean success = callback.rebind(oldIOR);
        if (!success) {
            return this.doTryRebind(callback, failingIOR, cause, serviceContexts);
        }
        return success;
    }
}

