/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dsi;

import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.miop.ServerMIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Time;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Context;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.Dynamic.Parameter;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.MIOP.UIPMC_ProfileBodyHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableGroup.TagGroupTaggedComponentHelper;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;

public class ServerRequest
extends org.omg.CORBA.ServerRequest
implements ResponseHandler {
    private RequestInputStream inputStream;
    private ReplyOutputStream out;
    private final GIOPConnection connection;
    private UtcT requestStartTime = null;
    private UtcT requestEndTime = null;
    private UtcT replyEndTime = null;
    private List scopes;
    private final boolean cachePoaNames;
    private int replyStatus = 0;
    private byte[] oid;
    private byte[] object_key;
    private String[] rest_of_name = null;
    private boolean isStreamBased;
    private SystemException sys_ex;
    private org.omg.PortableServer.ForwardRequest location_forward;
    private IOR forward_ior = null;
    private Any exception;
    private Any result;
    private NVList argList;
    private final ORB orb;
    private ServerRequestInfoImpl info = null;
    private final Logger logger;
    private TagGroupTaggedComponent tagGroup = null;
    private boolean svcCtxReply;
    private ByteArrayKey byteArrayKey;
    private int analysed = -1;
    private boolean checkRequestIDs = false;

    public ServerRequest(ORB orb, RequestInputStream inStream, GIOPConnection _connection) {
        this.orb = orb;
        Configuration config = orb.getConfiguration();
        this.logger = config.getNamedLogger("jacorb.org.giop");
        this.cachePoaNames = config.getAttributeAsBoolean("jacorb.cachePoaNames", false);
        this.checkRequestIDs = config.getAttributeAsBoolean("jacorb.poa.checkRequestIDs", false);
        this.inputStream = inStream;
        this.connection = _connection;
        this.calcTimingPolicies();
        if (this.connection.getTransport() instanceof ServerMIOPConnection) {
            CDRInputStream uipmcInStream = new CDRInputStream(orb, inStream.req_hdr.target.profile().profile_data);
            uipmcInStream.openEncapsulatedArray();
            UIPMC_ProfileBody upb = UIPMC_ProfileBodyHelper.read(uipmcInStream);
            uipmcInStream.close();
            for (int i2 = 0; i2 < upb.components.length; ++i2) {
                if (upb.components[i2].tag != 39) continue;
                CDRInputStream groupInStream = new CDRInputStream(orb, upb.components[i2].component_data);
                groupInStream.openEncapsulatedArray();
                this.tagGroup = TagGroupTaggedComponentHelper.read(groupInStream);
                groupInStream.close();
                break;
            }
        } else {
            byte[] key = ParsedIOR.extractObjectKey(inStream.req_hdr.target, orb);
            GIOPConnectionManager.ContextKey cache = this.connection.getContextKey(this.connection, key);
            if (cache != null) {
                this.object_key = cache.getKey();
                this.oid = cache.getOID();
                this.scopes = cache.getScopes();
            } else {
                this.object_key = orb.mapObjectKey(key);
                this.oid = POAUtil.extractOID(this.object_key);
            }
        }
    }

    public void setObjectKey(byte[] objectKey) {
        this.object_key = objectKey;
        this.oid = POAUtil.extractOID(this.object_key);
    }

    public TagGroupTaggedComponent getTagGroup() {
        return this.tagGroup;
    }

    public void setRemainingPOAName(String[] rest_of_name) {
        this.rest_of_name = rest_of_name;
    }

    public String[] remainingPOAName() {
        return this.rest_of_name;
    }

    public String operation() {
        return this.inputStream.req_hdr.operation;
    }

    public Any result() {
        if (this.isStreamBased) {
            Any any = this.orb.create_any();
            CDROutputStream _out = (CDROutputStream)any.create_output_stream();
            byte[] result_buf = this.orb.getBufferManager().getBuffer(this.out.size() - this.out.getBodyBegin());
            System.arraycopy(this.out.getBufferCopy(), this.out.getBodyBegin(), result_buf, 0, result_buf.length);
            _out.setBuffer(result_buf);
            _out.skip(result_buf.length);
            return any;
        }
        return this.result;
    }

    public org.omg.CORBA.NVList arguments() {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        return this.argList;
    }

    public Any except() {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        return this.exception;
    }

    public ReplyStatusType_1_2 status() {
        return ReplyStatusType_1_2.from_int(this.replyStatus);
    }

    public Context ctx() {
        return null;
    }

    public void arguments(org.omg.CORBA.NVList list) {
        this.argList = (NVList)list;
        if (this.argList != null) {
            this.inputStream.mark(0);
            Iterator e2 = this.argList.iterator();
            while (e2.hasNext()) {
                org.omg.CORBA.NamedValue namedValue = (org.omg.CORBA.NamedValue)e2.next();
                if (namedValue.flags() == 2) continue;
                try {
                    namedValue.value().read_value(this.inputStream, namedValue.value().type());
                }
                catch (Exception e1) {
                    throw new MARSHAL("Couldn't unmarshal object of type " + namedValue.value().type() + " in ServerRequest.");
                }
            }
            try {
                this.inputStream.reset();
            }
            catch (Exception e1) {
                throw new UNKNOWN("Could not reset input stream");
            }
            if (this.info != null) {
                Parameter[] params = new Parameter[this.argList.count()];
                for (int i2 = 0; i2 < params.length; ++i2) {
                    try {
                        org.omg.CORBA.NamedValue value = this.argList.item(i2);
                        ParameterMode mode = null;
                        if (value.flags() == 1) {
                            mode = ParameterMode.PARAM_IN;
                        } else if (value.flags() == 2) {
                            mode = ParameterMode.PARAM_OUT;
                        } else if (value.flags() == 3) {
                            mode = ParameterMode.PARAM_INOUT;
                        }
                        params[i2] = new Parameter(value.value(), mode);
                        continue;
                    }
                    catch (Exception e3) {
                        this.logger.info("Caught exception ", e3);
                    }
                }
                this.info.setArguments(params);
                ServerInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getServerIterator();
                try {
                    intercept_iter.iterate(this.info, (short)1);
                }
                catch (ForwardRequest e4) {
                    this.setLocationForward(new org.omg.PortableServer.ForwardRequest(e4.forward));
                }
                catch (UserException e5) {
                    this.logger.error("uncaught userexception", e5);
                }
                catch (SystemException _sys_ex) {
                    this.setSystemException(_sys_ex);
                }
                this.info = null;
            }
        }
    }

    public void set_result(Any res) {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        this.result = res;
    }

    public void set_exception(Any exception) {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        this.exception = exception;
        this.replyStatus = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply() {
        if (this.responseExpected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ServerRequest: reply to " + this.operation());
            }
            try {
                try {
                    if (this.out == null) {
                        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.from_int(this.replyStatus), this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
                    }
                    if (!this.isStreamBased) {
                        if (this.replyStatus == 1) {
                            this.exception.write_value(this.out);
                        } else if (this.replyStatus == 0) {
                            if (this.result != null) {
                                this.result.write_value(this.out);
                            }
                            if (this.argList != null) {
                                Iterator e2 = this.argList.iterator();
                                while (e2.hasNext()) {
                                    NamedValue namedValue = (NamedValue)e2.next();
                                    if (namedValue.flags() == 1) continue;
                                    try {
                                        namedValue.send(this.out);
                                    }
                                    catch (Exception e1) {
                                        throw new MARSHAL("Couldn't return (in)out arg of type " + namedValue.value().type() + " in ServerRequest.");
                                    }
                                }
                            }
                        }
                    }
                    if (this.replyStatus == 3) {
                        if (this.location_forward != null) {
                            this.out.write_Object(this.location_forward.forward_reference);
                        } else {
                            IORHelper.write(this.out, this.forward_ior);
                        }
                    } else if (this.replyStatus == 2) {
                        SystemExceptionHelper.write(this.out, this.sys_ex);
                    }
                    if (this.checkRequestIDs && this.analysed != -1) {
                        long waitTime = System.currentTimeMillis();
                        while (((ServerGIOPConnection)this.connection).peekOutStandingRequest() != this.requestId()) {
                            Thread.sleep(1000L);
                            if (System.currentTimeMillis() <= waitTime + 1800000L) continue;
                            throw new INTERNAL("Failed to reply to request in 30 mins.");
                        }
                    }
                    this.connection.sendReply(this.out);
                }
                catch (Exception ioe) {
                    this.logger.info("Error replying to request!", ioe);
                    java.lang.Object var5_7 = null;
                    if (this.checkRequestIDs && this.analysed != -1) {
                        ((ServerGIOPConnection)this.connection).popOutstandingRequest();
                    }
                }
                java.lang.Object var5_6 = null;
                if (this.checkRequestIDs && this.analysed != -1) {
                    ((ServerGIOPConnection)this.connection).popOutstandingRequest();
                }
            }
            catch (Throwable throwable) {
                java.lang.Object var5_8 = null;
                if (this.checkRequestIDs && this.analysed != -1) {
                    ((ServerGIOPConnection)this.connection).popOutstandingRequest();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream createReply() {
        byte[] svcKey;
        this.isStreamBased = true;
        if (this.out != null) {
            return this.out;
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.out.updateMutatorConnection(this.connection);
        if (this.svcCtxReply && (svcKey = this.connection.addContextKey(this.connection, this.object_key, this.oid, this.scopes)) != null) {
            CDROutputStream os = new CDROutputStream(this.orb);
            try {
                os.beginEncapsulatedArray();
                os.write_octet_array(svcKey, 0, svcKey.length);
                byte[] result = os.getBufferCopy();
                this.out.addServiceContext(new ServiceContext(1245904912, result));
            }
            finally {
                os.close();
            }
        }
        return this.out;
    }

    public OutputStream createExceptionReply() {
        this.isStreamBased = true;
        this.replyStatus = 1;
        if (this.out != null) {
            this.out.close();
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.USER_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        return this.out;
    }

    public void setSystemException(SystemException exception) {
        this.replyStatus = 2;
        if (this.out != null) {
            this.out.close();
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.SYSTEM_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        String msg = exception.getMessage();
        if (msg != null) {
            this.out.addServiceContext(ServerRequest.createExceptionDetailMessage(msg));
        }
        this.sys_ex = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext createExceptionDetailMessage(String message) {
        CDROutputStream out = new CDROutputStream();
        try {
            out.beginEncapsulatedArray();
            out.write_wstring(message);
            ServiceContext serviceContext = new ServiceContext(14, out.getBufferCopy());
            return serviceContext;
        }
        finally {
            out.close();
        }
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest request) {
        this.setLocationForward(request, false);
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest request, boolean isPermanent) {
        this.replyStatus = 3;
        if (this.out != null) {
            this.out.close();
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), isPermanent ? ReplyStatusType_1_2.LOCATION_FORWARD_PERM : ReplyStatusType_1_2.LOCATION_FORWARD, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.location_forward = request;
        this.forward_ior = null;
    }

    public void setLocationForward(IOR ior) {
        this.replyStatus = 3;
        if (this.out != null) {
            this.out.close();
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.LOCATION_FORWARD, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.location_forward = null;
        this.forward_ior = ior;
    }

    public CDRInputStream getInputStream() {
        this.isStreamBased = true;
        return this.inputStream;
    }

    public ReplyOutputStream getReplyOutputStream() {
        if (this.out == null) {
            this.createReply();
        }
        this.isStreamBased = true;
        return this.out;
    }

    public boolean responseExpected() {
        return Messages.responseExpected(this.inputStream.req_hdr.response_flags);
    }

    /*
     * WARNING - void declaration
     */
    public short syncScope() {
        void var1_1;
        switch (this.inputStream.req_hdr.response_flags) {
            case 0: {
                int result = 0;
                break;
            }
            case 1: {
                int result = 2;
                break;
            }
            case 3: {
                int result = 3;
                break;
            }
            default: {
                throw new BAD_PARAM("Illegal SYNC_SCOPE: " + this.inputStream.req_hdr.response_flags);
            }
        }
        return (short)var1_1;
    }

    public SystemException getSystemException() {
        return this.sys_ex;
    }

    public int requestId() {
        return this.inputStream.req_hdr.request_id;
    }

    public byte[] objectKey() {
        return this.object_key;
    }

    public List getScopes() {
        if (this.scopes == null || !this.cachePoaNames) {
            this.scopes = POAUtil.extractScopedPOANames(POAUtil.extractPOAName(this.object_key));
        }
        return this.scopes;
    }

    public ServiceContext[] getServiceContext() {
        return this.inputStream.req_hdr.service_context;
    }

    public byte[] objectId() {
        return this.oid;
    }

    public synchronized ByteArrayKey objectIdAsByteArrayKey() {
        if (this.byteArrayKey == null) {
            this.byteArrayKey = new ByteArrayKey(this.oid);
        }
        return this.byteArrayKey;
    }

    public boolean streamBased() {
        return this.isStreamBased;
    }

    public ReplyOutputStream get_out() {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.orb, this.requestId(), this.status(), this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        }
        return this.out;
    }

    public void setServerRequestInfo(ServerRequestInfoImpl info) {
        this.info = info;
    }

    public Object getForwardReference() {
        if (this.location_forward != null) {
            return this.location_forward.forward_reference;
        }
        if (this.forward_ior != null) {
            try {
                return this.orb.string_to_object(ParsedIOR.getIORString(this.orb, this.forward_ior));
            }
            catch (Exception e2) {
                return null;
            }
        }
        return null;
    }

    public GIOPConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcTimingPolicies() {
        ServiceContext ctx = this.inputStream.getServiceContext(7);
        if (ctx != null) {
            CDRInputStream input = new CDRInputStream(ctx.context_data);
            try {
                input.openEncapsulatedArray();
                PolicyValue[] policy = PolicyValueSeqHelper.read(input);
                for (int i2 = 0; i2 < policy.length; ++i2) {
                    if (policy[i2].ptype == 27) {
                        this.requestStartTime = Time.fromCDR(policy[i2].pvalue);
                        continue;
                    }
                    if (policy[i2].ptype == 28) {
                        this.requestEndTime = Time.fromCDR(policy[i2].pvalue);
                        continue;
                    }
                    if (policy[i2].ptype != 30) continue;
                    this.replyEndTime = Time.fromCDR(policy[i2].pvalue);
                }
            }
            finally {
                input.close();
            }
        }
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public UtcT getRequestEndTime() {
        return this.requestEndTime;
    }

    public UtcT getRequestStartTime() {
        return this.requestStartTime;
    }

    public void sendServiceCtxReply() {
        this.svcCtxReply = true;
    }

    public void clear() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    public void setAnalyser(int t2) {
        this.analysed = t2;
    }

    public int getAnalyser() {
        return this.analysed;
    }
}

