/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.RequestAnalyserProcessor;
import org.jacorb.poa.RequestProcessor;

public class SingleThreadRequestAnalyserProcessor
extends RequestAnalyserProcessor {
    private static final Object END = new Object();
    protected LinkedBlockingQueue tpcQueue;
    protected TPCThread tpct;
    private long lastAccessTime = Long.MAX_VALUE;

    public SingleThreadRequestAnalyserProcessor() {
        this.tpcQueue = new LinkedBlockingQueue();
        this.tpct = new TPCThread();
        this.tpct.setDaemon(true);
        this.tpct.start();
    }

    public boolean verify(ServerRequest dsi) {
        return dsi.getAnalyser() == 1;
    }

    public void process(RequestAnalyserProcessor.ProcessorArgs pa) {
        this.lastAccessTime = Long.MAX_VALUE;
        try {
            Logger logger = pa.r.getORB().getConfiguration().getNamedLogger("org.jacorb.poa.SingleThreadRequestAnalyserProcessor");
            if (logger.isDebugEnabled()) {
                logger.debug("Queueing request for processing " + pa.sr);
            }
            this.tpcQueue.put(pa);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        if (this.tpct != null) {
            this.tpct.end();
        }
    }

    public long getAccessTime() {
        return this.lastAccessTime;
    }

    public void configure(Configuration arg0) throws ConfigurationException {
    }

    protected class TPCThread
    extends Thread {
        private boolean run = true;

        protected TPCThread() {
        }

        public void end() {
            this.run = false;
            try {
                SingleThreadRequestAnalyserProcessor.this.tpcQueue.put(END);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            while (this.run) {
                try {
                    Object pr = SingleThreadRequestAnalyserProcessor.this.tpcQueue.take();
                    if (pr == END) continue;
                    RequestAnalyserProcessor.ProcessorArgs pa = (RequestAnalyserProcessor.ProcessorArgs)pr;
                    RequestProcessor tpcProcessor = pa.r.getPoolManager().getProcessor(true);
                    tpcProcessor.init(pa.r, pa.sr, pa.s, pa.sm);
                    tpcProcessor.begin();
                    tpcProcessor.waitForCompletion();
                    tpcProcessor = null;
                    if (!SingleThreadRequestAnalyserProcessor.this.tpcQueue.isEmpty()) continue;
                    SingleThreadRequestAnalyserProcessor.this.lastAccessTime = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

