/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.launchpad.toolservice;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.launchpad.LaunchpadLog;
import se.ericsson.cello.launchpad.toolservice.StartFailureException;
import se.ericsson.cello.launchpad.toolservice.Tool;
import se.ericsson.cello.launchpad.toolservice.ToolHandling;
import se.ericsson.cello.launchpad.toolservice.ToolServices;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolServicesImpl
implements ToolServices {
    private final LauncherInterface myLauncher;
    private final Launchable myLaunchable;
    private ToolHandling myParameterHandler;

    public ToolServicesImpl(LauncherInterface launcher, Launchable launchable, ToolHandling parameterHandler) {
        this.myLauncher = launcher;
        this.myLaunchable = launchable;
        this.myParameterHandler = parameterHandler;
    }

    @Override
    public Collection<String> getAvailableTools() {
        ArrayList<String> toolNames = new ArrayList<String>();
        Collection<Tool> tools = this.myParameterHandler.getTools();
        for (Tool tool : tools) {
            toolNames.add(tool.getName());
        }
        return toolNames;
    }

    @Override
    public String getIconImage() {
        return this.myParameterHandler.getIconPath();
    }

    @Override
    public Launchable startTool(final String toolName, final String hostname, String[] args, ActionListener listener) throws StartFailureException {
        LaunchpadLog.logger().finer("Start " + toolName);
        final Tool tool = this.myParameterHandler.getTool(toolName);
        final ActionListener listen = listener;
        if (tool == null) {
            LaunchpadLog.logger().severe("Could not find " + toolName);
            throw new StartFailureException("The tool " + toolName + " is not defined in the configuration file.");
        }
        final Properties props = this.myParameterHandler.getSupersedingProperties();
        props.put("LOG_NAME", "se.ericsson.cello.launchpad");
        if (null != this.myParameterHandler.getIconToPassOn()) {
            props.setProperty("TOOL_ICON", this.myParameterHandler.getIconToPassOn());
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    LaunchpadLog.logger().info("Launching " + toolName);
                    ToolServicesImpl.this.myLauncher.runApplication(tool.getConfigFile(), hostname, props, ToolServicesImpl.this.myLaunchable);
                }
                catch (LauncherException e) {
                    LaunchpadLog.logger().severe("Launcher could not launch " + toolName);
                    listen.actionPerformed(new ActionEvent((Object)e, 1, "Could not start " + toolName + "."));
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
        return null;
    }

    @Override
    public String getTitle() {
        return this.myParameterHandler.getTitle();
    }

    @Override
    public void exit() {
        this.myLaunchable.exit();
    }

    @Override
    public void exitAllTools() {
        Collection apps = this.myLauncher.getRunningApplications();
        Vector vec = new Vector(apps);
        try {
            for (Launchable obj : vec) {
                if (obj == this.myLaunchable) continue;
                obj.exit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myLaunchable.exit();
    }

    @Override
    public Collection<String> getStartedTools() {
        Collection apps = this.myLauncher.getRunningApplications();
        LinkedList<String> appNames = new LinkedList<String>();
        for (Launchable obj : apps) {
            appNames.add(obj.toString());
        }
        return appNames;
    }
}

