/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class OperatingMode {
    private Struct moStruct = null;
    private StructParameter parameter = null;
    private static final boolean AUTO_NEGOTIATION_DEFAULT = false;
    private static final int CONFIGURED_SPEED_DUPLEX_DEFAULT = 2;
    private static final int CONFIGURED_SPEED_DUPLEX_MIN = 1;
    private static final int CONFIGURED_SPEED_DUPLEX_MAX = 3;
    private static final int CONFIGURED_SPEED_DUPLEX_DEFAULT_ADDITIONAL_PORTS = 1;

    public OperatingMode() throws MoAccessException {
        String[] stringArray = new String[]{"autoNegotiation", "configuredSpeedDuplex"};
        Object[] objectArray = new Object[]{false, new Integer(2)};
        this.moStruct = new StructImpl(stringArray, objectArray);
    }

    public OperatingMode(int n) throws MoAccessException {
        String[] stringArray = new String[]{"autoNegotiation", "configuredSpeedDuplex"};
        if (n < 9) {
            Object[] objectArray = new Object[]{false, new Integer(2)};
            this.moStruct = new StructImpl(stringArray, objectArray);
        } else {
            Object[] objectArray = new Object[]{false, new Integer(1)};
            this.moStruct = new StructImpl(stringArray, objectArray);
        }
    }

    public OperatingMode(Struct struct) throws MoAccessException {
        OperatingMode.checkOperatingModeRanges(struct);
        this.moStruct = struct;
    }

    public OperatingMode(StructParameter structParameter) throws MoAccessException {
        this.parameter = structParameter;
    }

    public StructParameter toParameter() throws MoAccessException {
        StructParameter structParameter = new StructParameter("operatingMode");
        int n = MaoFroTypeConverter.boolean2int((boolean)((Boolean)this.moStruct.getValue("autoNegotiation")));
        structParameter.add((Parameter)new SignedIntParameter("autoNegotiation", n));
        structParameter.add((Parameter)new SignedIntParameter("configuredSpeedDuplex", ((Integer)this.moStruct.getValue("configuredSpeedDuplex")).intValue()));
        return structParameter;
    }

    private static void checkOperatingModeRanges(Struct struct) throws MoAccessException {
        if (!(struct.getValue("autoNegotiation") instanceof Boolean)) {
            throw new WrongAttributeTypeException("autoNegotiation", "EthernetSwitchModulePort");
        }
        if (!(struct.getValue("configuredSpeedDuplex") instanceof Integer)) {
            throw new WrongAttributeTypeException("configuredSpeedDuplex", "EthernetSwitchModulePort");
        }
        int n = (Integer)struct.getValue("configuredSpeedDuplex");
        struct.getValue("autoNegotiation");
        if (n < 1 || n > 3) {
            throw new ValueOutOfRangeException("configuredSpeedDuplex", "EthernetSwitchModulePort");
        }
    }

    public Struct toStruct(String string, String string2) throws MoAccessException {
        String[] stringArray = new String[]{string, string2};
        Object[] objectArray = new Object[]{MaoFroTypeConverter.int2boolean((int)((SignedIntParameter)this.parameter.get(string)).getValue()), new Integer(((SignedIntParameter)this.parameter.get(string2)).getValue())};
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }
}

