/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.ArrayList;
import se.ericsson.cello.extethswitch.VidInformation;
import se.ericsson.cello.extethswitch.VidInformationDummy;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;

public class VlanMembership {
    private ArrayList vlanMembership = null;
    private ArrayList dummies = null;
    private ArrayParameter parameter = null;
    private Struct[] moStructs = null;
    private static final int NUMBER_OF_ELEMENTS = 256;
    private static final int DEFAULT_VID = 0;

    public VlanMembership() throws MoAccessException {
        this.vlanMembership = new ArrayList(1);
        this.vlanMembership.add(new VidInformation());
        this.dummies = new ArrayList(255);
        for (int i = 1; i < 256; ++i) {
            this.dummies.add(new VidInformationDummy());
        }
        this.parameter = this.createParameter();
        this.moStructs = this.createStructs();
    }

    public VlanMembership(Struct[] structArray) throws MoAccessException {
        int n;
        if (structArray.length > 256) {
            throw new ValueOutOfRangeException("Maximum number of elements exceeded in vlanMembership", "EthernetSwitchPort");
        }
        this.vlanMembership = new ArrayList(structArray.length);
        for (n = 0; n < structArray.length; ++n) {
            VidInformation vidInformation = new VidInformation(structArray[n]);
            if (this.vlanMembership.contains(vidInformation)) {
                throw new ValueOutOfRangeException("The vid values must be unique in the attribute vlanMembership", "EthernetSwitchPort");
            }
            this.vlanMembership.add(new VidInformation(structArray[n]));
        }
        this.dummies = new ArrayList(256 - structArray.length);
        for (n = structArray.length; n < 256; ++n) {
            this.dummies.add(new VidInformationDummy());
        }
        this.moStructs = (Struct[])structArray.clone();
        this.parameter = this.createParameter();
    }

    public VlanMembership(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter.size() != 256) {
            throw new ConfigurationMismatchException("Missing element in vlanMembership from fro", "EthernetSwitchPort");
        }
        this.vlanMembership = new ArrayList();
        for (int i = 0; i < 256; ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            int n = ((SignedIntParameter)structParameter.get("vid")).getValue();
            if (n == -1) continue;
            this.vlanMembership.add(new VidInformation(structParameter));
        }
        this.moStructs = this.createStructs();
        this.parameter = arrayParameter;
    }

    public Struct[] toStructs() throws MoAccessException {
        return this.moStructs;
    }

    private Struct[] createStructs() throws MoAccessException {
        StructImpl[] structImplArray = new StructImpl[this.vlanMembership.size()];
        for (int i = 0; i < this.vlanMembership.size(); ++i) {
            structImplArray[i] = ((VidInformation)this.vlanMembership.get(i)).toStruct();
        }
        return structImplArray;
    }

    public ArrayParameter toParameter() throws MoAccessException {
        return this.parameter;
    }

    private ArrayParameter createParameter() throws MoAccessException {
        if (this.vlanMembership.size() + this.dummies.size() == 256) {
            int n;
            Object var1_1 = null;
            Object var2_2 = null;
            ArrayParameter arrayParameter = new ArrayParameter("vlanMembership");
            for (n = 0; n < this.vlanMembership.size(); ++n) {
                arrayParameter.add((Parameter)((VidInformation)this.vlanMembership.get(n)).toParameter());
            }
            for (n = 0; n < this.dummies.size(); ++n) {
                arrayParameter.add((Parameter)((VidInformationDummy)this.dummies.get(n)).toParameter());
            }
            return arrayParameter;
        }
        MessageLog.info(this.getClass(), (String)" In createParameter() the sum of HashMap sizes are not equeal to 256 ");
        return null;
    }
}

