/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.extethswitch.VlanMo;
import se.ericsson.cello.extethswitch.mom.EnumVlanType;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public abstract class VlanMoGen
extends CelloMao
implements VlanMo,
Reservable {
    protected String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"vid", "vlanType"};
    protected String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"userLabel", "vid", "VlanId", "vlanType"};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final String FROID = "vlanFroId";
    protected static final int MO_DATA_REVISION_LATEST = 7000;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryAttribute("vid", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "Vlan");
        }
    }

    protected VlanMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList) throws MoAccessException {
        super(managedObject, "Vlan", string, coordinator, initialMaoContext);
        this.froProxy = froProxy;
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("Vlan");
        setRequestContextImpl.assertAllowedAttributes(this.NON_READONLY_MOM_ATTRIBUTES, "Vlan");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "Vlan", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.setRevision(7000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"Vlan");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"vid", (AttrList)attrList, (Class)Integer.class, (String)"Vlan");
        int n2 = n;
        this.validateVid(n2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("vid", n2));
        Integer n3 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"vlanType", (AttrList)attrList, (Class)Integer.class, (String)"Vlan");
        int n4 = 0;
        if (n3 != null) {
            n4 = n3;
        }
        this.validateVlanType(n4, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("vlanType", n4));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n5 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n5));
    }

    public VlanMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        return object;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length > 0) {
            throw new MoReservedNotDeletableException("Vlan");
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setVid(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vid", new Integer(n), coordinator);
    }

    public int getVid(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("vid", coordinator);
    }

    public int getVlanType(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("vlanType", coordinator);
    }

    public String getType() {
        return "Vlan";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            SequenceAttribute sequenceAttribute;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                sequenceAttribute = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)sequenceAttribute, (Coordinator)coordinator);
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("vid")) {
                sequenceAttribute = (SignedIntParameter)getRequestContextImpl.getParameter("vid");
                if (sequenceAttribute == null) {
                    throw new FroRequestFailedException("Vlan", "Missing parameter from FRO: vid", "getAttributes", -1);
                }
                objectArray[i] = new Integer(sequenceAttribute.getValue());
            } else if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("vlanType")) {
                sequenceAttribute = (SignedIntParameter)getRequestContextImpl.getParameter("vlanType");
                if (sequenceAttribute == null) {
                    throw new FroRequestFailedException("Vlan", "Missing parameter from FRO: vlanType", "getAttributes", -1);
                }
                objectArray[i] = new Integer(sequenceAttribute.getValue());
            } else {
                objectArray[i] = super.getAttribute(stringArray[i], coordinator);
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("Vlan");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "Vlan");
            }
            if (string.equalsIgnoreCase("vid")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateVid(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("vid", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("vid", "Vlan");
            }
            throw new NoSuchAttributeException(string, "Vlan");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"Vlan");
    }

    protected void validateVid(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"vid", (int)n, (int)1, (int)4094, (String)"Vlan");
    }

    protected void validateVlanType(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"vlanType", (int)n, (int[])EnumVlanType.VALUES_ARRAY, (String)"Vlan");
    }
}

