/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.view.impl;

import java.io.InputStream;
import se.ericsson.cello.em.fm.common.utils.ifc.FileFetcher;
import se.ericsson.cello.em.fm.common.view.ifc.FileFetcherListener;
import se.ericsson.cello.emt.sshsftpservice.EmSftp;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.security.utils.EmLogger;

public class SftpFileFetcherEm
implements FileFetcher {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private final SshSftpService sshSftpService;
    private final FileFetcherListener fileFetcherListener;
    private InputStream inputStream = null;
    private EmSftp emSftp = null;
    private String toolTitle = "";
    private static final int MAX_NUM_ERROR_MESSAGES_AT_ERROR = 2;

    public SftpFileFetcherEm(SshSftpService sshSftpService, FileFetcherListener listener, String applicationTitle) {
        this.sshSftpService = sshSftpService;
        this.fileFetcherListener = listener;
        this.toolTitle = applicationTitle;
    }

    public InputStream getFileInputStream() {
        boolean error = false;
        this.fileFetcherListener.updateProgress("Logging into SFTP...");
        this.close();
        String reason = null;
        Throwable exception = null;
        try {
            this.emSftp = this.sshSftpService.getSftp(this.toolTitle);
        }
        catch (EmSshLoginException e) {
            reason = "Login failure. ";
            error = true;
            exception = e;
            LOG.severe(reason, (Throwable)e);
        }
        catch (EmSshException e) {
            reason = "SSH Connection failure. ";
            error = true;
            exception = e;
            LOG.severe(reason, (Throwable)e);
        }
        if (error) {
            this.fileFetcherListener.updateProgress(reason);
            this.fileFetcherListener.endProgress();
            String message = this.getErrorMessageFromException((Exception)exception);
            this.fileFetcherListener.showError(reason, message, null, false);
            return null;
        }
        try {
            this.fileFetcherListener.updateProgress("Get file over SFTP...");
            this.inputStream = this.emSftp.getAsInputStream("/c/logfiles/availability/CELLO_AVAILABILITY2_LOG.xml");
        }
        catch (Exception e) {
            reason = "Failed getting file.";
            LOG.severe(reason, (Throwable)e);
            this.fileFetcherListener.updateProgress(reason);
            this.fileFetcherListener.endProgress();
            StringBuilder message = new StringBuilder();
            message.append("It was not possible to read the log file: ");
            message.append("/c/logfiles/availability/CELLO_AVAILABILITY2_LOG.xml");
            if (null != e.getCause()) {
                message.append("\n");
                message.append(e.getCause().getMessage());
            }
            this.fileFetcherListener.showError(reason, message.toString(), e, false);
        }
        return this.inputStream;
    }

    private String getErrorMessageFromException(Exception e) {
        StringBuffer strBuffer = new StringBuffer("");
        if (e != null) {
            strBuffer.append(e.getMessage());
            Throwable cause = e.getCause();
            for (int numThrowables = 0; cause != null && numThrowables < 2; cause = cause.getCause(), ++numThrowables) {
                if (cause.getMessage() == null) continue;
                strBuffer.append("\n" + cause.getMessage());
            }
        }
        return strBuffer.toString();
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception e) {
            this.fileFetcherListener.showError("Failed to properly close down the SFTP connection.", "", e, false);
        }
        try {
            if (this.emSftp != null) {
                if (this.emSftp.isOpen()) {
                    this.emSftp.bye();
                }
                this.emSftp = null;
            }
        }
        catch (Exception e) {
            this.fileFetcherListener.showError("Failed to properly close down the SFTP connection.", "", e, false);
        }
    }

    public void canceled() {
    }
}

