/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.view.impl;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.em.fm.availability.view.ifc.Filterable;
import se.ericsson.cello.em.fm.availability.view.impl.Filterator;
import se.ericsson.cello.em.fm.common.view.ifc.TablePrintable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SortFilterModel
extends AbstractTableModel
implements TablePrintable {
    private static final long serialVersionUID = -1325464950505426987L;
    private TableModel model;
    private int sortColumn = 0;
    private SortDirection lastSortDirection = SortDirection.ASC;
    private ArrayList<Row> filteredRows = new ArrayList();
    private HashMap<Integer, Row> mapindex = new HashMap();

    public SortFilterModel(TableModel m) {
        this.setModel(m);
    }

    public void setModel(TableModel m) {
        if (m != null) {
            this.model = m;
            this.filteredRows = this.createAllRows();
            this.sort(this.sortColumn, true);
            this.updateMapIndex();
        } else {
            this.model = new DefaultTableModel();
        }
    }

    public void sort(int c, boolean keepSort) {
        if (this.sortColumn == c) {
            if (keepSort) {
                if (this.lastSortDirection == SortDirection.ASC) {
                    Collections.sort(this.filteredRows);
                } else {
                    Collections.sort(this.filteredRows, Collections.reverseOrder());
                }
            } else if (this.lastSortDirection == SortDirection.ASC) {
                Collections.sort(this.filteredRows, Collections.reverseOrder());
                this.lastSortDirection = SortDirection.DESC;
            } else {
                Collections.sort(this.filteredRows);
                this.lastSortDirection = SortDirection.ASC;
            }
        } else {
            this.sortColumn = c;
            Collections.sort(this.filteredRows);
            this.lastSortDirection = SortDirection.ASC;
        }
        this.fireTableDataChanged();
    }

    private ArrayList<Row> createAllRows() {
        ArrayList<Row> result = new ArrayList<Row>(this.model.getRowCount());
        int i = 0;
        while (i < this.model.getRowCount()) {
            Row row = new Row();
            row.index = i++;
            result.add(row);
        }
        return result;
    }

    private void updateMapIndex() {
        this.mapindex.clear();
        Iterator<Row> iter = this.filteredRows.iterator();
        while (iter != null && iter.hasNext()) {
            Row row = iter.next();
            this.mapindex.put(row.index, row);
        }
    }

    public void filter(Filterator filter) {
        ArrayList<Row> result = new ArrayList<Row>();
        ArrayList<Row> rowsToBeFiltered = this.createAllRows();
        Iterator<Row> iter = rowsToBeFiltered.iterator();
        while (iter != null && iter.hasNext()) {
            Row row = iter.next();
            if (!row.matches(filter)) continue;
            result.add(row);
        }
        this.filteredRows = result;
        this.sort(this.sortColumn, true);
        this.updateMapIndex();
        this.fireTableDataChanged();
    }

    public void addMouseListener(final JTable t) {
        t.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int[] rows = t.getSelectedRows();
                int[] realRows = new int[]{};
                for (int i = 0; i < rows.length; ++i) {
                    realRows = ((SortFilterModel)t.getModel()).getRealIndexes(rows);
                }
                int tableColumn = t.columnAtPoint(e.getPoint());
                int modelColumn = t.convertColumnIndexToModel(tableColumn);
                SortFilterModel.this.sort(modelColumn, false);
                Integer[] newFaked = SortFilterModel.this.getFakedIndexes(realRows);
                for (int i = 0; i < newFaked.length; ++i) {
                    t.getSelectionModel().addSelectionInterval(newFaked[i], newFaked[i]);
                }
            }
        });
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(this.filteredRows.get((int)row).index, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        this.model.setValueAt(val, this.filteredRows.get((int)row).index, col);
    }

    @Override
    public int getRowCount() {
        return this.filteredRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int c) {
        return this.model.getColumnName(c);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.model.getColumnClass(c);
    }

    public int[] getRealIndexes(int[] rows) {
        if (rows != null) {
            int[] result = new int[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                result[i] = this.filteredRows.get((int)rows[i]).index;
            }
            return result;
        }
        return new int[0];
    }

    public Integer[] getFakedIndexes(int[] rows) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            Row newRow = this.mapindex.get(rows[i]);
            result.add(this.filteredRows.indexOf(newRow));
        }
        return result.toArray(new Integer[result.size()]);
    }

    @Override
    public String getDetails(int row) {
        if (this.model instanceof TablePrintable) {
            TablePrintable cmodel = (TablePrintable)((Object)this.model);
            return cmodel.getDetails(this.filteredRows.get((int)row).index);
        }
        return "";
    }

    @Override
    public String getExportText(int row, String[] columnOrder) {
        if (this.model instanceof TablePrintable) {
            TablePrintable cmodel = (TablePrintable)((Object)this.model);
            return cmodel.getExportText(this.filteredRows.get((int)row).index, columnOrder);
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Row
    implements Comparable<Object>,
    Filterable {
        public int index;

        private Row() {
        }

        @Override
        public int compareTo(Object other) {
            Row otherRow = (Row)other;
            Object a = SortFilterModel.this.model.getValueAt(this.index, SortFilterModel.this.sortColumn);
            Object b = SortFilterModel.this.model.getValueAt(otherRow.index, SortFilterModel.this.sortColumn);
            if (a instanceof Comparable) {
                return ((Comparable)a).compareTo(b);
            }
            return this.index - otherRow.index;
        }

        @Override
        public boolean matches(Filterator filter) {
            int nrOfCols = SortFilterModel.this.model.getColumnCount();
            String[] headers = new String[nrOfCols];
            String[] rowData = new String[nrOfCols];
            for (int i = 0; i < nrOfCols; ++i) {
                headers[i] = SortFilterModel.this.model.getColumnName(i);
                rowData[i] = SortFilterModel.this.model.getValueAt(this.index, i).toString();
            }
            return filter.match(headers, rowData);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SortDirection {
        ASC,
        DESC;

    }
}

