/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import java.util.ArrayList;
import se.ericsson.cello.em.fm.common.model.impl.AbstractParser;
import se.ericsson.cello.em.fm.common.model.impl.AdditionalInformation;
import se.ericsson.cello.em.fm.common.model.impl.EventType;
import se.ericsson.cello.em.fm.common.model.impl.ExtendedEventType;
import se.ericsson.cello.em.fm.common.model.impl.ProbableCause;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.model.impl.Severity;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.fm.Alarm;

public class NealAlarmParser
extends AbstractParser {
    public RecordContent parse(Alarm alarm) {
        RecordContent recordContent = new RecordContent();
        try {
            NameValue[] nameValuePairs;
            recordContent.put(LogPart.DOMAIN_NAME, alarm.getDomainNameAbbrev());
            recordContent.put(LogPart.EVENT_TYPE, EventType.getEventType(alarm.getEventTypeDef()));
            recordContent.put(LogPart.EXTENDED_EVENT_TYPE, ExtendedEventType.getExtendedEventType(alarm.getExtendedEventType().getTag()));
            recordContent.put(LogPart.MANAGED_OBJECT_CLASS, alarm.getManagedObjectClass());
            recordContent.put(LogPart.MANAGED_OBJECT_INSTANCE, alarm.getManagedObjectInstance());
            recordContent.put(LogPart.NOTIFICATION_ID, alarm.getNotificationId());
            recordContent.put(LogPart.EVENT_TIME, this.getFormatedUtcTime(alarm.getEventTime().time));
            recordContent.put(LogPart.SYSTEM_DN, alarm.getSystemDN());
            String probableCauseValue = Integer.toString(alarm.getProbableCauseDef());
            ProbableCause probableCause = ProbableCause.getProbableCause(Short.valueOf(probableCauseValue));
            recordContent.put(LogPart.PROBABLE_CAUSE, probableCause == ProbableCause.UNKNOWN_PROBABLE_CAUSE ? probableCauseValue : probableCause);
            recordContent.put(LogPart.PERCEIVED_SEVERITY, Severity.getSeverity(Integer.valueOf(alarm.getPerceivedSeverityDef()).shortValue()));
            recordContent.put(LogPart.SPECIFIC_PROBLEM, alarm.getSpecificProblem());
            recordContent.put(LogPart.ADDITIONAL_TEXT, alarm.getAdditionalText());
            recordContent.put(LogPart.ALARM_ID, alarm.getAlarmId());
            recordContent.put(LogPart.TIME_ZONE, alarm.getEventTime().tdf);
            ArrayList<AdditionalInformation> additionalInformations = new ArrayList<AdditionalInformation>();
            for (NameValue nameValue : nameValuePairs = alarm.getAdditionalInfo()) {
                AdditionalInformation additionalInformation = new AdditionalInformation();
                additionalInformation.setType(nameValue.getName());
                additionalInformation.setValue(nameValue.getStringValue());
                additionalInformations.add(additionalInformation);
            }
            recordContent.put(LogPart.ADDITIONAL_INFORMATION, additionalInformations);
            recordContent.put(LogPart.USER_LABEL, alarm.getUserLabel());
        }
        catch (Exception e) {
            LOG.warning("Wrong format on the log file: " + e.getMessage(), new Object[0]);
            LOG.finer("Wrong format on the log file: ", (Throwable)e);
            recordContent.setOk(false);
        }
        return recordContent;
    }
}

