/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Severity {
    CRITICAL((short)2, "CRITICAL"),
    MAJOR((short)3, "MAJOR"),
    MINOR((short)4, "MINOR"),
    WARNING((short)5, "WARNING"),
    CLEARED((short)6, "CLEARED"),
    INDETERMINATE((short)1, "INDETERMINATE"),
    UNKNOWN_SEVERITY(Short.valueOf("0"), "Unknown severity");

    private static final EmLogger LOG;
    public final Short STATE;
    public final String PRESENTATION_STRING;

    private Severity(Short state, String presentationStr) {
        this.STATE = state;
        this.PRESENTATION_STRING = presentationStr;
    }

    public static Severity getSeverity(String tmpState) {
        Short state;
        try {
            state = Short.parseShort(tmpState);
        }
        catch (Exception e) {
            LOG.warning("Unknown severity: " + tmpState, new Object[0]);
            return UNKNOWN_SEVERITY;
        }
        return Severity.getSeverity(state);
    }

    public static Severity getSeverity(Short state) {
        for (Severity severity : Severity.values()) {
            if (!severity.STATE.equals(state)) continue;
            return severity;
        }
        LOG.warning("Unknown severity (1-6): '" + state + "'", new Object[0]);
        return UNKNOWN_SEVERITY;
    }

    public String toString() {
        return this.PRESENTATION_STRING;
    }

    static {
        LOG = EmLogger.TROUBLE_SHOOTING;
    }
}

