/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.utils.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.omg.TimeBase.UtcT;

public class TimeConverter {
    private SimpleDateFormat clientTimeFormatter;
    private SimpleDateFormat utcFormatter;
    private SimpleDateFormat utcFormatterWithMilliseconds;
    public boolean convertToClientLocalTime;
    public boolean convertToUtcTime;
    public final long gregorianCutover;
    private TimeZone utcTimeZone = TimeZone.getTimeZone("GMT+00:00");
    private Locale localeUS = new Locale("en", "US");
    SimpleDateFormat[] formatterType = new SimpleDateFormat[]{new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z", this.localeUS), new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa", this.localeUS), new SimpleDateFormat("'Date:' yyyy-MM-dd, 'Time:'HH:mm:ss.SSS", this.localeUS), new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", this.localeUS), new SimpleDateFormat("yy'W'ww", this.localeUS), new SimpleDateFormat("yyyyMMdd", this.localeUS), new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", this.localeUS), new SimpleDateFormat(" EEE MMM dd HH:mm:ss yyyy", this.localeUS), new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss", this.localeUS)};

    public TimeConverter() {
        this.gregorianCutover = 12219292800000L;
        this.clientTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.utcFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.utcFormatterWithMilliseconds = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.utcFormatter.setTimeZone(this.utcTimeZone);
        this.utcFormatterWithMilliseconds.setTimeZone(this.utcTimeZone);
        this.convertToClientLocalTime = true;
        this.convertToUtcTime = false;
        for (int i = 0; i < this.formatterType.length; ++i) {
            this.formatterType[i].setTimeZone(this.utcTimeZone);
            this.formatterType[i].setLenient(true);
        }
    }

    public String formatTime(UtcT UtcTTime) {
        String timeString = null;
        long timeServerTime = (UtcTTime.time - (long)UtcTTime.inacclo) / 10000L;
        Date utcDate = new Date(timeServerTime - this.gregorianCutover);
        String _UTC_DateString = this.utcFormatter.format(utcDate);
        if (this.convertToClientLocalTime) {
            Integer localOffset = this.getLocalOffset(_UTC_DateString);
            Date localClientDate = new Date(timeServerTime - this.gregorianCutover + (long)localOffset.intValue());
            String clientTime_DateString = this.utcFormatter.format(localClientDate);
            timeString = this.formatTimeToISO(clientTime_DateString, localOffset, true);
        } else if (this.convertToUtcTime) {
            Integer localOffset = null;
            timeString = this.formatTimeToISO(_UTC_DateString, localOffset, false);
        }
        return timeString;
    }

    public String getCurrentTime() {
        String timeString = null;
        if (this.convertToClientLocalTime) {
            long time = System.currentTimeMillis();
            Date date = new Date(time);
            String dateString = this.clientTimeFormatter.format(date);
            Integer localOffset = Calendar.getInstance().get(15) + Calendar.getInstance().get(16);
            timeString = this.formatTimeToISO(dateString, localOffset, true);
        } else if (this.convertToUtcTime) {
            timeString = this.getCurrentNodeUtcTime();
        }
        return timeString;
    }

    public String getCurrentNodeUtcTime() {
        String timeString = null;
        return timeString;
    }

    private String formatTimeToISO(String dateString, Integer localOffset, boolean formatWithClientTime) {
        String offsetString = null;
        String sign = null;
        if (formatWithClientTime) {
            sign = "+";
            if (localOffset < 0) {
                sign = "-";
            }
            long hourOffset = Math.abs(localOffset) / 1000 / 60 / 60;
            offsetString = Math.abs(localOffset) < 36000000 ? "0" + Math.abs(localOffset) / 1000 / 60 / 60 : "" + Math.abs(localOffset) / 1000 / 60 / 60;
            long minoffset = ((long)Math.abs(localOffset) - hourOffset * 60L * 60L * 1000L) / 1000L / 60L;
            offsetString = minoffset == 0L ? offsetString + ":00" : offsetString + ":" + minoffset;
        } else {
            sign = "Z";
            offsetString = "";
        }
        String fomattedTime = dateString + sign + offsetString;
        return fomattedTime;
    }

    private Integer getLocalOffset(String utc_date) {
        int year = Integer.parseInt(utc_date.substring(0, 4));
        int month = Integer.parseInt(utc_date.substring(5, 7));
        int day = Integer.parseInt(utc_date.substring(8, 10));
        int hours = Integer.parseInt(utc_date.substring(11, 13));
        int minutes = Integer.parseInt(utc_date.substring(14, 16));
        int seconds = Integer.parseInt(utc_date.substring(17, 19));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(year, --month, day, hours, minutes, seconds);
        int zone_offset = gregorianCalendar.get(15);
        int dst_offset = gregorianCalendar.get(16);
        Integer total_offset = zone_offset + dst_offset;
        return total_offset;
    }
}

