/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.security.cppsec.esa.IpSecInstallationException;
import se.ericsson.security.cppsec.esa.IpSecInstallationInputException;
import se.ericsson.security.cppsec.esa.NodeIpSecHandler;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.IpSec;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;
import se.ericsson.security.cppsec.esa.wrapper.MoRepositoryWrapperFactory;
import se.ericsson.security.cppsec.esa.wrapper.TransactionHelper;

public class NodeIpSecHandlerImpl
implements NodeIpSecHandler {
    private final int DEFAULT_RETRY_COUNT;
    private final int DEFAULT_SLEEP_TIME;
    protected int installTrustedCertsTimeout = 300000;
    private static final String IPSEC_MO_LDN = "ManagedElement=1,IpSystem=1,IpSec=1";
    private String ipSecMoLdn = "ManagedElement=1,IpSystem=1,IpSec=1";
    private final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(this.getClass());
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();
    protected String username = "";
    private static final String NODE_PASSWORD = "x";
    private final EsaMessageSender messageSender;

    protected NodeIpSecHandlerImpl(EsaMessageSender esaMessageSender) {
        this.messageSender = esaMessageSender;
        this.DEFAULT_SLEEP_TIME = EsaConstantsFactory.getEsaConstants().getDefaultSleepTime();
        this.DEFAULT_RETRY_COUNT = EsaConstantsFactory.getEsaConstants().getDefaultRetryCount();
    }

    public void clearPreviousIpSecConfiguration() throws IpSecInstallationException {
        try {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                this.reportLogger.logMessage("Cancelling IpSec MO actions");
                int n = ipSecMo.getTrustedCertInstallState(coordinator);
                if (n == 1 || n == 2) {
                    ipSecMo.actionCancelInstallTrustedCertificates(coordinator);
                }
                ipSecMo.actionCancelCertEnrollment(coordinator);
                TransactionHelper.commit(control);
                this.reportLogger.logMessage("IPSEC: Removing installed ipsec certificates");
                this.clearPreviousTrustedCertificates();
            }
            catch (IpSecInstallationException ipSecInstallationException) {
                TransactionHelper.rollback(control);
                throw new IpSecInstallationException("Unable to clear already existing security configuration.", ipSecInstallationException);
            }
            catch (MoAccessException moAccessException) {
                TransactionHelper.rollback(control);
                throw new IpSecInstallationException("Unable to clear already existing security configuration.", moAccessException);
            }
            catch (SecurityActivationException securityActivationException) {
                throw new IpSecInstallationException("Unable to clear already existing security configuration.", securityActivationException);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Unable to clear already existing security configuration.", securityActivationException);
        }
    }

    private void clearPreviousTrustedCertificates() throws IpSecInstallationException {
        try {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                Struct[] structArray = ipSecMo.getInstalledTrustedCertificates(coordinator);
                TransactionHelper.commit(control);
                if (structArray.length != 0) {
                    this.reportLogger.logMessage("Removing previously installed trusted certificates");
                    for (int i = 0; i < structArray.length; ++i) {
                        String string = (String)structArray[i].getValue("serialNumber");
                        String string2 = (String)structArray[i].getValue("issuer");
                        this.reportLogger.logMessage("IPSEC: Removing cert with serial: " + string + " by issuer: " + string2);
                        Control control2 = TransactionHelper.create();
                        Coordinator coordinator2 = control2.getCoordinator();
                        ipSecMo.actionRemoveTrustedCert(string, string2, coordinator2);
                        TransactionHelper.commit(control2);
                    }
                }
                control = TransactionHelper.create();
                coordinator = control.getCoordinator();
                Struct[] structArray2 = ipSecMo.getInstalledTrustedCertificates(coordinator);
                int n = 0;
                while (structArray2.length > 0) {
                    try {
                        Thread.sleep(this.DEFAULT_SLEEP_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                        this.reportLogger.logMessage("Interrupted while waiting for installed ipsec trusted certs to be removed.");
                    }
                    if (n++ > this.DEFAULT_RETRY_COUNT) {
                        TransactionHelper.rollback(control);
                        throw new IpSecInstallationException("Unable to remove previously installed trusted certificates!");
                    }
                    structArray2 = ipSecMo.getInstalledTrustedCertificates(coordinator);
                }
                TransactionHelper.commit(control);
            }
            catch (MoAccessException moAccessException) {
                TransactionHelper.rollback(control);
                throw new IpSecInstallationException("Unable to remove previously installed trusted certificates!", moAccessException);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Unable to remove previously installed trusted certificates!", securityActivationException);
        }
    }

    public void initiateCertificateEnrollment(Struct struct) throws IpSecInstallationException {
        try {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            this.reportLogger.logMessage("calling action 'InitCertEnrollment' on IpSec MO");
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                ipSecMo.actionInitCertEnrollment(struct, coordinator);
                TransactionHelper.commit(control);
            }
            catch (MoAccessException moAccessException) {
                try {
                    ipSecMo.actionCancelCertEnrollment(coordinator);
                    TransactionHelper.commit(control);
                }
                catch (MoAccessException moAccessException2) {
                    TransactionHelper.rollback(control);
                    throw new IpSecInstallationException("Action InitCertEnrollment failed.", moAccessException2);
                }
                throw new IpSecInstallationException("Action InitCertEnrollment failed.", moAccessException);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Action InitCertEnrollment failed.", securityActivationException);
        }
    }

    public void installTrustedCertificates(Struct[] structArray, Struct[] structArray2) throws IpSecInstallationException {
        try {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                this.reportLogger.logMessage("Calling the action 'InstallTrustedCertificates' on the IpSec MO");
                ipSecMo.actionInstallTrustedCertificates(structArray, structArray2, coordinator);
                TransactionHelper.commit(control);
            }
            catch (MoAccessException moAccessException) {
                TransactionHelper.rollback(control);
                throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed.", moAccessException);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed.", securityActivationException);
        }
    }

    public void waitForCertEnrollment(int n) throws IpSecInstallationException {
        try {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            boolean bl = true;
            int n2 = 0;
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                int n3 = ipSecMo.getCertEnrollState(coordinator);
                while (0 != n3) {
                    if (n2 > n * 1000) {
                        ipSecMo.actionCancelCertEnrollment(coordinator);
                        TransactionHelper.commit(control);
                        throw new IpSecInstallationException("Certificate enrollment failed: The request timed out");
                    }
                    if (bl) {
                        this.messageSender.sendMessage("Waiting for the certificate enrollment to complete.");
                        this.reportLogger.logMessage("IPSEC: Waiting for the certificate enrollment to complete.");
                        bl = false;
                    }
                    if (2 == n3) {
                        String string = ipSecMo.getCertEnrollErrorMsg(coordinator);
                        this.messageSender.sendMessage("Cancelling certificate enrollment due to failure.");
                        ipSecMo.actionCancelCertEnrollment(coordinator);
                        TransactionHelper.commit(control);
                        throw new IpSecInstallationException("Certificate enrollment failed: " + string);
                    }
                    try {
                        Thread.sleep(this.DEFAULT_SLEEP_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n2 += this.DEFAULT_SLEEP_TIME;
                    n3 = ipSecMo.getCertEnrollState(coordinator);
                    this.reportLogger.logMessage("IPSEC: Waiting for CertificateEnrollment to finish, current state: " + n3);
                }
                TransactionHelper.commit(control);
            }
            catch (MoAccessException moAccessException) {
                TransactionHelper.rollback(control);
                throw new IpSecInstallationException("Failed to verify successful certificate enrollment", moAccessException);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Certificate enrollment failed: ", securityActivationException);
        }
    }

    public void waitForInstallTrustedCerts(int n) throws IpSecInstallationException {
        try {
            this.messageSender.sendMessage("Waiting for installation of trusted certificates to complete.");
            this.reportLogger.logMessage("IPSEC: Waiting for installation of trusted certificates to complete.");
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            int n2 = 0;
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                Struct[] structArray = ipSecMo.getInstalledTrustedCertificates(coordinator);
                boolean bl = true;
                while (structArray.length < n) {
                    if (n2 > this.installTrustedCertsTimeout) {
                        this.messageSender.sendMessage("Cancelling installation of trusted certificates due to failure.");
                        ipSecMo.actionCancelInstallTrustedCertificates(coordinator);
                        TransactionHelper.commit(control);
                        throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed.The request timed out");
                    }
                    if (bl) {
                        this.reportLogger.logMessage("IPSEC: Waiting for installation of trusted certificates to finish. Expecting " + n + " certs and have " + structArray.length);
                        bl = false;
                    }
                    if (ipSecMo.getTrustedCertInstallState(coordinator) == 2) {
                        this.messageSender.sendMessage("Cancelling installation of trusted certificates due to failure.");
                        String string = ipSecMo.getTrustedCertInstallErrorMsg(coordinator);
                        ipSecMo.actionCancelInstallTrustedCertificates(coordinator);
                        TransactionHelper.commit(control);
                        throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed. IpSecMo.trustedCertInstallErrorMsg: " + string);
                    }
                    try {
                        Thread.sleep(this.DEFAULT_SLEEP_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n2 += this.DEFAULT_SLEEP_TIME;
                    structArray = ipSecMo.getInstalledTrustedCertificates(coordinator);
                }
                if (ipSecMo.getTrustedCertInstallState(coordinator) == 2) {
                    this.messageSender.sendMessage("Cancelling installation of trusted certificates due to failure.");
                    String string = ipSecMo.getTrustedCertInstallErrorMsg(coordinator);
                    ipSecMo.actionCancelInstallTrustedCertificates(coordinator);
                    TransactionHelper.commit(control);
                    throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed. IpSecMo.trustedCertInstallErrorMsg: " + string);
                }
                this.messageSender.sendMessage("Trusted Certs succesfully installed");
                this.reportLogger.logMessage("IPSEC: Trusted Certs succesfully installed");
                TransactionHelper.commit(control);
            }
            catch (MoAccessException moAccessException) {
                TransactionHelper.rollback(control);
                throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed.", moAccessException);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed.", securityActivationException);
        }
    }

    public void setIpSecMoAttributes(IpSec ipSec) throws IpSecInstallationException, IpSecInstallationInputException {
        try {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            try {
                this.setIpSecMoUserLabel(ipSec.getUserLabel(), coordinator);
                this.setIpSecMoCertExpirWarnTime(ipSec.getCertExpirWarnTime(), coordinator);
                TransactionHelper.commit(control);
            }
            catch (IpSecInstallationException ipSecInstallationException) {
                TransactionHelper.rollback(control);
                throw ipSecInstallationException;
            }
            catch (IpSecInstallationInputException ipSecInstallationInputException) {
                TransactionHelper.rollback(control);
                throw ipSecInstallationInputException;
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Failed to set attributes on the IpSec MO", securityActivationException);
        }
    }

    protected void setIpSecMoCertExpirWarnTime(int n, Coordinator coordinator) throws IpSecInstallationInputException, IpSecInstallationException {
        this.messageSender.sendMessage("Setting attribute 'certExpirWarnTime' on Security MO: " + n);
        try {
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            try {
                ipSecMo.setCertExpirWarnTime(n, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new IpSecInstallationException("The attribute 'certExpirWarnTime' could not be set on the Security MO.", moAccessException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IpSecInstallationInputException("The attribute 'certExpirWarnTime' could not be set on the Security MO due to invalid input.", numberFormatException);
        }
    }

    protected void setIpSecMoUserLabel(String string, Coordinator coordinator) throws IpSecInstallationException {
        if (string != null) {
            this.messageSender.sendMessage("Setting attribute 'userLabel' on Security MO: " + string);
            try {
                IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
                ipSecMo.setUserLabel(string, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new IpSecInstallationException("The attribute 'userLabel' could not be set on the Security MO", moAccessException);
            }
        }
    }

    public void verifyPreconditions() throws IpSecInstallationException {
        IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
        if (ipSecMo == null) {
            throw new IpSecInstallationException("The IpSec MO could not be found, ipsec installation not possible.");
        }
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public Struct getIpSecCertInfo() throws IpSecInstallationException, SecurityActivationException {
        Struct struct;
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
        try {
            struct = ipSecMo.getCertificate(coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new IpSecInstallationException("could not fetch IpsecCertInfo", moAccessException);
        }
        catch (SecurityActivationException securityActivationException) {
            TransactionHelper.rollback(control);
            throw new IpSecInstallationException("transaction fault when fetching IpsecCertInfo", securityActivationException);
        }
        return struct;
    }

    public boolean validCertificateExists() throws IpSecInstallationException {
        try {
            Struct struct = this.getIpSecCertInfo();
            if (struct != null && !((String)struct.getValue("serialNumber")).equals("")) {
                String string = "20" + (String)struct.getValue("notValidBefore");
                String string2 = "20" + (String)struct.getValue("notValidAfter");
                this.reportLogger.logMessage("IPSEC: existing certificate notValidBefore:" + string);
                this.reportLogger.logMessage("IPSEC: existing certificate notValidAfter:" + string2);
                return NodeIpSecHandlerImpl.checkCertificateTime(string, string2);
            }
            return false;
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("Could not fetch IpSecCertificate", securityActivationException);
        }
        catch (MoAccessException moAccessException) {
            throw new IpSecInstallationException("Could not fetch IpSecCertificate", moAccessException);
        }
    }

    private static boolean checkCertificateTime(String string, String string2) {
        Date date = new Date();
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date2 = simpleDateFormat.parse(string, parsePosition);
        ParsePosition parsePosition2 = new ParsePosition(0);
        Date date3 = simpleDateFormat.parse(string2, parsePosition2);
        if (date2 == null || date3 == null) {
            return false;
        }
        return date.after(date2) && date.before(date3);
    }

    public void setIpSecMoLdn(String string) throws IpSecInstallationException {
        this.reportLogger.logMessage("NodeIpSecHandlerImpl.setIpSecMoLdn() with ldn = " + string);
        if (string != null && !"".equals(string)) {
            this.ipSecMoLdn = string;
            IpSecMo ipSecMo = this.lookupIpSecMo(this.ipSecMoLdn);
            if (ipSecMo == null) {
                throw new IpSecInstallationException("The IpSec MO could not be found, ipsec installation not possible.");
            }
        } else {
            throw new IpSecInstallationException("Invalid ldn provided for the IpSecMo. Ldn = " + string);
        }
    }

    private IpSecMo lookupIpSecMo(String string) throws IpSecInstallationException {
        IpSecMo ipSecMo = (IpSecMo)MoRepositoryWrapperFactory.getMoRepositoryWrapper().lookup(string);
        if (ipSecMo == null) {
            throw new IpSecInstallationException("The IpSec MO could not be found, ipsec installation not possible.");
        }
        return ipSecMo;
    }
}

