/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.encryptedcontent;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.encryptedcontent.EncryptedContentStorage;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.EncryptedContent;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;

public class EncryptedContentStorageMgr {
    private final List createdInstances = new ArrayList();
    public final String filePathName;
    public final File filePath;
    public static final String SECURITY = "security";
    public static final String IPSEC = "ipsec";

    public EncryptedContentStorageMgr(String string) {
        if (string.equals(SECURITY)) {
            this.filePathName = EsaConstantsFactory.getEsaConstants().getSecurityEsaPath();
        } else if (string.equals(IPSEC)) {
            this.filePathName = EsaConstantsFactory.getEsaConstants().getSecurityIpSecPath();
        } else {
            EsaReportLogger.getInstance().logMessage("Unable to assign a value to file path. ");
            this.filePathName = "Undefined";
        }
        this.filePath = new File(this.filePathName);
        if (this.filePathName.equals("Undefined") || !this.filePath.isDirectory() && (this.filePath.exists() || !this.filePath.mkdir())) {
            EsaReportLogger.getInstance().logMessage("Unable to create file path: " + this.filePathName);
        }
    }

    public void deleteAllFiles() {
        Iterator iterator = this.createdInstances.iterator();
        while (iterator.hasNext()) {
            ((EncryptedContentStorage)iterator.next()).deleteFile();
        }
        this.createdInstances.clear();
    }

    public EncryptedContentStorage createEncryptedContentStorage(EncryptedContent encryptedContent, String string, String string2) throws SecurityActivationInputException {
        EncryptedContentStorage encryptedContentStorage = new EncryptedContentStorage(encryptedContent, string, string2, this.filePath);
        this.createdInstances.add(encryptedContentStorage);
        return encryptedContentStorage;
    }
}

