/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.CertFile;
import se.ericsson.security.cppsec.esa.model.EncryptedContent;
import se.ericsson.security.cppsec.esa.model.elements.EncryptedContentElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class CertFileElement
extends StackElement
implements CertFile {
    private static final String CERT_FINGERPRINT = "certFingerprint";
    private static final String CERT_SERIAL_NUMBER = "certSerialNumber";
    private static final String CATEGORY = "category";
    public static final String CERTFILE = "certFile";
    private String certFingerPrint;
    private String certSerialNumber;
    private String category;
    private EncryptedContentElement encryptedContent;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        EncryptedContentElement encryptedContentElement = null;
        if ("encryptedContent".equalsIgnoreCase(string2)) {
            encryptedContentElement = new EncryptedContentElement();
        }
        this.encryptedContent = encryptedContentElement;
        return encryptedContentElement;
    }

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.certFingerPrint = super.getRequiredAttribute(attributes, CERT_FINGERPRINT);
        this.certSerialNumber = super.getRequiredAttribute(attributes, CERT_SERIAL_NUMBER);
        this.category = super.getRequiredAttribute(attributes, CATEGORY);
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        if (!(this.category.equalsIgnoreCase("corbaPeer") || this.category.equalsIgnoreCase("aaServer") || this.category.equalsIgnoreCase("localAaDbFileSigner") || this.category.equalsIgnoreCase("ipsecPeer"))) {
            throw new SecurityActivationInputException("attribute category on cert invalid value - " + this.category);
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.encryptedContent == null) {
            throw new SecurityActivationInputException("CertFile element is not consistent - must contain an EncryptedContent element");
        }
        this.encryptedContent.checkConsistency();
    }

    public String getCertFingerPrint() {
        return this.certFingerPrint;
    }

    public String getCertSerialNumber() {
        return this.certSerialNumber;
    }

    public String getCategory() {
        return this.category;
    }

    public EncryptedContent getEncryptedContent() {
        return this.encryptedContent;
    }
}

