/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.EncryptedContent;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class EncryptedContentElement
extends StackElement
implements EncryptedContent {
    private static final String PBKDF2_SALT = "PBKDF2salt";
    private static final String PBKDF2_ITERATION_COUNT = "PBKDF2iterationCount";
    public static final String ENCRYPTEDCONTENT = "encryptedContent";
    private String PBKDF2_salt;
    private String PBKDF2_iterationCount;

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.PBKDF2_salt = super.getRequiredAttribute(attributes, PBKDF2_SALT);
        this.PBKDF2_iterationCount = super.getRequiredAttribute(attributes, PBKDF2_ITERATION_COUNT);
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        int n;
        try {
            n = Integer.parseInt(this.PBKDF2_iterationCount);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("attribute PBKDF2iterationCount in EncryptedContent is invalid - " + this.PBKDF2_iterationCount, throwable);
        }
        if (n < 1000) {
            throw new SecurityActivationInputException("attribute PBKDF2iterationCount in EncryptedContent is not >= 1000- " + this.PBKDF2_iterationCount);
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.value == null || this.value.equals("")) {
            throw new SecurityActivationInputException("EncryptedContent element is not consistent - must specify a value");
        }
    }

    public String getPBKDF2_salt() {
        return this.PBKDF2_salt;
    }

    public Integer getPBKDF2_iterationCount() {
        return Integer.valueOf(this.PBKDF2_iterationCount);
    }

    public String getContent() {
        return this.value;
    }
}

