/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.maofro.proxy.FroMaoHandler;
import se.ericsson.cello.maofro.proxy.FroMaoHandlerRegistry;
import se.ericsson.cello.maofro.proxy.KeyNotFoundException;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.support.debug.MessageLog;

public class FroMaoHandlerRegistryImpl
implements FroMaoHandlerRegistry {
    private Map handlers = new HashMap();

    public void register(FroMaoHandler froMaoHandler) {
        try {
            TagNameDictionary tagNameDictionary = froMaoHandler.getTagNameDictionary();
            int n = Integer.parseInt(tagNameDictionary.lookupValue("froType"), 16);
            this.handlers.put(new Integer(n), froMaoHandler);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            MessageLog.traceError(this.getClass(), (String)"Invalid tagname dictionary, froType is not defined!", (Throwable)((Object)keyNotFoundException));
        }
        catch (NumberFormatException numberFormatException) {
            MessageLog.traceError(this.getClass(), (String)"Invalid froType in tagname dictionary", (Throwable)numberFormatException);
        }
    }

    public FroMaoHandler lookup(int n) {
        return (FroMaoHandler)this.handlers.get(new Integer(n));
    }
}

