/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.KeyNotFoundException;
import se.ericsson.cello.maofro.proxy.MaoFroGenericAction;
import se.ericsson.cello.maofro.proxy.MaoFroGenericActionCfm;
import se.ericsson.cello.maofro.proxy.MaoFroGenericActionReq;
import se.ericsson.cello.maofro.proxy.MaoFroGenericCfm;
import se.ericsson.cello.maofro.proxy.MaoFroGenericCreateCfm;
import se.ericsson.cello.maofro.proxy.MaoFroGenericCreateReq;
import se.ericsson.cello.maofro.proxy.MaoFroGenericDeleteCfm;
import se.ericsson.cello.maofro.proxy.MaoFroGenericDeleteReq;
import se.ericsson.cello.maofro.proxy.MaoFroGenericGetAttrCfm;
import se.ericsson.cello.maofro.proxy.MaoFroGenericGetAttrReq;
import se.ericsson.cello.maofro.proxy.MaoFroGenericGetPmCfm;
import se.ericsson.cello.maofro.proxy.MaoFroGenericGetPmReq;
import se.ericsson.cello.maofro.proxy.MaoFroGenericReq;
import se.ericsson.cello.maofro.proxy.MaoFroGenericSetAttrReq;
import se.ericsson.cello.maofro.proxy.ParameterSizeCounter;
import se.ericsson.cello.maofro.proxy.SignalDestination;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.maofro.proxy.ValidationFailedException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.transaction.Coordinator;

public class MaoFroGenericProxy
implements FroProxy {
    public static final String SERVICE_NAME = "serviceName";
    public static final String PVFIRST_WANTED = "pvFirstWanted";
    public static final String PVSECOND_WANTED = "pvSecondWanted";
    public static final String PVTHIRD_WANTED = "pvThirdWanted";
    public static final String PVFOURTH_WANTED = "pvFourthWanted";
    public static final String FROTYPE = "froType";
    public static final String BIG_ATTRIBUTE_SUPPORT = "maoFroBigAttributeSupport";
    private static final int RESULT_OK = 0;
    private static final int VALIDATION_NOK = 4;
    public static final int PM_NOT_AVAILABLE = 100;
    private TagNameDictionary nameDictionary = null;
    private int froType = 0;
    private String moType = null;
    private String serviceName = null;
    private String pvFirstWanted = null;
    private String pvSecondWanted = null;
    private String pvThirdWanted = null;
    private String pvFourthWanted = null;
    private boolean supportsBigAttributes = false;
    private PVSession session = null;
    private static int requestId = 0;
    private static Object requestIdLock = new Object();
    private static final Class THIS_CLASS = MaoFroGenericProxy.class;
    public static final int MAX_ATTRIBUTE_BYTES = 65000;
    static /* synthetic */ Class class$se$ericsson$cello$maofro$proxy$MaoFroGenericSetAttrCfm;

    public FroData create(Coordinator coordinator, Collection arrayList) throws MoAccessException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericCreateReq"));
        this.addProtocolVersion(arrayList);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.getFroType();
        MaoFroGenericCreateReq maoFroGenericCreateReq = new MaoFroGenericCreateReq(coordinator, signalDestination, this.getDictionary(), arrayList);
        MaoFroGenericCreateCfm maoFroGenericCreateCfm = (MaoFroGenericCreateCfm)this.sendAndReceiveAttachedClean(pVSessionObject, maoFroGenericCreateReq, MaoFroGenericCreateCfm.class);
        FroData froData = new FroData(maoFroGenericCreateCfm.getFroId(), maoFroGenericCreateCfm.getParameters(this.getDictionary()));
        return froData;
    }

    public void delete(Coordinator coordinator, int n, Collection arrayList) throws MoAccessException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericDeleteReq"));
        this.addProtocolVersion(arrayList);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.getFroType();
        signalDestination.froId = n;
        MaoFroGenericDeleteReq maoFroGenericDeleteReq = new MaoFroGenericDeleteReq(coordinator, signalDestination, this.getDictionary(), arrayList);
        this.sendAndReceiveAttachedClean(pVSessionObject, maoFroGenericDeleteReq, MaoFroGenericDeleteCfm.class);
    }

    public Map getAttributes(Coordinator coordinator, int n) throws MoAccessException {
        ArrayList arrayList = new ArrayList();
        return this.handleGetAttributes(coordinator, n, arrayList);
    }

    public Map getAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        if (collection != null) {
            Object e = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e instanceof String) {
                    arrayList.add(new SignedIntParameter((String)e, 0));
                    continue;
                }
                if (!(e instanceof Parameter)) continue;
                arrayList.add((SignedIntParameter)e);
            }
        }
        return this.handleGetAttributes(coordinator, n, arrayList);
    }

    public Parameter getAttribute(Coordinator coordinator, int n, String string) throws MoAccessException {
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter(string, 0));
        Map map = this.handleGetAttributes(coordinator, n, arrayList);
        return (Parameter)map.get(string);
    }

    protected Map handleGetAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericGetAttrReq"));
        this.addProtocolVersion(collection);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.froId = n;
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.getFroType();
        MaoFroGenericGetAttrReq maoFroGenericGetAttrReq = new MaoFroGenericGetAttrReq(coordinator, signalDestination, this.getDictionary(), collection);
        return this.receiveParameters(pVSessionObject, maoFroGenericGetAttrReq, MaoFroGenericGetAttrCfm.class);
    }

    private Map receiveParameters(PVSession.PVSessionObject pVSessionObject, MaoFroGenericReq maoFroGenericReq, Class clazz) throws MoAccessException {
        if (this.supportsBigAttributes()) {
            maoFroGenericReq.getParameters().add(this.getNextRequestId());
        }
        boolean bl = true;
        Map map = null;
        Map map2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        this.dumpParams(maoFroGenericReq.getParameters(), stringBuffer);
        while (bl) {
            MessageLog.trace((int)5, this.getClass(), (String)("Sending " + ((Object)((Object)maoFroGenericReq)).getClass().getName() + " to " + maoFroGenericReq.destination.froType + ":" + maoFroGenericReq.destination.froId + " " + stringBuffer.toString()));
            MaoFroGenericCfm maoFroGenericCfm = this.sendAndReceiveAttachedClean(pVSessionObject, maoFroGenericReq, clazz);
            map2 = maoFroGenericCfm.getParameters(this.getDictionary());
            if (map == null) {
                map = map2;
            } else {
                MaoFroGenericProxy.mergeParameters(map, map2);
            }
            if (map.get("fragmentedSignalIndicator") == null) {
                bl = false;
                MessageLog.trace((int)5, this.getClass(), (String)"No fragmentation indicator found, this was the last signal.");
                continue;
            }
            map.remove("fragmentedSignalIndicator");
            MessageLog.trace((int)5, this.getClass(), (String)"Response contained fragmentation indicator, there's more to come.");
        }
        return map;
    }

    private void dumpParams(Collection collection, StringBuffer stringBuffer) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            stringBuffer.append(parameter.toString());
            stringBuffer.append("\n");
        }
    }

    public static void mergeParameters(Map map, Map map2) throws IllegalParameterValueException {
        Object k = null;
        Object var3_3 = null;
        Object v = null;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next().getKey();
            var3_3 = map.get(k);
            v = map2.get(k);
            if (var3_3 == null) {
                map.put(k, v);
                continue;
            }
            if (var3_3 instanceof ArrayParameter && v instanceof ArrayParameter) {
                MaoFroGenericProxy.mergeArrays(var3_3, (ArrayParameter)v);
                continue;
            }
            throw new RuntimeException("Conflict in parameter maps");
        }
    }

    private static void mergeArrays(ArrayParameter arrayParameter, ArrayParameter arrayParameter2) throws IllegalParameterValueException {
        Iterator iterator = arrayParameter2.iterator();
        while (iterator.hasNext()) {
            arrayParameter.add((Parameter)iterator.next());
        }
    }

    public void setAttributes(Coordinator coordinator, int n, Collection arrayList) throws MoAccessException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.handleSetAttributes(coordinator, n, arrayList);
    }

    public void setAttribute(Coordinator coordinator, int n, Parameter parameter) throws MoAccessException {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (parameter != null) {
            arrayList.add(parameter);
        }
        this.handleSetAttributes(coordinator, n, arrayList);
    }

    private void handleSetAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericSetAttrReq"));
        this.addProtocolVersion(collection);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.froId = n;
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.getFroType();
        Collection collection2 = MaoFroGenericProxy.splitParameters(collection);
        if (!this.supportsBigAttributes() && collection2.size() > 1) {
            throw new IllegalParameterValueException("Unable to send set request to " + this.serviceName + ":" + this.froType + ":" + n + ", the request was too big to fit in a single signal and split requests are not enabled for this interface");
        }
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            MaoFroGenericSetAttrReq maoFroGenericSetAttrReq = new MaoFroGenericSetAttrReq(coordinator, signalDestination, this.getDictionary(), (Collection)iterator.next());
            this.sendAndReceiveAttachedClean(pVSessionObject, maoFroGenericSetAttrReq, class$se$ericsson$cello$maofro$proxy$MaoFroGenericSetAttrCfm == null ? MaoFroGenericProxy.class$("se.ericsson.cello.maofro.proxy.MaoFroGenericSetAttrCfm") : class$se$ericsson$cello$maofro$proxy$MaoFroGenericSetAttrCfm);
        }
    }

    public static Collection splitParameters(Collection collection) throws IllegalParameterValueException {
        ArrayList<Collection> arrayList = new ArrayList<Collection>();
        ParameterSizeCounter parameterSizeCounter = new ParameterSizeCounter();
        if (MaoFroGenericProxy.isBigRequest(collection, parameterSizeCounter)) {
            ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
            Parameter parameter = null;
            int n = 65000;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                int n2 = MaoFroGenericProxy.getSizeInBytes(parameter, parameterSizeCounter);
                if (n2 > n) {
                    if (parameter instanceof ArrayParameter) {
                        ArrayParameter arrayParameter = (ArrayParameter)parameter;
                        ArrayParameter arrayParameter2 = new ArrayParameter(arrayParameter.getName());
                        n -= 24;
                        Parameter parameter2 = null;
                        for (int i = 0; i < arrayParameter.size(); ++i) {
                            parameter2 = arrayParameter.get(i);
                            int n3 = MaoFroGenericProxy.getSizeInBytes(parameter2, parameterSizeCounter);
                            if (n3 > n) {
                                if (n3 > 65000) {
                                    throw new IllegalParameterValueException(arrayParameter.getName() + "[" + i + "] is too big (" + n3 + " structs) to send over the signal interface!");
                                }
                                if (arrayParameter2.size() > 0) {
                                    arrayList2.add(arrayParameter2);
                                    arrayParameter2 = new ArrayParameter(arrayParameter.getName());
                                }
                                arrayList2.add(new UnsignedIntParameter("fragmentedSignalIndicator", 0L));
                                arrayList.add(arrayList2);
                                arrayList2 = new ArrayList();
                                n = 64976;
                            }
                            arrayParameter2.add(parameter2);
                            n -= n3;
                        }
                        if (arrayParameter2.size() <= 0) continue;
                        arrayList2.add(arrayParameter2);
                        continue;
                    }
                    if (n2 > 65000) {
                        throw new IllegalParameterValueException("The parameter " + parameter.getName() + " is too big (" + n2 + ") to send over the signal interface!");
                    }
                    arrayList2.add(new UnsignedIntParameter("fragmentedSignalIndicator", 0L));
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                    arrayList2.add(parameter);
                    n = 65000 - n2;
                    continue;
                }
                arrayList2.add(parameter);
                n -= n2;
            }
            if (!arrayList2.isEmpty()) {
                arrayList.add(arrayList2);
            }
        } else {
            arrayList.add(collection);
        }
        return arrayList;
    }

    private static boolean isBigRequest(Collection collection, ParameterSizeCounter parameterSizeCounter) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                ((Parameter)iterator.next()).accept(parameterSizeCounter);
            }
            catch (Exception exception) {
                MessageLog.traceError((Class)THIS_CLASS, (String)"Error checking parameters sizes", (Throwable)exception);
            }
            if (parameterSizeCounter.getByteCount() < 65000) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static int getSizeInBytes(Parameter parameter, ParameterSizeCounter parameterSizeCounter) {
        parameterSizeCounter.reset();
        try {
            parameter.accept(parameterSizeCounter);
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)THIS_CLASS, (String)("Unable to calculate the size of " + parameter), (Throwable)exception);
        }
        return parameterSizeCounter.getByteCount();
    }

    public PmData getPmAttributes(Coordinator coordinator, int n) throws MoAccessException {
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericGetPmReq"));
        ArrayList arrayList = new ArrayList();
        this.addProtocolVersion(arrayList);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.froId = n;
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.froType;
        MaoFroGenericGetPmReq maoFroGenericGetPmReq = new MaoFroGenericGetPmReq(coordinator, signalDestination, this.getDictionary(), arrayList);
        MaoFroGenericGetPmCfm maoFroGenericGetPmCfm = (MaoFroGenericGetPmCfm)this.sendAndReceiveAttachedClean(pVSessionObject, maoFroGenericGetPmReq, MaoFroGenericGetPmCfm.class);
        return new PmData(maoFroGenericGetPmCfm.getResult(), maoFroGenericGetPmCfm.getParameters(this.getDictionary()));
    }

    public Map actionWithCfm(Coordinator coordinator, int n, int n2, Collection arrayList) throws MoAccessException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericActionReq"));
        this.addProtocolVersion(arrayList);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.froId = n;
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.getFroType();
        MaoFroGenericActionReq maoFroGenericActionReq = new MaoFroGenericActionReq(coordinator, signalDestination, n2, this.getDictionary(), arrayList);
        return this.receiveParameters(pVSessionObject, maoFroGenericActionReq, MaoFroGenericActionCfm.class);
    }

    public void actionWithoutCfm(Coordinator coordinator, int n, int n2, Collection arrayList) throws MoAccessException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        MessageLog.trace((int)5, this.getClass(), (String)(this.moType + " MaoFroGenericAction"));
        this.addProtocolVersion(arrayList);
        PVSession.PVSessionObject pVSessionObject = this.obtainSession();
        SignalDestination signalDestination = new SignalDestination();
        signalDestination.froId = n;
        signalDestination.clientId = pVSessionObject.getClientId();
        signalDestination.froType = this.getFroType();
        MaoFroGenericAction maoFroGenericAction = new MaoFroGenericAction(coordinator, signalDestination, n2, this.getDictionary(), arrayList);
        SignalHelper.send((OseProcess)pVSessionObject.getFroProcess(), (Signal)maoFroGenericAction);
    }

    private String getErrorTxt(MaoFroGenericCfm maoFroGenericCfm) throws TagNameDictionaryException, IllegalParameterValueException {
        StringParameter stringParameter = (StringParameter)maoFroGenericCfm.getParameters(this.getDictionary()).get("errorText");
        if (stringParameter != null) {
            return stringParameter.getValue();
        }
        return "";
    }

    private MaoFroGenericCfm sendAndReceiveAttachedClean(PVSession.PVSessionObject pVSessionObject, MaoFroGenericReq maoFroGenericReq, Class clazz) throws MoAccessException {
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)pVSessionObject.getFroProcess(), (Signal)maoFroGenericReq, (Class)clazz, (int)SignalHelper.getTimeOut());
        return this.validateCfmSig(signal, maoFroGenericReq);
    }

    private MaoFroGenericCfm validateCfmSig(Signal signal, MaoFroGenericReq maoFroGenericReq) throws MoAccessException {
        MaoFroGenericCfm maoFroGenericCfm = null;
        if (signal == null) {
            throw new FroNotAccessibleException(this.moType, "Time-out occured, " + this.getServiceName());
        }
        if (signal instanceof AttachSignal) {
            throw new FroNotAccessibleException(this.moType, "Receiver process terminated, " + this.getServiceName());
        }
        if (!(signal instanceof MaoFroGenericCfm)) {
            throw new FroNotAccessibleException(this.moType, "Unknown response signal type: " + signal.getClass().getName() + ", " + this.getServiceName());
        }
        maoFroGenericCfm = (MaoFroGenericCfm)signal;
        if (maoFroGenericCfm.getResult() != 100 && maoFroGenericCfm.getResult() != 0) {
            if (maoFroGenericCfm.getResult() == 4) {
                throw new ValidationFailedException(this.getErrorTxt(maoFroGenericCfm));
            }
            if (maoFroGenericCfm.getResult() != 0) {
                throw new FroRequestFailedException(this.moType, this.getServiceName(), ((Object)((Object)maoFroGenericReq)).getClass().getName() + ", Error text: " + this.getErrorTxt(maoFroGenericCfm), maoFroGenericCfm.getResult());
            }
        }
        return maoFroGenericCfm;
    }

    private void addProtocolVersion(Collection collection) throws FroNotAccessibleException, IllegalParameterValueException {
        collection.add(new StringParameter("pvAttribute", this.obtainSession().getProtocolVersion()));
    }

    public TagNameDictionary getDictionary() {
        return this.nameDictionary;
    }

    public MaoFroGenericProxy(TagNameDictionary tagNameDictionary, String string) throws TagNameDictionaryException {
        this.nameDictionary = tagNameDictionary;
        this.moType = string;
        this.froType = Integer.parseInt(tagNameDictionary.lookupValue(FROTYPE), 16);
        this.serviceName = tagNameDictionary.lookupValue(SERVICE_NAME);
        this.pvFirstWanted = tagNameDictionary.lookupValue(PVFIRST_WANTED);
        this.pvSecondWanted = tagNameDictionary.lookupValue(PVSECOND_WANTED);
        this.pvThirdWanted = tagNameDictionary.lookupValue(PVTHIRD_WANTED);
        try {
            this.pvFourthWanted = tagNameDictionary.lookupValue(PVFOURTH_WANTED);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            this.pvFourthWanted = "";
        }
        try {
            String string2 = tagNameDictionary.lookupValue(BIG_ATTRIBUTE_SUPPORT);
            this.supportsBigAttributes = this.isAffirmative(string2);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            this.supportsBigAttributes = false;
        }
    }

    private boolean isAffirmative(String string) {
        return string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("Y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equals("1"));
    }

    public void subscribeService() {
        this.session = new PVSession(this.getServiceName(), new String[]{this.pvFirstWanted, this.pvSecondWanted, this.pvThirdWanted, this.pvFourthWanted}, this.moType, this.getFroType());
    }

    public PVSession.PVSessionObject obtainSession() throws FroNotAccessibleException {
        return this.session.obtainSession();
    }

    private int getFroType() {
        return this.froType;
    }

    private String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Parameter getNextRequestId() {
        int n = 0;
        UnsignedIntParameter unsignedIntParameter = null;
        Object object = requestIdLock;
        synchronized (object) {
            if (++requestId < 0) {
                requestId = 1;
            }
            n = requestId;
        }
        try {
            unsignedIntParameter = new UnsignedIntParameter("maoFroRequestId", (long)n);
        }
        catch (IllegalParameterValueException illegalParameterValueException) {
            MessageLog.traceError(this.getClass(), (String)("Invalid request id: " + n), (Throwable)((Object)illegalParameterValueException));
        }
        return unsignedIntParameter;
    }

    public boolean supportsBigAttributes() {
        return this.supportsBigAttributes;
    }

    public PVSession getPVSession() {
        return this.session;
    }
}

