/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import java.util.Collection;
import se.ericsson.cello.maofro.proxy.MaoFroGenericSignal;
import se.ericsson.cello.maofro.proxy.ParameterSender;
import se.ericsson.cello.maofro.proxy.SignalDestination;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class MaoFroGenericReq
extends MaoFroGenericSignal {
    protected int transactionId;
    protected SignalDestination destination;
    protected ParameterSender sender;

    public MaoFroGenericReq(int n, Coordinator coordinator, SignalDestination signalDestination, TagNameDictionary tagNameDictionary, Collection collection) {
        super(n);
        this.transactionId = coordinator != null ? coordinator.getTransactionID() : 0;
        this.sender = new ParameterSender(collection, tagNameDictionary);
        this.destination = signalDestination;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void initReceive() {
    }

    public void initSend() {
        SignalOutputStream signalOutputStream = this.getSignalOutputStream();
        try {
            this.writeHeader(signalOutputStream);
            this.writeParameters(signalOutputStream);
            signalOutputStream.flush();
        }
        catch (Throwable throwable) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"Unable to write signal to stream", (Throwable)throwable);
        }
    }

    public void writeHeader(SignalOutputStream signalOutputStream) throws IOException {
        signalOutputStream.writeU32((long)this.getTransactionId());
        signalOutputStream.writeU32((long)this.getDestination().froId);
        signalOutputStream.writeU32((long)this.getDestination().clientId);
        signalOutputStream.writeU32((long)this.getDestination().froType);
        MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing transactionId: " + this.getTransactionId()));
        MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing clientId: " + this.getDestination().clientId));
        MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing froType: " + this.getDestination().froType));
        MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing froId: " + this.getDestination().froId));
    }

    public void writeParameters(SignalOutputStream signalOutputStream) throws Exception {
        this.sender.writeParameters(signalOutputStream);
    }

    public SignalDestination getDestination() {
        return this.destination;
    }

    public TagNameDictionary getDictionary() {
        return this.sender.getDictionary();
    }

    public Collection getParameters() {
        return this.sender.getParameters();
    }
}

