/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.LdnUtilities;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataSource;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.RealMoDataWrapper;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class RealMoDataSource
implements MoDataSource,
MoDataAccessor {
    private Vector data = null;
    private Hashtable cache = new Hashtable();

    public void init(Vector vector) {
        this.data = vector;
    }

    public MoDataAccessor getMoDataAccessor() {
        return this;
    }

    public Vector getOriginalData() {
        return this.data;
    }

    public Collection find(MoDataFilter moDataFilter) throws AueException {
        Vector<RealMoDataWrapper> vector = new Vector<RealMoDataWrapper>();
        RealMoDataWrapper realMoDataWrapper = new RealMoDataWrapper();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            MoData moData = (MoData)iterator.next();
            realMoDataWrapper.setMoData(moData);
            if (!moDataFilter.accept(realMoDataWrapper)) continue;
            vector.add(new RealMoDataWrapper(moData));
        }
        return vector;
    }

    public MoDataWrapper findFirst(MoDataFilter moDataFilter) throws AueException {
        RealMoDataWrapper realMoDataWrapper = new RealMoDataWrapper();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            realMoDataWrapper.setMoData((MoData)iterator.next());
            if (!moDataFilter.accept(realMoDataWrapper)) continue;
            return realMoDataWrapper;
        }
        return null;
    }

    public Collection getByType(String string) {
        return new Vector(this.getMoDataReference(string));
    }

    public Collection getByRevision(String string, int n) {
        Vector<MoDataWrapper> vector = new Vector<MoDataWrapper>();
        Iterator iterator = this.getMoDataReference(string).iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
            if (moDataWrapper.getRevision() != n) continue;
            vector.add(moDataWrapper);
        }
        return vector;
    }

    private Collection getMoDataReference(String string) {
        Vector<RealMoDataWrapper> vector = (Vector<RealMoDataWrapper>)this.cache.get(string);
        if (vector == null) {
            vector = new Vector<RealMoDataWrapper>();
            this.cache.put(string, vector);
            MoData moData = null;
            Iterator iterator = this.data.iterator();
            while (iterator.hasNext()) {
                moData = (MoData)iterator.next();
                if (!moData.getMoTypeName().equals(string)) continue;
                vector.add(new RealMoDataWrapper(moData));
            }
        }
        return vector;
    }

    public void delete(MoDataWrapper moDataWrapper, Coordinator coordinator) throws AueException {
        this.deleteMoDataHelper(moDataWrapper.getMoTypeName(), moDataWrapper.getLocalDistinguishedName());
        moDataWrapper.delete(coordinator);
    }

    public MoDataWrapper create(String string, Coordinator coordinator) throws AueException {
        MoData moData;
        String string2 = LdnUtilities.getTypeFromLdn(string);
        try {
            moData = new MoData(string, string2, true, coordinator);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            throw new AueException("Unable to instantiate MoData '" + string + "'", transactionRequiredException);
        }
        RealMoDataWrapper realMoDataWrapper = new RealMoDataWrapper(moData);
        this.getMoDataReference(string2).add(realMoDataWrapper);
        this.data.add(moData);
        return realMoDataWrapper;
    }

    private void deleteMoDataHelper(String string, String string2) {
        Collection collection = this.getMoDataReference(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
            if (!moDataWrapper.getLocalDistinguishedName().equals(string2)) continue;
            iterator.remove();
            this.deleteOriginalMoData(string2);
            return;
        }
        MessageLog.traceError(this.getClass(), (String)("Couldn't delete MO data '" + string2 + "' - Not found in cache."));
    }

    private void deleteOriginalMoData(String string) {
        MoData moData = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (!moData.getLocalDistinguishedName().equals(string)) continue;
            iterator.remove();
            return;
        }
        MessageLog.traceError(this.getClass(), (String)("Couldn't delete MO data '" + string + "' - Not found in data vector."));
    }
}

