/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter.actions;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.actions.AttributeHelper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.transaction.Coordinator;

public class RenameAttributeAction
implements MoDataAction {
    private String oldAttrName = null;
    private String newAttrName = null;

    public RenameAttributeAction(String string, String string2) {
        this.oldAttrName = string;
        this.newAttrName = string2;
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        Attribute attribute = moDataWrapper.getAttribute(this.oldAttrName);
        Attribute attribute2 = moDataWrapper.getAttribute(this.newAttrName);
        if (attribute == null) {
            if (attribute2 == null) {
                throw new AueException("Neither the attribute " + this.oldAttrName + " nor " + this.newAttrName + " exists in " + moDataWrapper.getMoTypeName());
            }
            return;
        }
        if (attribute2 != null) {
            throw new AueException("Both attributes " + this.oldAttrName + " and " + this.newAttrName + " already exist.");
        }
        attribute2 = AttributeHelper.renameAttribute(attribute, this.newAttrName);
        moDataWrapper.deregisterAttribute(attribute);
        moDataWrapper.registerPersistentAttr(attribute2);
    }
}

