/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.persistence;

import com.polyhedra.sql.DriverManager;
import com.polyhedra.sql.SQLException;
import java.util.Properties;
import se.ericsson.cello.persistence.Convert;
import se.ericsson.cello.persistence.JdbcConnectException;
import se.ericsson.cello.persistence.JdbcDriverNotFoundException;
import se.ericsson.cello.persistence.JdbcHelper;
import se.ericsson.cello.support.debug.Assert;

public class JdbcPolyhedraHelper
implements JdbcHelper {
    private String host = "127.0.0.1";
    private String port = "5434";
    private String driver = "polyhedra";
    private String database = "";

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("user", "");
        properties.setProperty("password", "");
        return properties;
    }

    public String getUrl() {
        return "jdbc:" + this.driver + "://" + this.host + ":" + this.port + "/" + this.database;
    }

    public Object connect() throws JdbcConnectException {
        return this.connect(this.getUrl(), this.getProperties());
    }

    public Object connect(String string, Properties properties) throws JdbcConnectException {
        try {
            return DriverManager.getConnection((String)string, (Properties)properties);
        }
        catch (SQLException sQLException) {
            throw new JdbcConnectException(sQLException.toString());
        }
    }

    public String getBinary(byte[] byArray) {
        return "X'" + Convert.byteArrayToHexString(byArray) + "'";
    }

    public String getStringType() {
        return "CHAR";
    }

    public String getStringType(int n) {
        return "VARCHAR(" + n + ")";
    }

    public String getFloatType() {
        return "FLOAT32";
    }

    public String getDoubleType() {
        return "FLOAT";
    }

    public String getByteType() {
        return "INTEGER8";
    }

    public String getShortType() {
        return "INTEGER16";
    }

    public String getIntType() {
        return "INTEGER";
    }

    public String getBinaryType() {
        return "BINARY";
    }

    public String getBooleanType() {
        return "BOOL";
    }

    public String getDateType() {
        return "DATETIME";
    }

    private void handleFatalError(String string) {
        Assert.cppAssert(string);
    }

    JdbcPolyhedraHelper() throws JdbcDriverNotFoundException {
        try {
            Class.forName("com.polyhedra.jdbc.JdbcDriver").newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JdbcDriverNotFoundException(instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JdbcDriverNotFoundException(classNotFoundException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JdbcDriverNotFoundException(illegalAccessException.toString());
        }
    }
}

