/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug;

import se.ericsson.cello.support.control.Control;
import se.ericsson.cello.support.debug.GcStats;
import se.ericsson.cello.support.debug.GenerationalGcStats;
import se.ericsson.cello.support.debug.MemoryArea;

public class JavaHeap
implements MemoryArea {
    private long used;
    private long maxUsed;
    private static long size = Runtime.getRuntime().totalMemory();

    public JavaHeap() {
        this.measure();
    }

    public void measure() {
        Runtime.getRuntime().gc();
        if (Control.getOs() == 1) {
            this.used = this._getUsed();
            this.maxUsed = this._getMaxUsed();
        } else {
            this.used = size - this.getFree();
            this.maxUsed = size - this.getMinFree();
        }
    }

    public long getSize() {
        return size;
    }

    public long getUsed() {
        return this.used;
    }

    public long getMaxUsed() {
        return this.maxUsed;
    }

    public GcStats getGcStats() {
        return new GenerationalGcStats();
    }

    public void resetMaxUsed() {
        this._resetMaxUsed();
    }

    private native long getFree();

    private native long getMinFree();

    private native long _getUsed();

    private native long _getMaxUsed();

    private native long _resetMaxUsed();
}

