/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import se.ericsson.cello.support.debug.trace.PackageEntry;
import se.ericsson.cello.support.debug.trace.PackageFilter;
import se.ericsson.cello.support.debug.trace.VariableFilter;

class PlainPackageFilter
extends PackageFilter {
    PackageEntry infoEntry;
    PackageEntry errorEntry;
    PackageEntry enterEntry;
    PackageEntry returnEntry;
    PackageEntry stateEntry;
    PackageEntry paramEntry;
    PackageEntry sendSigEntry;
    PackageEntry recSigEntry;
    PackageEntry[] groupEntry = new PackageEntry[10];

    public PlainPackageFilter() {
        this.initFilters();
    }

    private void initFilters() {
        this.infoEntry = new PackageEntry("", false);
        this.errorEntry = new PackageEntry("", false);
        this.enterEntry = new PackageEntry("", true);
        this.returnEntry = new PackageEntry("", true);
        this.stateEntry = new PackageEntry("", true);
        this.paramEntry = new PackageEntry("", true);
        this.recSigEntry = new PackageEntry("", true);
        this.sendSigEntry = new PackageEntry("", true);
        for (int i = 0; i < this.groupEntry.length; ++i) {
            this.groupEntry[i] = new PackageEntry("", true);
        }
    }

    public boolean filterInfo(String string) {
        return this.infoEntry.isFilterOn(string);
    }

    public boolean filterError(String string) {
        return this.errorEntry.isFilterOn(string);
    }

    public boolean filterEnter(String string) {
        return this.enterEntry.isFilterOn(string);
    }

    public boolean filterReturn(String string) {
        return this.returnEntry.isFilterOn(string);
    }

    public boolean filterState(String string) {
        return this.stateEntry.isFilterOn(string);
    }

    public boolean filterParam(String string) {
        return this.paramEntry.isFilterOn(string);
    }

    public boolean filterSendSig(String string) {
        return this.sendSigEntry.isFilterOn(string);
    }

    public boolean filterRecSig(String string) {
        return this.recSigEntry.isFilterOn(string);
    }

    public boolean filterGroup(int n, String string) {
        return this.groupEntry[n].isFilterOn(string);
    }

    public VariableFilter getAlwaysFilter() {
        return new VariableFilter(this);
    }

    private PackageEntry internalModifyFilter(String string, long l, int n, PackageEntry packageEntry) {
        switch (n) {
            case -1: {
                PackageEntry packageEntry2;
                boolean bl;
                boolean bl2;
                if (packageEntry == this.errorEntry || packageEntry == this.infoEntry) {
                    bl2 = l == 0L;
                    bl = true;
                } else {
                    bl2 = l != 0L;
                    bl = false;
                }
                if (bl2) {
                    packageEntry2 = new PackageEntry(string, bl);
                    packageEntry2.next = packageEntry.removeEqualEntry(string);
                } else {
                    packageEntry2 = packageEntry.removeEqualEntry(string);
                }
                return packageEntry2;
            }
            case 0: {
                return this.internModifyFilter(string, l == 0L, packageEntry);
            }
            case 1: {
                if (l == 0L) break;
                return this.internModifyFilter(string, false, packageEntry);
            }
            case 2: {
                if (l == 0L) break;
                return this.internModifyFilter(string, true, packageEntry);
            }
            default: {
                throw new IllegalArgumentException("Invalid operation " + n);
            }
        }
        return packageEntry;
    }

    private PackageEntry internModifyFilter(String string, boolean bl, PackageEntry packageEntry) {
        PackageEntry packageEntry2 = new PackageEntry(string, bl, packageEntry);
        if (packageEntry2.next != null && packageEntry2.next.isRedundantEntry(packageEntry2)) {
            return packageEntry2.next;
        }
        return packageEntry2;
    }

    public void modifyFilter(String string, long l, int n) {
        this.errorEntry = this.internalModifyFilter(string, l & 2L, n, this.errorEntry);
        this.enterEntry = this.internalModifyFilter(string, l & 4L, n, this.enterEntry);
        this.returnEntry = this.internalModifyFilter(string, l & 8L, n, this.returnEntry);
        this.infoEntry = this.internalModifyFilter(string, l & 0x10L, n, this.infoEntry);
        this.groupEntry[1] = this.internalModifyFilter(string, l & 0x20L, n, this.groupEntry[1]);
        this.groupEntry[2] = this.internalModifyFilter(string, l & 0x40L, n, this.groupEntry[2]);
        this.groupEntry[3] = this.internalModifyFilter(string, l & 0x80L, n, this.groupEntry[3]);
        this.groupEntry[4] = this.internalModifyFilter(string, l & 0x100L, n, this.groupEntry[4]);
        this.groupEntry[5] = this.internalModifyFilter(string, l & 0x200L, n, this.groupEntry[5]);
        this.groupEntry[6] = this.internalModifyFilter(string, l & 0x400L, n, this.groupEntry[6]);
        this.groupEntry[7] = this.internalModifyFilter(string, l & 0x800L, n, this.groupEntry[7]);
        this.groupEntry[8] = this.internalModifyFilter(string, l & 0x1000L, n, this.groupEntry[8]);
        this.groupEntry[9] = this.internalModifyFilter(string, l & 0x2000L, n, this.groupEntry[9]);
        this.stateEntry = this.internalModifyFilter(string, l & 0x4000L, n, this.stateEntry);
        this.sendSigEntry = this.internalModifyFilter(string, l & 0x40000L, n, this.sendSigEntry);
        this.recSigEntry = this.internalModifyFilter(string, l & 0x20000L, n, this.recSigEntry);
        this.paramEntry = this.internalModifyFilter(string, l & 0x80000L, n, this.paramEntry);
    }

    public long getFilterMask(String string) {
        long l = 0L;
        if (!this.errorEntry.isFilterOn(string)) {
            l |= 2L;
        }
        if (!this.enterEntry.isFilterOn(string)) {
            l |= 4L;
        }
        if (!this.returnEntry.isFilterOn(string)) {
            l |= 8L;
        }
        if (!this.infoEntry.isFilterOn(string)) {
            l |= 0x10L;
        }
        if (!this.groupEntry[1].isFilterOn(string)) {
            l |= 0x20L;
        }
        if (!this.groupEntry[2].isFilterOn(string)) {
            l |= 0x40L;
        }
        if (!this.groupEntry[3].isFilterOn(string)) {
            l |= 0x80L;
        }
        if (!this.groupEntry[4].isFilterOn(string)) {
            l |= 0x100L;
        }
        if (!this.groupEntry[5].isFilterOn(string)) {
            l |= 0x200L;
        }
        if (!this.groupEntry[6].isFilterOn(string)) {
            l |= 0x400L;
        }
        if (!this.groupEntry[7].isFilterOn(string)) {
            l |= 0x800L;
        }
        if (!this.groupEntry[8].isFilterOn(string)) {
            l |= 0x1000L;
        }
        if (!this.groupEntry[9].isFilterOn(string)) {
            l |= 0x2000L;
        }
        if (!this.stateEntry.isFilterOn(string)) {
            l |= 0x4000L;
        }
        if (!this.sendSigEntry.isFilterOn(string)) {
            l |= 0x40000L;
        }
        if (!this.recSigEntry.isFilterOn(string)) {
            l |= 0x20000L;
        }
        if (!this.paramEntry.isFilterOn(string)) {
            l |= 0x80000L;
        }
        return l;
    }

    public void setDefaultFilter(String string) {
        this.initFilters();
    }

    public String toString() {
        String string = "";
        string = string + " info:     [" + this.infoEntry.toString() + "]\n";
        string = string + " error:    [" + this.errorEntry.toString() + "]\n";
        string = string + " enter:    [" + this.enterEntry.toString() + "]\n";
        string = string + " return:   [" + this.returnEntry.toString() + "]\n";
        string = string + " state:    [" + this.stateEntry.toString() + "]\n";
        string = string + " param:    [" + this.paramEntry.toString() + "]\n";
        string = string + " send_sig: [" + this.sendSigEntry.toString() + "]\n";
        string = string + " rec_sig:  [" + this.recSigEntry.toString() + "]\n";
        for (int i = 0; i < this.groupEntry.length; ++i) {
            string = string + " group" + i + ":   [" + this.groupEntry[i].toString() + "]\n";
        }
        return string;
    }
}

