/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.thread;

import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.AWTEventMulticaster;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.util.Timer;

public class Alarm {
    private int delay;
    private Clock clock = null;
    private Notifier notifier;
    private boolean isStopped = false;
    private boolean isExpired = false;
    private boolean isRestarted = false;
    private static final long TIMER_MAX_VALUE = 0xFFFFFFFFL;
    private static int counter = 0;
    private static final int ALARMCLOCK_THREAD_CREATED = 1;
    private static final int ALARMCLOCK_THREAD_AWAKEN = 2;
    public static final Mode CONTINUOUS = new Mode();
    public static final Mode ONE_SHOT = new Mode();
    public static final Mode MULTI_SHOT = new Mode();
    private Mode type;
    private Timer timer = new Timer();
    private ActionListener observers = null;
    public static final String STOPPED = "stopped";
    public static final String EXPIRED = "expired";
    public static final long FOREVER = Long.MAX_VALUE;

    public Alarm(int n, Mode mode) {
        this.delay = n;
        this.type = mode == null ? CONTINUOUS : mode;
    }

    public Alarm(int n) {
        this(n, CONTINUOUS);
    }

    public synchronized void start() {
        MessageLog.trace(9, this.getClass(), "Alarm.start enter (delay = " + this.delay + ")");
        this.timer.start();
        if (this.clock != null) {
            if (this.type == MULTI_SHOT && this.isExpired) {
                this.isExpired = false;
                this.clock.restart();
                return;
            }
            this.isRestarted = true;
            this.clock.interrupt();
        }
        if (this.notifier == null) {
            this.notifier = new Notifier();
            this.notifier.setDaemon(true);
            this.notifier.start();
        }
        this.clock = new Clock();
        this.clock.start();
        this.isRestarted = false;
        this.isStopped = false;
        this.isExpired = false;
        MessageLog.trace(9, this.getClass(), "Alarm.start return");
    }

    public synchronized void stop() {
        this.isStopped = true;
        if (this.clock != null) {
            this.clock.terminate();
            this.clock = null;
        }
        if (this.notifier != null) {
            this.notifier.terminate();
            this.notifier = null;
        }
        this.notifyAll();
    }

    public void finalize() {
        if (this.clock != null) {
            throw new Error("Alarm was not stopped before being destroyed");
        }
    }

    public synchronized boolean await(long l) {
        if (this.type == CONTINUOUS || !this.isExpired && !this.isStopped) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !this.isStopped;
    }

    public boolean await() {
        return this.await(Long.MAX_VALUE);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.observers = AWTEventMulticaster.add(this.observers, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.observers = AWTEventMulticaster.remove(this.observers, actionListener);
    }

    static {
        try {
            Class.forName("se.ericsson.cello.support.thread.ActionEvent");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final class Clock
    extends Thread {
        private boolean isStarted;
        private boolean isAbnormalInterruption;

        Clock() {
            super("Osa_AlarmClock_thread");
            this.isStarted = false;
            this.isAbnormalInterruption = false;
            this.setPriority(this.getThreadGroup().getMaxPriority());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            Clock clock = this;
            synchronized (clock) {
                this.isStarted = true;
                this.notify();
            }
            l2 = Alarm.this.timer.stop();
            while (!this.isInterrupted()) {
                try {
                    if (Alarm.this.type == CONTINUOUS) {
                        l = Alarm.this.timer.start();
                    }
                    if (counter == 0) {
                        MessageLog.info(this.getClass(), "Clock.sleep(" + Alarm.this.delay + " - " + l2 + ")");
                        counter = 1;
                    } else {
                        MessageLog.trace(9, this.getClass(), "Clock.sleep(" + Alarm.this.delay + " - " + l2 + ")");
                    }
                    if (Alarm.this.type == ONE_SHOT) {
                        Alarm.this.timer.start();
                    }
                    if (this.isAbnormalInterruption) {
                        Clock.sleep(l3);
                    } else {
                        Clock.sleep((long)Alarm.this.delay - l2);
                    }
                    if (counter == 1) {
                        MessageLog.info(this.getClass(), "Clock.sleep done");
                        counter = 2;
                    } else {
                        MessageLog.trace(9, this.getClass(), "Clock.sleep done");
                    }
                    Object object = Alarm.this;
                    synchronized (object) {
                        if (!this.isInterrupted()) {
                            Alarm.this.isExpired = true;
                            Alarm.this.notifyAll();
                        }
                    }
                    if (Alarm.this.type == MULTI_SHOT) {
                        object = this;
                        synchronized (object) {
                            this.wait();
                        }
                        l2 = Alarm.this.timer.stop();
                        continue;
                    }
                    if (Alarm.this.type == ONE_SHOT) {
                        object = Alarm.this;
                        synchronized (object) {
                            if (Alarm.this.clock == this) {
                                Alarm.this.clock = null;
                            }
                            break;
                        }
                    }
                    if (Alarm.this.type != CONTINUOUS) continue;
                    long l5 = Alarm.this.timer.start();
                    if (l5 < l) {
                        long l6 = 0xFFFFFFFFL - l + l5 + 1L;
                        l2 = l6 - ((long)Alarm.this.delay - l2);
                    } else {
                        l2 = l5 - l - ((long)Alarm.this.delay - l2);
                    }
                    if (l2 <= (long)Alarm.this.delay) continue;
                    l2 %= (long)Alarm.this.delay;
                }
                catch (InterruptedException interruptedException) {
                    if (Alarm.this.isStopped || Alarm.this.isExpired || Alarm.this.isRestarted) break;
                    if (Alarm.this.type == ONE_SHOT) {
                        this.isAbnormalInterruption = true;
                        long l7 = Alarm.this.timer.stop();
                        MessageLog.info(this.getClass(), "Abnormal interruped exception occured after delay(ms):" + l7);
                        l4 = l7 + l4;
                        l3 = (long)Alarm.this.delay - l4;
                        continue;
                    }
                    MessageLog.info(this.getClass(), "Abnormal interruped exception occured");
                    break;
                }
            }
        }

        public synchronized void terminate() {
            if (!this.isStarted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }

        public synchronized void restart() {
            this.notify();
        }
    }

    private final class Notifier
    extends Thread {
        private boolean isStarted;

        public Notifier() {
            super("Osa_AlarmNotifier_thread");
            this.isStarted = false;
            this.setPriority(this.getThreadGroup().getMaxPriority());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            Object object = this;
            synchronized (object) {
                this.isStarted = true;
                this.notify();
            }
            while (!bl) {
                object = Alarm.this;
                synchronized (object) {
                    try {
                        Alarm.this.wait();
                        if (Alarm.this.type == ONE_SHOT && Alarm.this.notifier == this) {
                            Alarm.this.notifier = null;
                        }
                        if (Alarm.this.isStopped) {
                            bl = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                object = Alarm.this.observers;
                if (object != null) {
                    String string = bl ? Alarm.STOPPED : Alarm.EXPIRED;
                    object.actionPerformed(new ActionEvent(this, 0, string));
                }
                if (Alarm.this.type != ONE_SHOT) continue;
                break;
            }
        }

        public synchronized void terminate() {
            if (!this.isStarted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }
    }

    public static class Mode {
        private Mode() {
        }
    }
}

