/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Observable;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.ExportUtil;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCache;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MomDecrypter;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class ExportManager
extends Observable {
    public static final String VALUE_PROGRESS_STRING = "Exporting Managed Objects to XML-file  ";
    public static final String INDENT_INCREMENT = "  ";
    private static final String DECRYPT_ERROR_TEXT = "Export manager error";
    private static ExportManager theInstance = null;
    private static int currentProgress = 5;
    private static int tempProgress = 0;
    private static final int PROGRESS_INDICATOR = 1;
    private String xmlPath;
    private String dtdPath;
    private MomDecrypter momDecrypter;
    private AbstractApplicationController abstractController = null;
    private int progressStep = 0;
    private ExportUtil exportUtil;

    public static synchronized ExportManager getTheInstance() {
        if (theInstance == null) {
            theInstance = new ExportManager();
        }
        return theInstance;
    }

    public static void initiate() {
        theInstance = null;
    }

    public int getNoOfReportsForDecryptAndParseOfCompleteMom() throws Exception {
        this.momDecrypter = new MomDecrypter(this);
        int n = this.momDecrypter.getTotalNumberOfProgressReports();
        return n;
    }

    public MimModel getMimModel() {
        if (this.exportUtil == null) {
            return null;
        }
        return this.exportUtil.getMimModel();
    }

    public void exportMOProxyToXML(MoHandlerCache moHandlerCache, OutputStream outputStream, String string) throws MoHandlerException, IOException, Exception {
        try {
            this.decryptCompleteMom();
            this.exportUtil = new ExportUtil(moHandlerCache, outputStream, string, this.xmlPath, this);
            this.exportUtil.exportMOProxyToXML();
            this.removeDecryptionFiles();
        }
        catch (Exception exception) {
            this.removeDecryptionFiles();
            throw exception;
        }
    }

    protected void updateProgress() {
        this.setChanged();
        if (this.abstractController != null) {
            if (tempProgress >= this.progressStep) {
                this.updateProgress(currentProgress);
                ++currentProgress;
                tempProgress = 0;
            }
            ++tempProgress;
        } else {
            this.notifyObservers(Nal.getFactory().getNameValue(VALUE_PROGRESS_STRING, 1));
        }
    }

    protected void updateProgress(int n) {
        this.setChanged();
        this.notifyObservers(Nal.getFactory().getNameValue(VALUE_PROGRESS_STRING, n));
    }

    private void decryptCompleteMom() throws Exception {
        this.momDecrypter = new MomDecrypter(this);
        this.momDecrypter.decryptCompleteMom();
        this.xmlPath = this.momDecrypter.getXmlPath();
        this.dtdPath = this.momDecrypter.getDtdPath();
        File file = new File(this.xmlPath);
        if (!file.exists()) {
            throw new Exception(DECRYPT_ERROR_TEXT);
        }
        file = new File(this.dtdPath);
        if (!file.exists()) {
            throw new Exception(DECRYPT_ERROR_TEXT);
        }
    }

    private void removeDecryptionFiles() {
        this.momDecrypter.removeTempFiles();
    }

    protected void checkIfCancelled() throws InterruptedException {
        if (this.abstractController == null) {
            return;
        }
        if (this.abstractController.isCancelled()) {
            throw new InterruptedException("Export was canceled.");
        }
    }

    public void setAbstractController(AbstractApplicationController abstractApplicationController) {
        this.abstractController = abstractApplicationController;
    }

    public String xmlEncodeTextForAttribute(String string) {
        String string2 = ExportUtil.xmlEncodeTextForAttribute(string);
        return string2;
    }
}

