/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.Board;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.BoardData;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.BoardListener;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.BoardModeller;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.HwTestProgressReportListener;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.trace.BEMTrace;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class BoardModel
implements BoardModeller {
    private Vector myBoards;
    private ResourceBundle myLanguageBundle;
    private Vector<BoardListener> myBoardListeners = new Vector();
    private List<HwTestProgressReportListener> progressReportListeners = new ArrayList<HwTestProgressReportListener>();
    private Vector myDevGrpSubscriptions = new Vector();
    private Vector mySlotSubscriptions = new Vector();
    private MoHandlerImpl moHandler;
    private NalCmSubscription avcSubscription;

    public BoardModel() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardModel.class, "BoardModel()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardModel.class, "BoardModel()");
        }
    }

    public void close() {
        for (NalCmSubscription nalCmSubscription : this.mySlotSubscriptions) {
            nalCmSubscription.cancel();
        }
        this.mySlotSubscriptions.clear();
        for (NalCmSubscription nalCmSubscription : this.myDevGrpSubscriptions) {
            nalCmSubscription.cancel();
        }
        this.myDevGrpSubscriptions.clear();
        if (this.avcSubscription != null) {
            this.avcSubscription.cancel();
        }
    }

    private void subscribeAvc(BemMo bemMo) {
        this.avcSubscription = bemMo.subscribe(5, new AvcListener());
    }

    public void addBoardListener(BoardListener boardListener) {
        this.myBoardListeners.add(boardListener);
        if (this.myBoards == null) {
            this.collectBoards();
        }
    }

    public void removeBoardListener(BoardListener boardListener) {
        this.myBoardListeners.remove(boardListener);
    }

    public void addProgressReportListener(HwTestProgressReportListener hwTestProgressReportListener) {
        this.progressReportListeners.add(hwTestProgressReportListener);
    }

    public void removeProgressReportListener(HwTestProgressReportListener hwTestProgressReportListener) {
        this.progressReportListeners.remove(hwTestProgressReportListener);
    }

    public void setLanguageBundle(ResourceBundle resourceBundle) {
        this.myLanguageBundle = resourceBundle;
    }

    public Board[] getBoards() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardModel.class, "getBoards()");
        }
        if (this.myBoards == null) {
            this.collectBoards();
        }
        Board[] boardArray = new Board[this.myBoards.size()];
        this.myBoards.toArray(boardArray);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardModel.class, "getBoards()", boardArray);
        }
        return boardArray;
    }

    public void test(Board[] boardArray) {
        HwTestThread hwTestThread = new HwTestThread(boardArray);
        hwTestThread.start();
    }

    public void lock(Board[] boardArray) {
        LockThread lockThread = new LockThread(boardArray);
        lockThread.start();
    }

    public void unlock(Board[] boardArray) {
        UnlockThread unlockThread = new UnlockThread(boardArray);
        unlockThread.start();
    }

    private synchronized void collectBoards() {
        CollectBoardsThread collectBoardsThread = new CollectBoardsThread();
        collectBoardsThread.start();
    }

    protected String convertHubType(Integer n) {
        String string = "";
        String string2 = "se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit_HubPosition";
        try {
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Integer n2 = (Integer)fieldArray[i].get(obj);
                if (!n2.equals(n)) continue;
                String string3 = fieldArray[i].getName();
                string = string3.substring(8);
                break;
            }
        }
        catch (Exception exception) {
            BemLog.logError("Exception when converting hub type to string", exception);
        }
        return string;
    }

    private void adminStateChanged(final BoardData boardData, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (BoardListener boardListener : BoardModel.this.myBoardListeners) {
                    boardListener.adminStateChanged(boardData, string);
                }
            }
        });
    }

    private void hwTestResultChanged(final BoardData boardData, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (BoardListener boardListener : BoardModel.this.myBoardListeners) {
                    boardListener.hwTestResultChanged(boardData, string);
                }
            }
        });
    }

    private void reportHwTestProblems(final Map map, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (HwTestProgressReportListener hwTestProgressReportListener : BoardModel.this.progressReportListeners) {
                    hwTestProgressReportListener.reportHwTestDoneWithProblems(map, bl);
                }
            }
        });
    }

    private void reportHwTest() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (HwTestProgressReportListener hwTestProgressReportListener : BoardModel.this.progressReportListeners) {
                    hwTestProgressReportListener.reportHwTestDone();
                }
            }
        });
    }

    private void reportBoards() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (HwTestProgressReportListener hwTestProgressReportListener : BoardModel.this.progressReportListeners) {
                    hwTestProgressReportListener.reportCollectBoardsDone();
                }
            }
        });
    }

    private void reportStatusBar(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                for (HwTestProgressReportListener hwTestProgressReportListener : BoardModel.this.progressReportListeners) {
                    hwTestProgressReportListener.reportStatusBarMessage(n);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private BoardData findBoard(String string) {
        if (this.myBoards == null) {
            return null;
        }
        Iterator iterator = this.myBoards.iterator();
        BoardData boardData = null;
        while (iterator.hasNext()) {
            String string2;
            boardData = (BoardData)iterator.next();
            if (string.endsWith(boardData.getBoardLdn())) {
                return boardData;
            }
            String string3 = boardData.getPiuOrAuxPiu().getDN();
            if (string.endsWith(string3)) {
                return boardData;
            }
            BemMo bemMo = boardData.getPiuDevice();
            if (bemMo == null || !string.endsWith(string2 = bemMo.getDN())) continue;
            return boardData;
        }
        if (BEMTrace.ENABLED) {
            BemLog.logNotify("findBoard() - No matching board was found for ldn: " + string);
        }
        return null;
    }

    private class CollectBoardsThread
    extends Thread {
        public CollectBoardsThread() {
            super("HW test collect boards thread");
        }

        public void run() {
            block68: {
                if (BoardModel.this.myBoards != null) {
                    return;
                }
                if (BEMTrace.ENABLED) {
                    BemLog.logNotify("Starting collecting boards");
                }
                String string = null;
                BoardModel.this.myBoards = new Vector();
                try {
                    BemMo bemMo = BemMoImpl.getRoot();
                    BemMo[] bemMoArray = bemMo.getChildren(1, "Equipment", "");
                    BemMo bemMo2 = bemMoArray[0];
                    BoardData boardData = null;
                    BemMo[] bemMoArray2 = bemMo2.getChildren(1, "", "");
                    for (int i = 0; i < bemMoArray2.length; ++i) {
                        int n;
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        BemMo[] bemMoArray3;
                        BemMo bemMo3 = bemMoArray2[i];
                        String string2 = bemMo3.getId();
                        String string3 = bemMo3.getType();
                        string = null;
                        if (string3.equals("Subrack")) {
                            bemMoArray3 = bemMo3.getChildren(4, "", "");
                            if (bemMoArray3 == null || bemMoArray3.length <= 0) continue;
                            for (int j = 0; j < bemMoArray3.length; ++j) {
                                BemMo bemMo4;
                                Object object5;
                                object4 = bemMoArray3[j];
                                String string4 = object4.getType();
                                if (string4.equals("FanDeviceGroup")) {
                                    boardData = string2.equals("1") ? new BoardData(object4.getParent(), (BemMo)object4, "BB: FAN") : new BoardData(object4.getParent(), (BemMo)object4, "RF: FAN");
                                    BoardModel.this.myBoards.add(boardData);
                                    continue;
                                }
                                if (string4.equals("Slot")) continue;
                                if (BoardData.isDeviceGroup(string4)) {
                                    object5 = object4;
                                    bemMo4 = object5.getParent();
                                    object3 = bemMo4.getParent();
                                    object2 = object3.getId();
                                    if (bemMo4.getType().equals("PiuDevice")) continue;
                                    string = string2.equals("1") ? "BB: " + (String)object2 + ": " : "RF: " + (String)object2 + ": ";
                                    boardData = new BoardData(bemMo4, (BemMo)object5, string);
                                    BoardModel.this.myBoards.add(boardData);
                                    continue;
                                }
                                if (string4.equals("PlugInUnit") || !string4.equals("PiuDevice")) continue;
                                object5 = object4;
                                bemMo4 = object5.getParent();
                                object3 = bemMo4.getParent();
                                object2 = object3.getId();
                                object = object5.getChildren(1, "", "");
                                BemMo bemMo5 = null;
                                String string5 = null;
                                if (object == null || ((BemMo[])object).length <= 0) continue;
                                for (int k = 0; k < ((BemMo[])object).length; ++k) {
                                    bemMo5 = object[k];
                                    string5 = bemMo5.getType();
                                    String string6 = null;
                                    if (string5.equals("RaxDeviceGroup")) {
                                        string6 = "DUW: " + (String)object2 + ": ";
                                    } else if (string5.equals("TxDeviceGroup")) {
                                        string6 = "DUW: " + (String)object2 + ": ";
                                    } else if (string5.equals("DeviceGroup")) {
                                        string6 = "DUW: " + (String)object2 + ": ";
                                    }
                                    if (string6 == null || !BoardData.isDeviceGroup(string5)) continue;
                                    boardData = new BoardData(bemMo4, bemMo5, string6);
                                    BoardModel.this.myBoards.add(boardData);
                                }
                            }
                            continue;
                        }
                        if (string3.equals("McpaSubrack")) {
                            bemMoArray3 = bemMo3.getChildren(3, "", "");
                            if (bemMoArray3 == null || bemMoArray3.length <= 0) continue;
                            BemMo bemMo6 = null;
                            object4 = null;
                            BemMo bemMo7 = null;
                            String string7 = null;
                            string = null;
                            for (n = 0; n < bemMoArray3.length; ++n) {
                                bemMo6 = bemMoArray3[n];
                                object4 = bemMo6.getType();
                                if (((String)object4).equals("McpaDeviceGroup")) {
                                    if (BoardData.isDeviceGroup("McpaDeviceGroup")) {
                                        bemMo7 = bemMo6.getParent().getParent();
                                        string7 = bemMo7.getId();
                                        string = "MCPA: " + string7 + ": ";
                                    }
                                } else if (((String)object4).equals("FanDeviceGroup") && BoardData.isDeviceGroup("FanDeviceGroup")) {
                                    string = "MCPA: FAN";
                                }
                                if (!((String)object4).equals("McpaDeviceGroup") && !((String)object4).equals("FanDeviceGroup")) continue;
                                boardData = new BoardData(bemMo6.getParent(), bemMo6, string);
                                BoardModel.this.myBoards.add(boardData);
                            }
                            continue;
                        }
                        if (string3.equals("CuSubrack")) {
                            bemMoArray3 = bemMo3.getChildren(2, "CuDeviceGroup", "");
                            BemMo bemMo8 = null;
                            object4 = null;
                            if (bemMoArray3 == null || bemMoArray3.length <= 0) continue;
                            for (int j = 0; j < bemMoArray3.length; ++j) {
                                bemMo8 = bemMoArray3[j];
                                object4 = bemMo8.getType();
                                if (!((String)object4).equals("CuDeviceGroup") || !BoardData.isDeviceGroup((String)object4)) continue;
                                boardData = new BoardData(bemMo8.getParent(), bemMo8, "CU: ");
                                BoardModel.this.myBoards.add(boardData);
                            }
                            continue;
                        }
                        if (string3.equals("PowerSupplySubrack")) {
                            bemMoArray3 = bemMo3.getChildren(3, "", "");
                            if (bemMoArray3 == null || bemMoArray3.length <= 0) continue;
                            BemMo bemMo9 = null;
                            object4 = null;
                            BemMo bemMo10 = null;
                            String string8 = null;
                            for (n = 0; n < bemMoArray3.length; ++n) {
                                bemMo9 = bemMoArray3[n];
                                object4 = bemMo9.getType();
                                if (((String)object4).equals("PcuDeviceGroup")) {
                                    if (BoardData.isDeviceGroup("PcuDeviceGroup")) {
                                        bemMo10 = bemMo9.getParent().getParent();
                                        string8 = bemMo10.getId();
                                        string = "PCU: " + string8 + ": ";
                                    }
                                } else if (((String)object4).equals("FanDeviceGroup") && BoardData.isDeviceGroup("FanDeviceGroup")) {
                                    string = "PCU: FAN";
                                }
                                if (!((String)object4).equals("PcuDeviceGroup") && !((String)object4).equals("FanDeviceGroup")) continue;
                                boardData = new BoardData(bemMo9.getParent(), bemMo9, string);
                                BoardModel.this.myBoards.add(boardData);
                            }
                            continue;
                        }
                        if (string3.equals("AuxPlugInUnit")) {
                            bemMoArray3 = bemMo3.getChildren(1, "", "");
                            BemMo bemMo11 = null;
                            object4 = null;
                            if (bemMoArray3 == null || bemMoArray3.length <= 0) continue;
                            for (int j = 0; j < bemMoArray3.length; ++j) {
                                bemMo11 = bemMoArray3[j];
                                object4 = bemMo11.getType();
                                String string9 = null;
                                if (((String)object4).equals("XalmDeviceGroup")) {
                                    string9 = "XALM: ";
                                } else if (((String)object4).equals("PauDeviceGroup")) {
                                    string9 = "PAU: ";
                                } else if (((String)object4).equals("SaiuDeviceGroup")) {
                                    string9 = "SAIU: ";
                                } else if (((String)object4).equals("FcuDeviceGroup")) {
                                    string9 = "FCU: ";
                                } else if (((String)object4).equals("CluDeviceGroup")) {
                                    string9 = "CLU: ";
                                } else if (((String)object4).equals("RuDeviceGroup")) {
                                    string9 = "RU: ";
                                } else if (((String)object4).equals("FuDeviceGroup")) {
                                    string9 = "FU: ";
                                } else if (((String)object4).equals("DeviceGroup")) {
                                    string9 = bemMo11.getId() + ":";
                                }
                                if (string9 == null || !BoardData.isDeviceGroup((String)object4)) continue;
                                boardData = new BoardData(bemMo3, bemMo11, string9);
                                BoardModel.this.myBoards.add(boardData);
                            }
                            continue;
                        }
                        if (string3.equals("SectorAntenna")) {
                            bemMoArray3 = bemMo3.getChildren(2, "", "");
                            BemMo bemMo12 = null;
                            object4 = null;
                            String string10 = null;
                            if (bemMoArray3 == null || bemMoArray3.length <= 0) continue;
                            for (int j = 0; j < bemMoArray3.length; ++j) {
                                bemMo12 = bemMoArray3[j];
                                object4 = bemMo12.getType();
                                string10 = "Sector " + string2 + ": ";
                                if (!((String)object4).equals("RetuDeviceGroup") && !((String)object4).equals("AscDeviceGroup") && !((String)object4).equals("RruDeviceGroup") && !((String)object4).equals("DeviceGroup") || !BoardData.isDeviceGroup((String)object4)) continue;
                                String string11 = bemMo12.getDN();
                                object3 = BemUtil.extractRdnId(string11, "AuxPlugInUnit");
                                if (object3 != null && ((String)object3).startsWith("RRUW-")) {
                                    object2 = string10 + (String)object3;
                                    boardData = new BoardData(bemMo12.getParent(), bemMo12, string10, (String)object2);
                                } else {
                                    boardData = new BoardData(bemMo12.getParent(), bemMo12, string10);
                                }
                                BoardModel.this.myBoards.add(boardData);
                            }
                            continue;
                        }
                        if (!string3.equals("RbsSubrack") || (bemMoArray3 = bemMo3.getChildren(3, "", "")) == null || bemMoArray3.length <= 0) continue;
                        BemMo bemMo13 = null;
                        object4 = null;
                        BemMo bemMo14 = null;
                        String string12 = null;
                        string = null;
                        for (n = 0; n < bemMoArray3.length; ++n) {
                            bemMo13 = bemMoArray3[n];
                            object4 = bemMo13.getType();
                            if (((String)object4).equals("FuDeviceGroup")) {
                                if (BoardData.isDeviceGroup("FuDeviceGroup")) {
                                    bemMo14 = bemMo13.getParent().getParent();
                                    string12 = bemMo14.getId();
                                    string = "FU: " + string12 + ": ";
                                }
                            } else if (((String)object4).equals("RuDeviceGroup")) {
                                if (BoardData.isDeviceGroup("RuDeviceGroup")) {
                                    bemMo14 = bemMo13.getParent().getParent();
                                    string12 = bemMo14.getId();
                                    string = "RU: " + string12 + ": ";
                                }
                            } else if (((String)object4).equals("PsuDeviceGroup")) {
                                if (BoardData.isDeviceGroup("PsuDeviceGroup")) {
                                    bemMo14 = bemMo13.getParent().getParent();
                                    if (((Object)bemMo14).toString().equals("RbsSlot")) {
                                        string12 = bemMo14.getId();
                                        string = "PSU: " + string12 + ": ";
                                    } else {
                                        object3 = null;
                                        object2 = bemMo13.getParent();
                                        object = object2.getType();
                                        if (((String)object).equals(MimAuxPlugInUnit.MOTYPENAME)) {
                                            BoardModel.this.moHandler = new MoHandlerImpl();
                                            object3 = (Integer)BoardModel.this.moHandler.getAttribute((BemMo)object2, "hubPosition");
                                        }
                                        bemMo14 = bemMo13.getParent();
                                        string12 = bemMo14.getId();
                                        string = "PSU: PS" + string12 + ": " + BoardModel.this.convertHubType((Integer)object3) + ": ";
                                    }
                                }
                            } else if (((String)object4).equals("BfuDeviceGroup")) {
                                if (BoardData.isDeviceGroup("BfuDeviceGroup")) {
                                    bemMo14 = bemMo13.getParent().getParent();
                                    string12 = bemMo14.getId();
                                    string = "BFU: " + string12 + ": ";
                                }
                            } else if (((String)object4).equals("DeviceGroup") && BoardData.isDeviceGroup("DeviceGroup")) {
                                bemMo14 = bemMo13.getParent().getParent();
                                string12 = bemMo14.getId();
                                object3 = bemMo3.getId();
                                string = (String)object3 + ": " + string12 + ": ";
                            }
                            if (!((String)object4).equals("FuDeviceGroup") && !((String)object4).equals("RuDeviceGroup") && !((String)object4).equals("PsuDeviceGroup") && !((String)object4).equals("BfuDeviceGroup") && !((String)object4).equals("DeviceGroup")) continue;
                            boardData = new BoardData(bemMo13.getParent(), bemMo13, string);
                            BoardModel.this.myBoards.add(boardData);
                        }
                    }
                    BoardModel.this.subscribeAvc(bemMo2);
                }
                catch (Exception exception) {
                    if (!BEMTrace.ENABLED) break block68;
                    BEMTrace.exception(BoardModel.class, "collectBoards()", exception);
                }
            }
            BoardModel.this.reportBoards();
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("Collecting boards done");
            }
        }
    }

    private class HwTestThread
    extends Thread {
        private Board[] boards;

        public HwTestThread(Board[] boardArray) {
            super("HW test thread");
            this.boards = boardArray;
        }

        public void run() {
            int n;
            Object object;
            Object object2;
            int n2;
            if (this.boards == null) {
                return;
            }
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("HW test will be started on " + this.boards.length + " boards");
            }
            HashMap<Board, Object> hashMap = new HashMap<Board, Object>();
            Vector<Board> vector = new Vector<Board>();
            NalTransaction nalTransaction = Nal.getFactory().createTransaction();
            for (n2 = 0; n2 < this.boards.length; ++n2) {
                BoardData boardData = (BoardData)this.boards[n2];
                BemMo bemMo = boardData.getPiuOrAuxPiu();
                BemMo bemMo2 = boardData.getDeviceGroup();
                BemMo bemMo3 = boardData.getPiuDevice();
                NalNameValue[] nalNameValueArray = new NalNameValue[1];
                try {
                    int n3 = bemMo3 != null ? ((Integer)bemMo3.getAttribute("administrativeState")).intValue() : ((Integer)bemMo.getAttribute("administrativeState")).intValue();
                    if (n3 == 0) {
                        nalNameValueArray[0] = Nal.getFactory().getNameValue("testId", "1");
                        bemMo2.action("startHwTest", nalNameValueArray, nalTransaction);
                        vector.add(this.boards[n2]);
                        continue;
                    }
                    object2 = "HWT_NOT_STARTED_REASON_UNLOCKED";
                    object = BoardModel.this.myLanguageBundle.getString((String)object2) + "\n";
                    hashMap.put(this.boards[n2], object);
                    if (!BEMTrace.ENABLED) continue;
                    BemLog.logNotify("HW test start failed on " + bemMo2.getDN() + " (Not locked)");
                    continue;
                }
                catch (NalCmException nalCmException) {
                    BemLog.exceptionRaised("HW test start failed on " + bemMo2.getDN(), nalCmException);
                    hashMap.put(this.boards[n2], nalCmException.getMessage());
                }
            }
            nalTransaction.commit();
            n2 = hashMap.size();
            int n4 = vector.size();
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("HW test was successfully started on " + n4 + " boards");
            }
            if (n2 > 0) {
                if (n4 == 0) {
                    BoardModel.this.reportStatusBar(3);
                } else {
                    BoardModel.this.reportStatusBar(2);
                }
            } else {
                BoardModel.this.reportStatusBar(1);
            }
            int n5 = 1000;
            int n6 = 100;
            for (n = 0; n < n6 && vector.size() > 0; n += 1) {
                int n7 = vector.size();
                for (int i = 0; i < n7; ++i) {
                    object2 = (BoardData)vector.get(i);
                    object = ((BoardData)object2).getDeviceGroup();
                    BemMo bemMo = ((BoardData)object2).getPiuDevice();
                    int n8 = bemMo != null ? ((Integer)bemMo.getAttribute("hwTestResult")).intValue() : ((Integer)object.getAttribute("hwTestResult")).intValue();
                    ((BoardData)object2).setHwTestResult(n8);
                    if (n8 == 0 || n8 == 1) {
                        BoardModel.this.hwTestResultChanged((BoardData)object2, ((BoardData)object2).getBoardName());
                        vector.remove(i);
                        --n7;
                        --i;
                        continue;
                    }
                    BoardModel.this.hwTestResultChanged((BoardData)object2, ((BoardData)object2).getBoardName());
                }
                if (n7 <= 0) continue;
                if (BEMTrace.ENABLED) {
                    BemLog.logNotify("HW test still running on " + n7 + " board(s)");
                }
                try {
                    Thread.sleep(n5);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    BemLog.exceptionRaised("Sleep was interrupted", interruptedException);
                }
            }
            if (n2 > 0) {
                n = this.boards.length == n2 ? 1 : 0;
                BoardModel.this.reportHwTestProblems(hashMap, n != 0);
            } else {
                BoardModel.this.reportHwTest();
            }
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("HW test done");
            }
        }
    }

    private class UnlockThread
    extends Thread {
        private Board[] boards;

        public UnlockThread(Board[] boardArray) {
            super("HW test unlock thread");
            this.boards = boardArray;
        }

        public void run() {
            if (this.boards == null) {
                return;
            }
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("Starting unlocking boards. No. of boards: " + this.boards.length);
            }
            for (int i = 0; i < this.boards.length; ++i) {
                BoardData boardData = (BoardData)this.boards[i];
                BemMo bemMo = boardData.getPiuOrAuxPiu();
                BemMo bemMo2 = boardData.getDeviceGroup();
                BemMo bemMo3 = boardData.getPiuDevice();
                NalTransaction nalTransaction = Nal.getFactory().createTransaction();
                int n = 1;
                Integer n2 = n;
                try {
                    int n3 = (Integer)bemMo2.getAttribute("availabilityStatus");
                    int n4 = 1;
                    if ((n3 &= n4) == 0) {
                        if (bemMo3 != null) {
                            bemMo3.setAttribute("administrativeState", n2, nalTransaction);
                        } else {
                            bemMo.setAttribute("administrativeState", n2, nalTransaction);
                        }
                        boardData.setAdminState(n);
                        String string = boardData.getBoardName();
                        BoardModel.this.adminStateChanged(boardData, string);
                    }
                    nalTransaction.commit();
                    continue;
                }
                catch (Exception exception) {
                    String string = "Unable to unlock board: " + bemMo2.getDN();
                    BemLog.exceptionRaised(string, exception);
                    nalTransaction.rollback(string, exception);
                }
            }
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("Unlock done");
            }
        }
    }

    private class LockThread
    extends Thread {
        private Board[] boards;

        public LockThread(Board[] boardArray) {
            super("HW test lock thread");
            this.boards = boardArray;
        }

        public void run() {
            if (this.boards == null) {
                return;
            }
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("Starting locking boards. No. of boards: " + this.boards.length);
            }
            for (int i = 0; i < this.boards.length; ++i) {
                BoardData boardData = (BoardData)this.boards[i];
                BemMo bemMo = boardData.getPiuOrAuxPiu();
                BemMo bemMo2 = boardData.getPiuDevice();
                NalTransaction nalTransaction = Nal.getFactory().createTransaction();
                int n = 0;
                Integer n2 = n;
                try {
                    int n3;
                    if (bemMo2 != null) {
                        n3 = (Integer)bemMo2.getAttribute("administrativeState");
                        if (n3 != 0) {
                            bemMo2.setAttribute("administrativeState", n2, nalTransaction);
                        }
                    } else {
                        n3 = (Integer)bemMo.getAttribute("administrativeState");
                        if (n3 != 0) {
                            bemMo.setAttribute("administrativeState", n2, nalTransaction);
                        }
                    }
                    nalTransaction.commit();
                }
                catch (Exception exception) {
                    String string = "Failed to lock: " + boardData.getBoardLdn();
                    BemLog.exceptionRaised(string, exception);
                    nalTransaction.rollback(string, exception);
                }
                boardData.setAdminState(n);
                String string = boardData.getBoardName();
                BoardModel.this.adminStateChanged(boardData, string);
            }
            if (BEMTrace.ENABLED) {
                BemLog.logNotify("Lock done");
            }
        }
    }

    private class AvcListener
    implements NalCmNotificationConsumer {
        private AvcListener() {
        }

        public void moCreated(String string) {
        }

        public void moDeleted(String string) {
        }

        public void attributeValueChanged(String string, NalNameValue[] nalNameValueArray) {
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                BoardData boardData;
                int n;
                String string2 = nalNameValueArray[i].getName();
                Object object = nalNameValueArray[i].getValue();
                if (string2.equals("hwTestResult")) {
                    if (BEMTrace.ENABLED) {
                        BemLog.logNotify("hwTestResult attribute value changed. LDN = " + string);
                    }
                    n = (Integer)object;
                    boardData = BoardModel.this.findBoard(string);
                    if (boardData == null) continue;
                    boardData.setHwTestResult(n);
                    BoardModel.this.hwTestResultChanged(boardData, boardData.getBoardName());
                    continue;
                }
                if (!string2.equals("administrativeState")) continue;
                if (BEMTrace.ENABLED) {
                    BemLog.logNotify("administrativeState attribute value changed. LDN = " + string);
                }
                n = (Integer)object;
                boardData = BoardModel.this.findBoard(string);
                if (boardData == null) continue;
                boardData.setAdminState(n);
                BoardModel.this.adminStateChanged(boardData, boardData.getBoardName());
            }
        }

        public Object getNative() {
            return null;
        }

        public String toString() {
            String string = "BoardModel.AvcListener";
            return string;
        }
    }
}

